/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.db.UIArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.property.PropertyFilter;

public class HashPartitionQuantityPanel
extends JPanel {
    private JLabel m_hashCountLabel = new JLabel();
    private SpinnerNumberModel m_hashCountModel = new SpinnerNumberModel(new Integer(2), new Integer(1), null, new Integer(1));
    private JSpinner m_hashCountSpinner = new JSpinner(this.m_hashCountModel);
    private JLabel m_tblsLabel = new JLabel();
    private DefaultListModel m_tblsFromModel = new DefaultListModel();
    private ListPicker m_tblsFromPick = new ListPicker(new JList(this.m_tblsFromModel));
    private DefaultListModel m_tblsToModel = new DefaultListModel();
    private ReorderableListPicker m_tblsToPick = new ReorderableListPicker(new JList(this.m_tblsToModel));
    private Shuttle m_tblsShuttle = new Shuttle();

    public HashPartitionQuantityPanel() {
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_hashCountLabel, (Component)this.m_hashCountSpinner, (String)UIArb.getString(490));
        this.m_tblsLabel.setText(UIArb.getString(491));
        this.m_tblsShuttle.setFromPicker((ItemPicker)this.m_tblsFromPick);
        this.m_tblsShuttle.setToPicker((ItemPicker)this.m_tblsToPick);
        int y = 0;
        this.add((Component)this.m_hashCountLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_hashCountSpinner, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 20), 0, 0));
        this.add((Component)this.m_tblsLabel, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_tblsShuttle, new GridBagConstraints(0, ++y, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    @Deprecated
    public void init(DBObjectProvider pro, OracleTablePartitions otp, String[] tablespaces, boolean editing) {
        this.init(pro, otp, editing);
    }

    public void init(DBObjectProvider pro, OracleTablePartitions otp, boolean editing) {
        this.m_tblsFromModel.removeAllElements();
        this.m_tblsToModel.removeAllElements();
        PropertyFilter permFilter = new PropertyFilter("properties/TablespaceType", (Object)Tablespace.TablespaceType.PERMANENT);
        DBObjectCriteria critter = new DBObjectCriteria(Tablespace.class, new String[0]);
        critter.addFilter((DBObjectFilter)permFilter);
        try {
            for (Tablespace t : pro.listObjects(critter)) {
                this.m_tblsFromModel.addElement(pro.getExternalName(t.getName()));
            }
        }
        catch (DBException e) {
            // empty catch block
        }
        String[] chosenTbls = otp.getHashQuantityTablespaces();
        for (int i = 0; i < chosenTbls.length; ++i) {
            String tablespaceName = pro.getExternalName(chosenTbls[i]);
            this.m_tblsFromModel.removeElement(tablespaceName);
            this.m_tblsToModel.addElement(tablespaceName);
        }
        Integer q = otp.getHashQuantity();
        if (q != null) {
            this.m_hashCountModel.setValue(q);
        }
        if (editing & pro instanceof Database) {
            this.setEnableTablespaces(false);
        }
    }

    public void commit(DBObjectProvider pro, Table tab, OracleTablePartitions otp) throws ValidationException {
        Number num = this.m_hashCountModel.getNumber();
        otp.setHashQuantity(num == null ? null : new Integer(num.intValue()));
        Enumeration tblsEnum = this.m_tblsToModel.elements();
        String[] tbls = new String[this.m_tblsToModel.size()];
        for (int i = 0; i < tbls.length; ++i) {
            tbls[i] = pro.getInternalName((String)tblsEnum.nextElement());
        }
        otp.setHashQuantityTablespaces(tbls);
        pro.validateObjectProperty((DBObject)otp, "hashQuantity");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_hashCountLabel.setEnabled(enabled);
        this.m_hashCountSpinner.setEnabled(enabled);
        this.setEnableTablespaces(enabled);
    }

    private void setEnableTablespaces(boolean enabled) {
        this.m_tblsLabel.setEnabled(enabled);
        this.m_tblsShuttle.setEnabled(enabled);
        this.m_tblsFromPick.getList().setEnabled(enabled);
        this.m_tblsToPick.getList().setEnabled(enabled);
    }
}

