/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.table.FKPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.dialogs.MessageDialog;

public class FKEditDialog
extends JPanel
implements VetoableChangeListener {
    public static final String FK_HELP_ID = "f1_offdbfkconstraint_html";
    private JEWTDialog m_dialog;
    private JWrappedLabel m_desc;
    private FKPanel m_fkPanel;

    public FKEditDialog(Namespace namespace) {
        this.createComponents(namespace);
        this.layoutComponents(namespace);
    }

    public static boolean editFK(DBObjectProvider prv, FKConstraint fk, Component parent, Table sourceTable) throws DBException {
        String TITLE = UIArb.getString(734);
        if (fk == null || prv == null) {
            throw new IllegalArgumentException("Null information supplied to Edit Foreign Key dialog");
        }
        int bit = 7;
        JEWTDialog dialog = JEWTDialog.createDialog((Component)parent, (String)TITLE, (int)bit);
        Namespace namespace = new Namespace();
        namespace.put("DBObjectProvider", (Object)prv);
        namespace.put("NewObject", (Object)fk.getParent());
        namespace.put("NewChildObject", (Object)fk);
        namespace.put("Modifiable", (Object)true);
        namespace.put("otherCons", (Object)new FKConstraint[0]);
        namespace.put("ConstraintsInfoVerifier", null);
        namespace.put("sourceTable", (Object)sourceTable);
        namespace.put("standAlone", (Object)true);
        FKEditDialog panel = new FKEditDialog(namespace);
        dialog.setContent((Component)panel);
        dialog.setResizable(true);
        dialog.setPreferredSize(500, 350);
        panel.setDialog(dialog);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, FK_HELP_ID);
        if (dialog.runDialog()) {
            return true;
        }
        dialog.dispose();
        return false;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
            try {
                this.m_fkPanel.commit();
            }
            catch (TraversalException e) {
                MessageDialog.error((Component)this, (Object)e.getMessage(), (String)UIArb.getString(736), null);
                throw new PropertyVetoException("invalid foreign key", evt);
            }
        }
    }

    private void createComponents(Namespace namespace) {
        Table tbl = (Table)namespace.get("NewObject");
        String name = tbl.getName();
        String text = UIArb.format(735, name);
        this.m_desc = new JWrappedLabel(text);
        this.m_fkPanel = new FKPanel(false);
        try {
            this.m_fkPanel.init(namespace);
        }
        catch (TraversalException e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents(Namespace namespace) {
        this.setLayout(new BorderLayout(0, 15));
        this.add((Component)this.m_desc, "North");
        this.add((Component)this.m_fkPanel, "Center");
    }

    private void setDialog(JEWTDialog dialog) {
        this.m_dialog = dialog;
        this.m_dialog.addVetoableChangeListener((VetoableChangeListener)this);
    }
}

