/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.table.ColumnEditorPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.dialogs.MessageDialog;

public class ColumnDialog
extends JPanel
implements VetoableChangeListener {
    public static final String COLUMN_HELP_ID = "f1_offdbpkconscolumn_html";
    private JEWTDialog m_dialog;
    private JWrappedLabel m_desc;
    private ColumnEditorPanel m_colPanel;
    private Column m_col;

    public ColumnDialog(DBObjectProvider prv, Table sourceTable, Column col, boolean standalone) {
        this.m_col = col;
        this.createComponents(prv, sourceTable, standalone);
        this.layoutComponents();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, COLUMN_HELP_ID);
    }

    public static boolean createColumn(DBObjectProvider prv, Table sourceTable, Component parent) throws DBException {
        return ColumnDialog.editColumn(prv, sourceTable, null, parent);
    }

    public static boolean editColumn(DBObjectProvider prv, Table sourceTable, Column col, Component parent) throws DBException {
        String TITLE = UIArb.getString(741);
        if (sourceTable == null || prv == null) {
            throw new IllegalArgumentException("Null information supplied to Edit Column dialog");
        }
        boolean created = false;
        if (col == null) {
            col = ColumnDialog.createDefaultColumn(prv, sourceTable);
            created = true;
        }
        int bit = 7;
        JEWTDialog dialog = JEWTDialog.createDialog((Component)parent, (String)TITLE, (int)bit);
        ColumnDialog panel = new ColumnDialog(prv, sourceTable, col, true);
        dialog.setContent((Component)panel);
        dialog.setResizable(true);
        dialog.setPreferredSize(500, 400);
        panel.setDialog(dialog);
        if (dialog.runDialog()) {
            return true;
        }
        if (created) {
            sourceTable.removeColumn(col);
        }
        dialog.dispose();
        return false;
    }

    private void createComponents(DBObjectProvider prv, Table tbl, boolean standalone) {
        String name = tbl.getName();
        String text = UIArb.format(742, name);
        this.m_desc = new JWrappedLabel(text);
        this.m_colPanel = new ColumnEditorPanel();
        this.m_colPanel.init(prv, tbl.getSchema(), null);
        this.m_colPanel.setColumn(this.m_col);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(0, 15));
        this.add((Component)this.m_desc, "North");
        this.add((Component)((Object)this.m_colPanel), "Center");
    }

    private void setDialog(JEWTDialog dialog) {
        this.m_dialog = dialog;
        this.m_dialog.addVetoableChangeListener((VetoableChangeListener)this);
    }

    private static Column createDefaultColumn(DBObjectProvider pr, Table table) {
        Column col = (Column)pr.getObjectFactory().newObject(Column.class, (DBObject)table);
        if (col.getName() == null) {
            String colName = "COLUMN1";
            Column[] existingTabCols = table.getColumns();
            ArrayList<String> colNames = new ArrayList<String>();
            for (int i = 0; i < existingTabCols.length; ++i) {
                Column compareCol = existingTabCols[i];
                if (compareCol == null) continue;
                colNames.add(compareCol.getName());
            }
            colName = DBUtil.getUniqueName(colNames, (String)colName, (boolean)true);
            col.setName(colName);
        }
        if (col.getDataTypeUsage() == null) {
            DataType datatype = pr.getOrCreateDataType("NUMBER");
            DataTypeUsage dtu = datatype.createDefaultUsage();
            col.setDataTypeUsage(dtu);
        }
        table.addColumn(col);
        return col;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
            try {
                this.m_colPanel.commit(this.m_col);
            }
            catch (TraversalException e) {
                MessageDialog.error((Component)this, (Object)e.getMessage(), (String)UIArb.getString(739), null);
                throw new PropertyVetoException("invalid column", evt);
            }
        }
    }
}

