/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.ConstraintPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;

public abstract class BaseConstraintPanel
extends BaseInfoPanel {
    private JPanel pnlList = new JPanel();
    private ConstraintPanel pnlDetail = this.getDetailPanel();
    private GridBagLayout layList = new GridBagLayout();
    private GridBagLayout layMain = new GridBagLayout();
    private JLabel lblConstraints = new JLabel();
    private JScrollPane scrConstraints = new JScrollPane();
    private JButton btnAdd = new JButton();
    private JButton btnRemove = new JButton();
    private JList lstConstraints = new JList();
    private JPanel pnlButtons = new JPanel();
    private GridLayout layButtons = new GridLayout();
    private EventHandler _handler = new EventHandler();
    private DBObjectRenderer renderer = this.getRenderer();
    private DefaultListModel _mdlCons = new DefaultListModel();
    private Relation _relation;
    private Namespace _cNamespace;
    private Constraint _con;
    private Constraint _selectedCon;
    private boolean _isNewConstraint = false;
    private int _currentSelection = 0;
    private List _consList = new ArrayList();
    private static Map s_postfixes = new HashMap();

    public BaseConstraintPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext dataContext) {
        int idx;
        this._cNamespace = new Namespace((Namespace)dataContext);
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        if (callbacks != null) {
            callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        }
        this.init((DBObjectProvider)dataContext.find("DBObjectProvider"), (ConstraintsInfoVerifier)dataContext.find("ConstraintsInfoVerifier"));
        this._relation = (Relation)dataContext.find("NewObject");
        this._updateDetailPanel();
        ConstraintsInfoVerifier verifier = (ConstraintsInfoVerifier)this.getVerifier();
        this.btnAdd.setEnabled(verifier == null || verifier.canAddConstraints());
        this._consList = new ArrayList<Constraint>(Arrays.asList(this._relation.getConstraints()));
        Constraint[] cons = this.findSupportedConstraints(this._relation);
        this.lstConstraints.removeListSelectionListener(this._handler);
        this._mdlCons.clear();
        for (int i = 0; i < cons.length; ++i) {
            this._mdlCons.addElement(cons[i]);
            this._consList.remove(cons[i]);
        }
        this.lstConstraints.addListSelectionListener(this._handler);
        int sel = 0;
        Object defaultObject = dataContext.find("DefaultChild");
        if (defaultObject != null && (idx = this._mdlCons.indexOf(defaultObject)) != -1) {
            sel = idx;
        }
        if (cons.length > 0) {
            this.setSelectedConstraint(sel);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this._commitDetail(true);
        Constraint[] oldCons = this._consList.toArray(new Constraint[this._consList.size()]);
        Constraint[] newCons = this._getConstraintsFromList();
        Constraint[] cons = new Constraint[oldCons.length + newCons.length];
        System.arraycopy(oldCons, 0, cons, 0, oldCons.length);
        System.arraycopy(newCons, 0, cons, oldCons.length, newCons.length);
        this._relation.setConstraints(cons);
        this._con = null;
    }

    private Constraint[] _getConstraintsFromList() {
        Object[] newCons = new Constraint[this._mdlCons.getSize()];
        this._mdlCons.copyInto(newCons);
        return newCons;
    }

    private void jbInit() throws Exception {
        DBUIResourceHelper reshelp = new DBUIResourceHelper(this.getPanelName());
        this.setLayout(this.layMain);
        this.pnlList.setLayout(this.layList);
        reshelp.resLabel(this.lblConstraints, this.lstConstraints, this.getListLabel(), "ConstraintList");
        reshelp.resButton(this.btnAdd, UIArb.getString(650), "Add");
        this.btnAdd.addActionListener(this._handler);
        reshelp.resButton(this.btnRemove, UIArb.getString(651), "Remove");
        this.btnRemove.addActionListener(this._handler);
        this.lstConstraints.setVisibleRowCount(4);
        this.lstConstraints.setSelectionMode(0);
        this.lstConstraints.setModel(this._mdlCons);
        this.lstConstraints.addListSelectionListener(this._handler);
        this.lstConstraints.setCellRenderer(this.renderer);
        this.pnlButtons.setLayout(this.layButtons);
        this.layButtons.setColumns(1);
        this.layButtons.setRows(2);
        this.layButtons.setVgap(5);
        this.pnlList.add((Component)this.lblConstraints, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scrConstraints.getViewport().add((Component)this.lstConstraints, null);
        this.pnlList.add((Component)this.scrConstraints, new GridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlButtons.add((Component)this.btnAdd, null);
        this.pnlButtons.add((Component)this.btnRemove, null);
        this.pnlList.add((Component)this.pnlButtons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.pnlList, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((JPanel)((Object)this.pnlDetail), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
    }

    protected abstract ConstraintPanel getDetailPanel();

    protected abstract String getConstraintType();

    protected abstract String getListLabel();

    protected abstract String getPanelName();

    protected final Constraint createNewConstraint() {
        String cType = this.getConstraintType();
        Constraint result = "PKConstraint".equals(cType) ? (Constraint)this.getProvider().getObjectFactory().newObject(PKConstraint.class, (DBObject)this._relation) : ("FKConstraint".equals(cType) ? (Constraint)this.getProvider().getObjectFactory().newObject(FKConstraint.class, (DBObject)this._relation) : ("CheckConstraint".equals(cType) ? (Constraint)this.getProvider().getObjectFactory().newObject(CheckConstraint.class, (DBObject)this._relation) : (Constraint)this.getProvider().getObjectFactory().newObject(UniqueConstraint.class, (DBObject)this._relation)));
        result.setID(TemporaryObjectID.createID((DBObject)result));
        this._isNewConstraint = true;
        return result;
    }

    protected Constraint[] findSupportedConstraints(Relation table) {
        String cType = this.getConstraintType();
        Constraint[] relCons = table.getConstraints();
        ArrayList<Constraint> cons = new ArrayList<Constraint>();
        for (int i = 0; i < relCons.length; ++i) {
            if (!cType.equals(relCons[i].getConstraintType())) continue;
            cons.add(relCons[i]);
        }
        return cons.toArray(new Constraint[cons.size()]);
    }

    protected DBObjectRenderer getRenderer() {
        return new DBObjectRenderer();
    }

    private void _updateDetailPanel() {
        ConstraintsInfoVerifier verifier = (ConstraintsInfoVerifier)this.getVerifier();
        boolean canRemove = this._con != null && (verifier == null || verifier.canRemoveConstraints() && verifier.canRemoveConstraint(this._con));
        this.btnRemove.setEnabled(canRemove);
        boolean canModify = this._con != null && (verifier == null || verifier.canModifyConstraint(this._con));
        this._cNamespace.put("NewChildObject", (Object)this._con);
        this._cNamespace.put("Modifiable", (Object)canModify);
        this._cNamespace.put("otherCons", (Object)this._getConstraintsFromList());
        this._cNamespace.put("constraintPanel", (Object)this);
        try {
            this.pnlDetail.init(this._cNamespace);
        }
        catch (TraversalException ex) {
            this._con = null;
            this.lstConstraints.clearSelection();
        }
    }

    private void _showConstraintError(TraversalException ex) {
        ex.showMessageDialog((Component)((Object)this));
        int indexOfSelectedIndex = this.lstConstraints.getSelectedIndex();
        if (indexOfSelectedIndex < 0 || this._mdlCons.elementAt(indexOfSelectedIndex).equals(this._mdlCons.elementAt(this._currentSelection))) {
            this.setSelectedConstraint(this._currentSelection);
        } else if (this._currentSelection != indexOfSelectedIndex) {
            this.setSelectedConstraint(this._con);
        }
    }

    private void _updateSelection() {
        Constraint con = (Constraint)this.lstConstraints.getSelectedValue();
        if (con != this._con) {
            try {
                this._commitDetail(true);
                this._con = con;
                if (this._con == null || this._isNewConstraint) {
                    this._selectedCon = null;
                    this._isNewConstraint = false;
                } else {
                    this._selectedCon = (Constraint)con.copyTo(null);
                }
                this._updateDetailPanel();
            }
            catch (TraversalException ex) {
                this._showConstraintError(ex);
            }
        }
        ConstraintsInfoVerifier verifier = (ConstraintsInfoVerifier)this.getVerifier();
        boolean canRemove = con != null && (verifier == null || verifier.canRemoveConstraints() && verifier.canRemoveConstraint(con));
        this.btnRemove.setEnabled(canRemove);
    }

    private void _commitDetail(boolean verify) throws TraversalException {
        if (this._con != null) {
            ConstraintsInfoVerifier verifier;
            this.pnlDetail.commit();
            if (verify && (verifier = (ConstraintsInfoVerifier)this.getVerifier()) != null) {
                verifier.verifyConstraint(this._selectedCon, this._con);
            }
        }
    }

    protected static String findUniqueName(Relation tbl, Constraint con, Constraint[] otherCons, DBObjectProvider pro) {
        String baseName = con.getName() != null ? con.getName() : BaseConstraintPanel.getDefaultBaseName(tbl.getName(), con.getConstraintType(), pro);
        Constraint[] cons = tbl.getConstraints();
        if (otherCons.length > 0) {
            Constraint[] tmp = cons;
            cons = new Constraint[tmp.length + otherCons.length];
            System.arraycopy(tmp, 0, cons, 0, tmp.length);
            System.arraycopy(otherCons, 0, cons, tmp.length, otherCons.length);
        }
        return BaseConstraintPanel.findUniqueName(baseName, con, cons);
    }

    protected static String getDefaultBaseName(String relName, String conType, DBObjectProvider pro) {
        String name = null == relName ? "" : relName;
        int maxNameLength = pro.getDescriptor().getMaxNameLength("CONSTRAINT");
        String postfix = (String)s_postfixes.get(conType);
        if (pro.getDescriptor().getCasePolicy() == 1) {
            postfix = postfix.toLowerCase();
        }
        int maxlen = maxNameLength - postfix.length() - 2;
        return name.length() > maxlen ? name.substring(0, maxlen) + postfix : name + postfix;
    }

    protected static String getDefaultFKBaseName(String relName, String refName, DBObjectProvider pro) {
        return refName != null ? BaseConstraintPanel.getDefaultBaseName(relName + "_" + refName, "FKConstraint", pro) : BaseConstraintPanel.getDefaultBaseName(relName, "FKConstraint", pro);
    }

    protected static String findUniqueName(String base, Constraint con, Constraint[] cons) {
        HashSet<String> conSet = new HashSet<String>();
        if (cons != null) {
            for (int i = 0; i < cons.length; ++i) {
                if (con == cons[i]) continue;
                conSet.add(cons[i].getName());
            }
        }
        if (con instanceof PKConstraint && !conSet.contains(base)) {
            return base;
        }
        String name = null;
        int i = 1;
        while (name == null) {
            name = base + i;
            if (conSet.contains(name)) {
                name = null;
            }
            ++i;
        }
        return name;
    }

    private void setSelectedConstraint(int indexOfConstraint) {
        this._currentSelection = indexOfConstraint;
        this.lstConstraints.setSelectedIndex(this._currentSelection);
    }

    private void setSelectedConstraint(Constraint constraint) {
        this.lstConstraints.setSelectedValue(constraint, true);
        this._currentSelection = this.lstConstraints.getSelectedIndex();
    }

    protected void constraintChanged(Constraint con) {
        if (null == this._con) {
            this._con = con;
        }
    }

    protected void updateListUI() {
        this.lstConstraints.updateUI();
    }

    static {
        s_postfixes.put("PKConstraint", "_PK");
        s_postfixes.put("UniqueConstraint", "_UK");
        s_postfixes.put("FKConstraint", "_FK");
        s_postfixes.put("CheckConstraint", "_CHK");
    }

    private final class EventHandler
    implements ListSelectionListener,
    ActionListener,
    ListDataListener {
        private EventHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                BaseConstraintPanel.this._updateSelection();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int idx;
            BaseConstraintPanel.this._currentSelection = BaseConstraintPanel.this.lstConstraints.getSelectedIndex();
            Object src = e.getSource();
            if (src == BaseConstraintPanel.this.btnAdd) {
                try {
                    BaseConstraintPanel.this._commitDetail(true);
                    Constraint con = BaseConstraintPanel.this.createNewConstraint();
                    con.setEnabled(true);
                    con.setName(BaseConstraintPanel.findUniqueName(BaseConstraintPanel.this._relation, con, BaseConstraintPanel.this._getConstraintsFromList(), BaseConstraintPanel.this.getProvider()));
                    BaseConstraintPanel.this._relation.addConstraint(con);
                    BaseConstraintPanel.this._mdlCons.addElement(con);
                    int idx2 = BaseConstraintPanel.this._mdlCons.indexOf(con);
                    BaseConstraintPanel.this.setSelectedConstraint(idx2);
                }
                catch (TraversalException ex) {
                    BaseConstraintPanel.this._showConstraintError(ex);
                }
            } else if (src == BaseConstraintPanel.this.btnRemove && (idx = BaseConstraintPanel.this.lstConstraints.getSelectedIndex()) != -1) {
                BaseConstraintPanel.this._relation.removeConstraint(BaseConstraintPanel.this._con);
                BaseConstraintPanel.this._con = null;
                int newIdx = idx == BaseConstraintPanel.this._mdlCons.size() - 1 ? idx - 1 : idx + 1;
                BaseConstraintPanel.this.setSelectedConstraint(newIdx);
                BaseConstraintPanel.this._mdlCons.remove(idx);
                if (newIdx == -1) {
                    BaseConstraintPanel.this._updateDetailPanel();
                }
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }
}

