/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Context;
import oracle.ide.db.panels.sql.tester.TestSQLPanel;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.controls.DatabasePicker;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Database;

class TesterPanel
extends JPanel {
    private final DatabasePicker m_picker = DatabasePicker.createPicker();
    private final JTextArea m_txtSQL = new JTextArea();
    private final JSplitPane m_pane;
    private final JTabbedPane m_tabPane = new JTabbedPane();
    private final DBUIResourceHelper m_reshelp = new DBUIResourceHelper("TesterPanel");
    private final List<TesterComponent> m_queryComps = new ArrayList<TesterComponent>();
    private Database m_db;
    private String m_queryTxt;
    private boolean m_listen;

    public TesterPanel() {
        this.setLayout(new GridBagLayout());
        HelpUtils.setHelpID((JComponent)this, (String)"f1_odbsqltester_html");
        this.m_reshelp.setName(this.m_tabPane, "TesterTabPane");
        this.m_tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TesterPanel.this.panelChanged();
            }
        });
        this.addPanel(new TestSQLPanel(this.m_txtSQL));
        this.m_txtSQL.setFont(Font.decode("Monospaced"));
        this.m_pane = new JSplitPane(0, TesterPanel.newChildPanel(this.m_txtSQL, UIBundle.get("TESTSQL_SQL_LABEL"), "SQL", this.m_reshelp, this), this.m_tabPane);
        this.m_reshelp.setName(this.m_pane, "Split");
        this.m_pane.setResizeWeight(0.5);
        if (this.m_picker != null) {
            this.m_picker.setContext(Context.newIdeContext());
            Component picker = this.m_picker.getComponent();
            JLabel label = new JLabel();
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
            this.add((Component)label, gbc);
            this.m_reshelp.resLabel(label, picker, UIBundle.get("TESTSQL_CONN_LABEL"), "Picker");
            ++gbc.gridx;
            gbc.insets.right = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add(picker, gbc);
            this.m_picker.addListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TesterPanel.this.m_db = TesterPanel.this.m_picker.getDatabase();
                    TesterPanel.this.panelChanged();
                }
            });
        }
        this.add((Component)this.m_pane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    Component getDefaultFocusComponent() {
        return this.m_txtSQL;
    }

    void addPanel(TesterComponent component) {
        this.m_queryComps.add(component);
        this.m_tabPane.add(component.getName(), component.getComponent());
    }

    void testSQL(Database db, String text) {
        this.m_listen = true;
        this.m_queryTxt = text;
        if (db != null) {
            this.m_picker.setDatabase(db);
        }
        this.m_db = this.m_picker.getDatabase();
        if (this.m_tabPane.getSelectedIndex() != 0) {
            this.m_tabPane.setSelectedIndex(0);
        } else {
            this.panelChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void panelChanged() {
        if (this.m_listen) {
            int i = this.m_tabPane.getSelectedIndex();
            if (this.m_db == null) {
                this.enableTabs(false);
                if (i != 0) {
                    try {
                        this.m_listen = false;
                        this.m_tabPane.setSelectedIndex(0);
                    }
                    finally {
                        this.m_listen = true;
                    }
                }
            } else {
                this.enableTabs(true);
                this.m_queryComps.get(i).testSQL(this.m_db, this.m_queryTxt);
            }
        }
    }

    private void enableTabs(boolean boo) {
        for (int i = 1; i < this.m_tabPane.getTabCount(); ++i) {
            this.m_tabPane.setEnabledAt(i, boo);
        }
    }

    static JPanel newChildPanel(JTextArea txtArea, String labelTxt, String compName, DBUIResourceHelper reshelp, Component parent) {
        JLabel label = new JLabel();
        reshelp.resLabel(label, txtArea, labelTxt, compName);
        txtArea.setEditable(false);
        txtArea.setBackground(parent.getBackground());
        JScrollPane scroll = new JScrollPane(txtArea);
        reshelp.setName(scroll, compName + "Scroll");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.add((Component)label, "North");
        panel.add((Component)scroll, "Center");
        return panel;
    }
}

