/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ide.db.panels.sql.tester.TesterPanel;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.sql.InvalidSQLException;
import oracle.javatools.util.Holder;

class TestSQLPanel
extends JPanel
implements TesterComponent {
    private final JTextArea m_txtSQL;
    private final JTextArea m_txtMsg = new JTextArea();
    private final DBUIResourceHelper m_reshelp = new DBUIResourceHelper("TestSQLPanel");

    public TestSQLPanel(JTextArea sqlTxtArea) {
        this.m_txtSQL = sqlTxtArea;
        this.setLayout(new BorderLayout());
        this.add((Component)TesterPanel.newChildPanel(this.m_txtMsg, UIBundle.get("TESTSQL_MSG_LABEL"), "Result", this.m_reshelp, this), "Center");
        this.m_txtMsg.setLineWrap(true);
        this.m_txtMsg.setWrapStyleWord(true);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getName() {
        return UIBundle.get("TESTSQL_TEST");
    }

    @Override
    public void testSQL(final Database db, final String sqlQuery) {
        this.m_txtSQL.setText(null);
        if (db == null) {
            this.m_txtMsg.setText(UIBundle.get("TESTSQL_CHOOSE_DB"));
        } else {
            this.m_txtMsg.setText(UIBundle.get("TESTSQL_RUNNING"));
            final ProgressBar pbar = new ProgressBar((Component)this, this.getName(), null, true);
            pbar.setRunnable(new Runnable(){

                @Override
                public void run() {
                    TestSQLPanel.this.doTestSQL(db, sqlQuery);
                    pbar.setDoneStatus();
                }
            });
            pbar.start(null, null, 1500);
        }
    }

    private void doTestSQL(Database db, String sqlQuery) {
        final Holder queryTxt = new Holder((Object)sqlQuery);
        final Holder resultTxt = new Holder((Object)UIBundle.get("TESTSQL_SUCCESS"));
        final Holder offset = new Holder();
        try {
            db.testSQLStatement(sqlQuery);
        }
        catch (InvalidSQLException sqe) {
            resultTxt.set((Object)sqe.getMessage());
            queryTxt.set((Object)sqe.getSQLWithError());
            offset.set((Object)sqe.getOffset());
        }
        catch (DBException dbe) {
            resultTxt.set((Object)dbe.getMessage());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestSQLPanel.this.setText(TestSQLPanel.this.m_txtMsg, (String)resultTxt.get());
                String sql = (String)queryTxt.get();
                Integer i = (Integer)offset.get();
                TestSQLPanel.this.setText(TestSQLPanel.this.m_txtSQL, sql);
                if (i != null && sql != null) {
                    int end = TestSQLPanel.this.getWordEnd(sql, i);
                    if (end == i) {
                        int caret = sql.indexOf("^", (int)i);
                        if (caret >= 0) {
                            TestSQLPanel.this.m_txtSQL.setCaretPosition(caret);
                        }
                    } else {
                        TestSQLPanel.this.m_txtSQL.setCaretPosition(i);
                        TestSQLPanel.this.m_txtSQL.moveCaretPosition(end + 1);
                    }
                    TestSQLPanel.this.m_txtSQL.requestFocusInWindow();
                }
            }
        });
    }

    private int getWordEnd(String sql, int offset) {
        int retval = offset;
        for (int i = offset; i < sql.length(); ++i) {
            retval = i;
            if (Character.isWhitespace(sql.charAt(i + 1))) break;
        }
        return retval;
    }

    private void setText(JTextArea area, String txt) {
        area.setText(txt);
        area.setCaretPosition(0);
    }
}

