/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ide.db.panels.sql.ExpressionPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.ExpressionEditSupport;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.controls.completionfield.CompletionTextField;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.AliasInUseException;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.InvalidAliasException;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class SelectObjectsPanel
extends BaseSQLQueryBuilderPanel
implements ExpressionPanel.FragmentProvider,
DocumentListener,
ActionListener {
    public static final String FUNCTIONS_CAT = UIArb.getString(162);
    private boolean m_init;
    private SQLQueryBuilder m_builder;
    private JWrappedLabel m_desc = new JWrappedLabel(UIArb.getString(191));
    private ExpressionPanel m_expPanel;
    private JPanel m_editor;
    private CompletionTextField m_expression = new CompletionTextField();
    private ExpressionEditSupport m_editSupport = new ExpressionEditSupport((JTextComponent)this.m_expression);
    private JTextField m_alias = new JTextField();
    private JLabel m_expLabel = new JLabel();
    private JLabel m_aliasLabel = new JLabel();
    private JButton m_validate = new JButton();
    private boolean m_commitPending;
    private SelectObject m_current;
    private boolean m_new;

    public SelectObjectsPanel() {
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void layoutComponents() {
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.m_desc, "North");
        this.m_expPanel = new ExpressionPanel(this);
        this.add(this.m_expPanel, "Center");
    }

    @Override
    public void init(SQLQueryBuilder builder, DBObject defaultObject) {
        this.m_builder = builder;
        FunctionDefinition[] funcs = this.m_builder.getBuiltInFunctions();
        if (!this.m_init) {
            this.m_expPanel.setDBObjectProvider(this.m_pro);
            for (int i = 0; i < funcs.length; ++i) {
                this.m_expPanel.addFunction(funcs[i]);
            }
            this.m_init = true;
        }
        this.m_expPanel.clearTemplates();
        HashSet<Object> objs = new HashSet<Object>();
        FromObject[] froms = this.m_builder.listAllFromObjects();
        for (int i = 0; i < froms.length; ++i) {
            this.m_expPanel.addTemplate((SQLFragment)froms[i], true);
            objs.add(froms[i]);
        }
        objs.addAll(Arrays.asList(funcs));
        this.m_editSupport.setInsightMap(ExpressionEditSupport.createInsightMap(froms));
        this.m_editSupport.setInsightObjects(objs);
        SelectObject select = defaultObject instanceof SelectObject ? (SelectObject)defaultObject : null;
        this.m_expPanel.entered((SQLFragment[])this.m_builder.getSQLQuery().getSelectObjects(), (SQLFragment)select);
        this.checkWizardButtons();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.m_expPanel.exited();
        if (this.m_builder != null) {
            try {
                this.m_builder.syncViewColumns();
            }
            catch (AliasInUseException aiue) {
                throw new TraversalException(aiue.getMessage());
            }
        }
    }

    private SelectObject newSelectObject() {
        SelectObject result = new SelectObject();
        result.setID(TemporaryObjectID.createID((DBObject)result));
        return result;
    }

    private void updateCurrentFrag() throws SQLQueryException {
        String existingAlias = null;
        SQLFragment existingExp = null;
        if (this.m_current != null) {
            existingAlias = this.m_current.getAlias();
            existingExp = this.m_current.getExpression();
        }
        try {
            String expression = this.m_expression.getText().trim();
            String alias = this.m_alias.getText().trim();
            if (this.m_pro != null && ModelUtil.hasLength((String)alias) && !this.m_pro.isValidName("COLUMN", alias)) {
                throw new InvalidAliasException((AliasFragment)this.m_current, alias);
            }
            if (this.m_current != null) {
                SQLFragment exp = this.m_builder.parseSelectExpression(expression);
                if (this.m_new) {
                    this.m_current.setExpression(exp);
                    this.m_current.setAlias(alias);
                    this.m_builder.addSelectObject(this.m_current);
                    this.m_new = false;
                } else {
                    SelectObject newObj = (SelectObject)this.m_current.copyTo(null);
                    newObj.setExpression(exp);
                    newObj.setAlias(alias);
                    this.m_builder.replaceSelectObject(this.m_current, newObj);
                    if (this.m_sObj instanceof SQLQueryOwner) {
                        Relation rel = (Relation)this.m_sObj;
                        for (Column col : rel.getColumns()) {
                            ViewColumn vc;
                            if (!(col instanceof ViewColumn) || !(vc = (ViewColumn)col).getSelectObjectID().equals(this.m_current.getID())) continue;
                            vc.setName(this.m_pro.getInternalName(alias));
                        }
                    }
                }
                this.m_expPanel.repaint();
            }
        }
        catch (SQLQueryException sqe) {
            if (this.m_new) {
                this.m_current.setAlias(existingAlias);
                this.m_current.setExpression(existingExp);
            }
            throw sqe;
        }
    }

    private void enableComponents(boolean en) {
        this.m_aliasLabel.setEnabled(en);
        this.m_alias.setEnabled(en);
        this.m_expLabel.setEnabled(en);
        this.m_expression.setEnabled(en);
        this.m_validate.setEnabled(en);
        if (!en) {
            this.m_alias.setText(null);
            this.m_expression.setText(null);
            this.m_commitPending = false;
        }
    }

    private void checkWizardButtons() {
        SelectObject[] exps = this.m_builder.getSQLQuery().getSelectObjects();
        boolean en = exps != null && exps.length > 0;
        this.setCanFinish(en);
        this.enableButtons(en);
    }

    @Override
    public String getComponentNamePrefix() {
        return "SelectObjectsPanel";
    }

    @Override
    public JPanel getEditorUI() {
        if (this.m_editor == null) {
            this.m_editor = new JPanel();
            this.m_editor.setLayout(new GridBagLayout());
            this.m_editor.setName(this.getComponentNamePrefix());
            int y = 0;
            DBUIResourceHelper reshelp = new DBUIResourceHelper(this.getComponentNamePrefix());
            reshelp.resLabel(this.m_expLabel, (Component)this.m_expression, UIArb.getString(161), "Expression");
            this.m_editor.add((Component)this.m_expLabel, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
            ToolTipManager.sharedInstance().registerComponent((JComponent)this.m_expression);
            this.m_expression.getDocument().addDocumentListener(this);
            this.m_editor.add((Component)this.m_expression, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            reshelp.resLabel(this.m_aliasLabel, this.m_alias, UIArb.getString(160), "Alias");
            this.m_editor.add((Component)this.m_aliasLabel, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.m_alias.setColumns(30);
            this.m_alias.getDocument().addDocumentListener(this);
            this.m_editor.add((Component)this.m_alias, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_validate.addActionListener(this);
            reshelp.resButton(this.m_validate, UIArb.getString(166), "Validate");
            this.m_editor.add((Component)this.m_validate, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.m_editor.add((Component)Box.createVerticalBox(), new GridBagConstraints(1, y++, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.enableComponents(false);
        return this.m_editor;
    }

    @Override
    public String getEditorName() {
        return UIArb.getString(194);
    }

    @Override
    public String getListTitle() {
        return UIArb.getString(192);
    }

    @Override
    public String getTemplateTitle() {
        return UIArb.getString(165);
    }

    @Override
    public SQLFragment newFragment() {
        this.m_current = this.newSelectObject();
        this.edit((SQLFragment)this.m_current);
        this.m_commitPending = true;
        this.m_new = true;
        this.setCanFinish(true);
        this.enableButtons(true);
        return this.m_current;
    }

    @Override
    public boolean removeFragment(SQLFragment frag) {
        boolean retval = false;
        if (this.m_new) {
            this.m_new = false;
            retval = true;
        } else {
            SQLFragment[] deps = this.m_builder.getDependentObjects((SelectObject)frag);
            retval = deps != null && deps.length > 0 && !MessageDialog.confirm((Component)((Object)this), (Object)UIArb.getString(195), (String)UIArb.getString(196), null) ? false : this.m_builder.removeSelectObject((SelectObject)frag);
        }
        this.checkWizardButtons();
        return retval;
    }

    @Override
    public void moveFragment(SQLFragment frag, int newIndex) {
        this.m_builder.getSQLQuery().moveSelectObject((SelectObject)frag, newIndex);
    }

    @Override
    public void commit() throws TraversalException {
        if (this.m_commitPending) {
            SQLFragment exp = this.m_current == null ? null : this.m_current.getExpression();
            String existing = exp == null ? null : exp.getSQLText();
            String expression = this.m_expression.getText().trim();
            String existingAlias = this.m_current.getAlias();
            String alias = this.m_alias.getText().trim();
            if (this.m_pro != null && ModelUtil.hasLength((String)alias) && !this.m_pro.isValidName("COLUMN", alias)) {
                throw new TraversalException(DBArb.format((int)30, (Object)alias));
            }
            if (ModelUtil.areDifferent((Object)alias, (Object)existingAlias) || ModelUtil.areDifferent((Object)expression, (Object)existing)) {
                try {
                    this.updateCurrentFrag();
                }
                catch (SQLQueryException e) {
                    throw new TraversalException(e.getMessage());
                }
            }
            this.m_commitPending = false;
        }
    }

    @Override
    public void edit(SQLFragment frag) {
        this.m_editSupport.clearUndo();
        SelectObject selectObject = this.m_current = frag instanceof SelectObject ? (SelectObject)frag : null;
        if (this.m_current == null) {
            this.enableComponents(false);
        } else {
            this.enableComponents(true);
            this.m_alias.setText(this.m_current == null ? "" : this.m_current.getAlias());
            SQLFragment exp = this.m_current == null ? null : this.m_current.getExpression();
            this.m_expression.setText(exp == null ? "" : exp.getSQLText());
            this.m_expression.requestFocusInWindow();
            this.m_expression.selectAll();
            this.m_commitPending = false;
        }
    }

    @Override
    public void addToExpression(String text) {
        this.m_editSupport.addToExpressionField(text);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.updateCurrentFrag();
            String oldAlias = this.m_current == null ? null : this.m_current.getAlias();
            String newAlias = this.m_alias.getText().trim();
            if (this.m_pro != null && ModelUtil.hasLength((String)newAlias) && !this.m_pro.isValidName("COLUMN", newAlias)) {
                throw new InvalidAliasException((AliasFragment)this.m_current, newAlias);
            }
            if (oldAlias != null && ModelUtil.areDifferent((Object)oldAlias, (Object)newAlias)) {
                this.m_alias.setText(oldAlias);
            }
            DBObjectRenderer.setToolTipText((JComponent)this.m_expression, null);
        }
        catch (SQLQueryException sqe) {
            String message = sqe.getMessage();
            this.m_expPanel.showInvalidExpressionDialog(new TraversalException(message));
            DBObjectRenderer.setToolTipText((JComponent)this.m_expression, message);
        }
    }
}

