/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.Component;
import java.util.Comparator;
import oracle.ide.Ide;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.FromObjectsPanel;
import oracle.ide.db.panels.sql.GroupByPanel;
import oracle.ide.db.panels.sql.HavingPanel;
import oracle.ide.db.panels.sql.OrderByPanel;
import oracle.ide.db.panels.sql.QueryPanel;
import oracle.ide.db.panels.sql.QuickPickObjectsPanel;
import oracle.ide.db.panels.sql.SelectObjectsPanel;
import oracle.ide.db.panels.sql.WhereObjectPanel;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.Step;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.WhereObject;

public final class SQLQueryEditDialog
implements Comparator {
    public static final String HELP_PICKER = "f1_odbviobjpick_html";
    public static final String HELP_SELECT_INFO = "f1_odbviselect_html";
    public static final String HELP_FROM_INFO = "f1_odbvifrom_html";
    public static final String HELP_WHERE_INFO = "f1_odbviwhere_html";
    public static final String HELP_GROUPBY_INFO = "f1_odbvigroup_html";
    public static final String HELP_HAVING_INFO = "f1_odbvihaving_html";
    public static final String HELP_ORDERBY_INFO = "f1_odbviorderby_html";
    public static final String HELP_QUERY_INFO = "f1_odbvisql_html";
    @Deprecated
    public static final String HELP_JOIN_INFO = "f1_dbviewwizardfkjoins_html";
    private static final String[] QUERY_HELP_IDS = new String[]{"f1_odbviobjpick_html", "f1_odbvifrom_html", "f1_odbviselect_html", "f1_odbviwhere_html", "f1_odbvigroup_html", "f1_odbvihaving_html", "f1_odbviorderby_html", "f1_odbvisql_html"};
    private String[] m_helpIDs;
    private Navigable[] m_navs;
    private Step[] m_steps;
    private boolean m_materializedView = false;

    public SQLQueryEditDialog() {
        this(false);
    }

    public SQLQueryEditDialog(boolean materializedView) {
        this.m_materializedView = materializedView;
    }

    public SQLQueryEditDialog(String[] helpIDs) {
        this.m_helpIDs = helpIDs;
    }

    public Navigable[] getNavigables() {
        if (this.m_navs == null) {
            this.m_navs = new Navigable[]{new Navigable(UIArb.getString(200), QuickPickObjectsPanel.class), new Navigable(UIArb.getString(202), FromObjectsPanel.class), new Navigable(UIArb.getString(201), SelectObjectsPanel.class), new Navigable(UIArb.getString(204), WhereObjectPanel.class), new Navigable(UIArb.getString(205), GroupByPanel.class), new Navigable(UIArb.getString(206), HavingPanel.class), new Navigable(UIArb.getString(207), OrderByPanel.class), new Navigable(UIArb.getString(208), QueryPanel.class)};
            this.setHelpIDs(this.m_navs);
        }
        return this.m_navs;
    }

    private void setHelpIDs(Navigable[] navs) {
        for (int i = 0; i < navs.length; ++i) {
            navs[i].setHelpID(this.getHelpID(i));
        }
    }

    private String getHelpID(int i) {
        String h = null;
        if (this.m_helpIDs != null && this.m_helpIDs.length > i) {
            h = this.m_helpIDs[i];
        } else if (QUERY_HELP_IDS.length > i) {
            h = QUERY_HELP_IDS[i];
        }
        return h;
    }

    public Navigable getMasterNavigable() {
        Navigable master = new Navigable(UIArb.getString(277), QueryPanel.class);
        master.setHelpID(HELP_QUERY_INFO);
        master.setChildComparator((Comparator)this);
        Navigable[] n = this.getNavigables();
        int lastChildNavIndex = this.m_materializedView ? n.length - 2 : n.length - 1;
        for (int i = 0; i < lastChildNavIndex; ++i) {
            master.addChildNavigable(n[i]);
        }
        return master;
    }

    public Step[] getSteps() {
        if (this.m_steps == null) {
            int i = 0;
            this.m_steps = new Step[]{new Step(UIArb.getString(200), QuickPickObjectsPanel.class, this.getHelpID(i++)), new Step(UIArb.getString(202), FromObjectsPanel.class, this.getHelpID(i++)), new Step(UIArb.getString(201), SelectObjectsPanel.class, this.getHelpID(i++)), new Step(UIArb.getString(204), WhereObjectPanel.class, this.getHelpID(i++)), new Step(UIArb.getString(205), GroupByPanel.class, this.getHelpID(i++)), new Step(UIArb.getString(206), HavingPanel.class, this.getHelpID(i++)), new Step(UIArb.getString(207), OrderByPanel.class, this.getHelpID(i++)), new Step(UIArb.getString(208), QueryPanel.class, this.getHelpID(i++))};
        }
        return this.m_steps;
    }

    public String editQuery(String sqlText, DBObjectProvider provider, Schema defaultSchema) throws SQLQueryException {
        SQLQueryBuilder builder = null;
        AbstractSQLQuery query = null;
        try {
            builder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)provider, (Schema)defaultSchema);
            builder.buildQuery(sqlText);
            query = builder.getSQLQuery();
        }
        catch (SQLQueryException e) {
            if (e instanceof SQLParseException) {
                throw e;
            }
            query = new NonDeclarativeSQLQuery(sqlText);
        }
        query = this.editQuery(builder, (SQLQuery)query, null, provider, defaultSchema);
        return query == null ? null : query.toString();
    }

    public SQLQuery editQuery(SQLQuery query, DBObjectProvider provider, Schema defaultSchema) throws SQLQueryException {
        return this.editQuery(query, null, provider, defaultSchema);
    }

    public SQLQuery editQuery(SQLQuery query, SQLFragment defaultObject, DBObjectProvider provider, Schema defaultSchema) throws SQLQueryException {
        SQLQueryBuilder builder;
        block2: {
            builder = null;
            try {
                builder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)provider, (Schema)defaultSchema);
                builder.buildQuery(query);
            }
            catch (SQLQueryException e) {
                if (!(e instanceof SQLParseException)) break block2;
                throw e;
            }
        }
        query = this.editQuery(builder, query, defaultObject, provider, defaultSchema);
        return query;
    }

    private SQLQuery editQuery(SQLQueryBuilder builder, SQLQuery query, SQLFragment defaultObject, DBObjectProvider provider, Schema defaultSchema) {
        String[] startPage;
        Namespace namespace = new Namespace();
        namespace.put("DBObjectProvider", (Object)provider);
        namespace.put("Schema", (Object)defaultSchema);
        namespace.put("NewObject", (Object)query);
        MDDPanel panel = new MDDPanel(this.getNavigables());
        TDialogLauncher launcher = new TDialogLauncher((Component)Ide.getMainWindow(), UIArb.getString(275), (Traversable)panel, namespace);
        if (defaultObject != null && (startPage = SQLQueryEditDialog.getStartPage(defaultObject, false)) != null) {
            panel.setTree1SelectionPath(startPage);
        }
        launcher.initDialog().setName("SQLQueryEditDialog");
        if (launcher.showDialog()) {
            query = (SQLQuery)namespace.get("NewObject");
        }
        launcher.dispose();
        return query;
    }

    public int compare(Object o1, Object o2) {
        return 0;
    }

    public static final String[] getStartPage(SQLFragment child, boolean incMaster) {
        String page = null;
        if (child instanceof SelectObject) {
            page = UIArb.getString(201);
        } else if (child instanceof FromObject) {
            page = UIArb.getString(202);
        } else if (child instanceof WhereObject) {
            page = UIArb.getString(204);
        } else if (child instanceof GroupByObject) {
            page = UIArb.getString(205);
        } else if (child instanceof OrderByObject) {
            page = UIArb.getString(207);
        }
        if (page != null) {
            if (incMaster) {
                return new String[]{UIArb.getString(277), page};
            }
            return new String[]{page};
        }
        return null;
    }

    public static boolean isAvailable(DBObjectProvider pro) {
        if (pro instanceof Database) {
            return pro instanceof OracleDatabase;
        }
        return true;
    }
}

