/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.ide.db.controls.DBObjectSourcePicker;
import oracle.ide.db.panels.sql.BaseSQLQueryPickerPanel;
import oracle.ide.db.panels.sql.QueryTargetPicker;
import oracle.ide.db.panels.sql.QuickPickSourcePicker;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.AliasInUseException;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryOwner;

public class QuickPickObjectsPanel
extends BaseSQLQueryPickerPanel {
    public static final String SETTINGS_KEY_DB = "QuickPickObjectsPanel_DB";
    public static final String SETTINGS_KEY_OTHER = "QuickPickObjectsPanel";
    private QueryTargetPicker m_toPick = new QueryTargetPicker();
    private QuickPickSourcePicker m_fromPick;

    public QuickPickObjectsPanel() {
        this(true);
    }

    public QuickPickObjectsPanel(boolean canAlwaysNext) {
        super(canAlwaysNext);
        this.m_shuttle.setButtonsShown(13);
    }

    @Override
    protected ItemPicker getToPicker() {
        return this.m_toPick;
    }

    @Override
    protected DBObjectSourcePicker getFromPicker() {
        if (this.m_fromPick == null) {
            this.m_fromPick = new QuickPickSourcePicker(this.getProvider(), true, false);
            SchemaObject sObj = this.getSchemaObject();
            if (sObj instanceof SQLQueryOwner) {
                this.m_fromPick.setSQLQueryOwner((SQLQueryOwner)sObj);
            }
        }
        return this.m_fromPick;
    }

    @Override
    protected void clearToPicker() {
        this.m_toPick.clear();
    }

    @Override
    protected void initToPicker(SQLQueryBuilder builder, DBObjectProvider pro, Schema schema) {
        this.m_toPick.setQueryBuilder(builder);
        this.m_toPick.loadQuery();
    }

    @Override
    protected void commitToPicker(TraversableContext dataContext) throws TraversalException {
        SQLQueryBuilder builder = this.getBuilder();
        if (builder != null && this.m_toPick.hasChanged()) {
            builder.getSQLQuery().setSelectObjects(this.m_toPick.getSelectList());
            this.m_toPick.removeNewEmptyFroms();
            try {
                builder.syncViewColumns();
            }
            catch (AliasInUseException aiue) {
                throw new TraversalException(aiue.getMessage());
            }
        }
    }

    @Override
    protected String getSettingsKey() {
        return this.getProvider() instanceof Database ? SETTINGS_KEY_DB : SETTINGS_KEY_OTHER;
    }

    @Override
    protected String getPanelName() {
        return SETTINGS_KEY_OTHER;
    }
}

