/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.ReadOnlyScrollPane;
import oracle.ide.db.controls.SearchableTextArea;
import oracle.ide.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ide.db.panels.sql.tester.SQLQueryTester;
import oracle.ide.db.util.ExpressionEditSupport;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.DummyDBObjectProvider;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.sql.AliasInUseException;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.util.ModelUtil;

public class QueryPanel
extends BaseSQLQueryBuilderPanel
implements ActionListener,
DocumentListener {
    private JLabel m_queryLabel = new JLabel();
    private SearchableTextArea m_query = new SearchableTextArea();
    private boolean m_commitPending;
    private boolean m_invalidChangeCommitted;
    private JButton m_test = new JButton();
    private JButton m_liveTest = new JButton();
    private SQLQueryTester m_liveTester;
    private JButton m_revert = new JButton();
    private JLabel m_feedbackLabel = new JLabel();
    private ReadOnlyScrollPane m_feedback = new ReadOnlyScrollPane((Component)((Object)this));
    private String m_originalText;

    public QueryPanel() {
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean invalidWithoutBuilder() {
        return false;
    }

    @Override
    protected void layoutComponents() {
        new ExpressionEditSupport(this.m_query.getTextComponent());
        this.layoutPanel((JPanel)((Object)this));
    }

    private void layoutPanel(JPanel center) {
        DBUIResourceHelper reshelp = new DBUIResourceHelper("QueryPanel");
        center.setLayout(new GridBagLayout());
        reshelp.resLabel(this.m_queryLabel, this.m_query, UIArb.getString(264), "Query");
        GridBagConstraints gbc = new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0);
        center.add((Component)this.m_queryLabel, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ((JTextArea)this.m_query.getTextComponent()).setLineWrap(true);
        ((JTextArea)this.m_query.getTextComponent()).setWrapStyleWord(true);
        center.add((Component)this.m_query, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 3;
        reshelp.resLabel(this.m_feedbackLabel, this.m_feedback.getTextArea(), UIArb.getString(265), "Results");
        this.m_feedback.setBorder(null);
        this.m_feedback.setColumnHeaderView(this.m_feedbackLabel);
        center.add((Component)this.m_feedback, gbc);
        gbc.gridx = 2;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.anchor = 13;
        gbc.insets.left = 5;
        gbc.weightx = 0.0;
        reshelp.resButton(this.m_revert, UIArb.getString(266), "Revert");
        this.m_revert.addActionListener(this);
        center.add((Component)this.m_revert, gbc);
        ++gbc.gridy;
        reshelp.resButton(this.m_test, UIArb.getString(267), "Test");
        this.m_test.addActionListener(this);
        center.add((Component)this.m_test, gbc);
        ++gbc.gridy;
        reshelp.resButton(this.m_liveTest, UIArb.getString(268), "LiveTest");
        this.m_liveTest.addActionListener(this);
        center.add((Component)this.m_liveTest, gbc);
    }

    @Override
    protected void init(SQLQueryBuilder builder, DBObject defaultObject) {
        SQLQuery query = QueryPanel.findQuery(this.m_namespace);
        if (builder != null && !(query instanceof NonDeclarativeSQLQuery)) {
            this.enableButtons(true);
            query = builder.getSQLQuery();
        }
        if (query != null) {
            String sql = query.getSQLText();
            if (!this.m_invalidChangeCommitted) {
                this.m_originalText = sql == null ? "" : sql.trim();
                this.initQuery();
            }
        }
        this.m_liveTest.setVisible(!(this.m_namespace.get("DBObjectProvider") instanceof DummyDBObjectProvider));
    }

    @Override
    protected boolean isQueryPanel() {
        return true;
    }

    private void initQuery() {
        this.m_query.getTextComponent().getDocument().removeDocumentListener(this);
        if (ModelUtil.hasLength((String)this.m_originalText)) {
            this.m_query.getTextComponent().setText(this.m_originalText);
            this.m_commitPending = !ModelUtil.areDifferent((Object)this.m_originalText, (Object)"SELECT \n    \nFROM \n    ") ? this.m_invalidChangeCommitted : false;
        } else {
            this.m_query.getTextComponent().setText("SELECT \n    \nFROM \n    ");
        }
        this.m_query.getTextComponent().setCaretPosition(0);
        this.m_query.getTextComponent().getDocument().addDocumentListener(this);
        this.m_revert.setEnabled(false);
        this.m_feedback.setText(null, false);
        this.validate();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (this.m_commitPending) {
            String sql = this.m_query.getTextComponent().getText().trim();
            if (this.m_invalidChangeCommitted || !ModelUtil.hasLength((String)this.m_originalText) || ModelUtil.areDifferent((Object)sql, (Object)this.m_originalText)) {
                this.m_invalidChangeCommitted = false;
                this.testQuery(dataContext);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void testQuery(TraversableContext dataContext) throws TraversalException {
        block15: {
            schema = this.m_sObj == null || this.m_sObj.getSchema() == null ? this.m_defaultSchema : this.m_sObj.getSchema();
            builder = this.m_fac.createSQLQueryBuilder(this.m_pro, schema);
            if (dataContext != null) {
                dataContext.put(SQLQueryBuilder.class.getName(), (Object)builder);
            }
            obj = dataContext == null ? null : dataContext.get("NewObject");
            sql = this.m_query.getTextComponent().getText().trim();
            try {
                builder.buildQuery(sql, this.m_sObj instanceof SQLQueryOwner != false ? (SQLQueryOwner)this.m_sObj : null);
                query = builder.getSQLQuery();
                ob = query.getOrderByObjects();
                if (this.getObject() instanceof MaterializedView && ob != null && ob.length > 0) {
                    if (dataContext != null) {
                        builder.getSQLQuery().setOrderByObjects(null);
                    } else {
                        throw new SQLQueryException(UIArb.getString(272));
                    }
                }
                this.m_feedback.setText(UIArb.getString(269), true);
            }
            catch (SQLParseException spe) {
                this.m_invalidChangeCommitted = true;
                this.m_feedback.setText(spe.getMessage(), true);
                if (dataContext != null) {
                    throw new TraversalException(spe.getMessage());
                }
            }
            catch (SQLQueryClauseException sqe) {
                this.m_feedback.setText(sqe.getMessage(), true);
            }
            catch (SQLQueryException sqe) {
                message = new StringBuilder();
                message.append(UIArb.getString(270));
                message.append("\n\n").append(sqe.getMessage());
                this.m_feedback.setText(message.toString(), true);
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Error parsing sql query", e);
                if (dataContext == null) break block15;
                this.m_invalidChangeCommitted = true;
                throw new TraversalException(null);
            }
        }
        newQuery = builder.getSQLQuery();
        if (obj instanceof SQLQueryOwner) {
            ((SQLQueryOwner)obj).setSQLQuery((SQLQuery)newQuery);
            try {
                builder.syncViewColumns();
            }
            catch (AliasInUseException aiue) {
                if (newQuery instanceof NonDeclarativeSQLQuery && this.m_pro instanceof Database) ** GOTO lbl52
                throw new TraversalException(aiue.getMessage());
            }
        } else if (obj instanceof SQLQuery) {
            dataContext.put("NewObject", (Object)newQuery);
        }
lbl52:
        // 5 sources

        this.validate();
    }

    private void queryEdited() {
        this.m_commitPending = true;
        this.m_revert.setEnabled(true);
        this.m_query.getTextComponent().getDocument().removeDocumentListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_test) {
            try {
                this.testQuery(null);
            }
            catch (TraversalException traversalException) {}
        } else if (source == this.m_revert) {
            this.initQuery();
            this.m_query.requestFocusInWindow();
        } else if (source == this.m_liveTest) {
            if (this.m_liveTester == null) {
                this.m_liveTester = new SQLQueryTester(this.m_pro instanceof Database ? (Database)this.m_pro : null);
            }
            this.m_liveTester.showDialog(this.m_liveTest, this.m_query.getTextComponent().getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.queryEdited();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.queryEdited();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.queryEdited();
    }
}

