/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.sql.SQLException;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.panels.DDLPanel;
import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.editor.EditorUtil;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.plsql.PlSqlComparator;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;

public class PlSqlTabbedPanel
extends TabbedEditorPanel {
    public PlSqlTabbedPanel(Traversable top, Navigable[] navs) {
        super(top, navs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commitToProvider(TraversableContext tc) throws TraversalException {
        DBObjectProvider pro;
        PlSql orig;
        PlSqlComparator comp;
        Trigger orig2;
        SchemaObject obj = (SchemaObject)tc.find("NewObject");
        boolean create = tc.find("OriginalObject") == null;
        DDLGenerator gen = DDLPanel.getDDLGenerator(tc);
        String text = this.getBufferText(obj, gen);
        if (obj instanceof PlSql && GlobalSettings.getInstance().isNewPlSqlLowerCase()) {
            StringBuffer sb = new StringBuffer();
            PlSqlInterrogator pi = PlSqlInterrogator.findOrCreate((String)text);
            PlSqlToken tk = pi.getRoot().getFirstToken();
            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                tk = tk.getPrevToken();
            }
            tk = tk.getNextToken();
            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                if (tk.isCode() && !tk.getSource().startsWith("\"")) {
                    sb.append(tk.getSource().toLowerCase());
                } else {
                    sb.append(tk.getSource());
                }
                tk = tk.getNextToken();
            }
            text = sb.toString();
        }
        if (create && obj instanceof PlSql) {
            ((PlSql)obj).setSource(text);
        } else if (obj instanceof Trigger) {
            Trigger trig = (Trigger)obj;
            orig2 = (Trigger)tc.find("OriginalObject");
            trig.setSource(text);
            TemplateExpander.applySourceFromTemplate((PlSql)orig2, (PlSql)trig);
        }
        if (obj instanceof PlSql && tc.find("OriginalObject") != null && (comp = new PlSqlComparator(false, true)).compare((orig = (PlSql)tc.find("OriginalObject")).getSource(), ((PlSql)obj).getSource()) == 0) {
            ((PlSql)obj).setSource(orig.getSource());
        }
        if (!((pro = (DBObjectProvider)tc.find("DBObjectProvider")) instanceof Database)) {
            super.commitToProvider(tc);
            return;
        }
        if (!create) {
            orig2 = (SchemaObject)tc.find("OriginalObject");
            URL origUrl = this.getNodeURL((SchemaObject)orig2, pro);
            Node origNode = null;
            try {
                origNode = NodeFactory.findOrCreate((URL)origUrl);
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
            if (origNode.isDirty()) {
                throw new TraversalException(UIArb.getString(436));
            }
        }
        if (TemplateExpander.isPendingObject((DBObject)obj)) {
            TemplateExpander.applySourceFromTemplate((PlSql)((PlSql)obj));
            text = ((PlSql)obj).getSource();
            PlSqlToken firstTk = PlSqlTokenizer.tokenize((String)text, (String[])new String[0]);
            if (!firstTk.isCode()) {
                firstTk = firstTk.getNextCodeToken();
            }
            if (firstTk != null && firstTk.isCode() && !firstTk.matches("CREATE")) {
                text = "CREATE OR REPLACE\n" + text;
            }
        } else if (obj instanceof PlSql) {
            this.ensureNameIsInSource((PlSql)obj, pro);
            text = ((PlSql)obj).getSource();
        }
        final Schema schema = obj.getSchema();
        final String name = obj.getName();
        final String dbType = obj.getType();
        URL url = this.getNodeURL(obj, pro);
        Node node = null;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
        if (node instanceof DBObjectNode) {
            ((DBObjectNode)node).init((DBObject)obj, pro);
        }
        if (node instanceof TextNode) {
            final TextNode cbn = (TextNode)node;
            cbn.addNodeListener(new NodeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void nodeSaved(NodeEvent e) {
                    try {
                        SchemaObject obj = pro.getObject(dbType, schema, name);
                        if (obj != null && pro instanceof AbstractDatabase) {
                            ((AbstractDatabase)pro).fireObjectsAdded(schema, new SchemaObject[]{obj});
                        }
                    }
                    catch (DBException ex) {
                        String title = UIArb.getString(425);
                        Throwable cause = ex.getCause();
                        if (cause instanceof SQLException) {
                            SQLErrorDialog.showErrorDialog((Component)((Object)PlSqlTabbedPanel.this), title, (SQLException)cause);
                        } else {
                            DBExceptionDialog.showErrorDialog((Component)((Object)PlSqlTabbedPanel.this), title, ex);
                        }
                    }
                    finally {
                        cbn.removeNodeListener((NodeListener)this);
                    }
                }

                public void nodeClosed(NodeEvent e) {
                    cbn.removeNodeListener((NodeListener)this);
                }
            });
            TextBuffer buf = null;
            try {
                buf = cbn.acquireTextBuffer();
                buf.beginEdit();
                buf.removeToEnd(0);
                if (text != null) {
                    buf.append(text.toCharArray());
                }
            }
            finally {
                if (buf != null) {
                    buf.endEdit();
                    cbn.releaseTextBuffer();
                }
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorUtil.openDefaultEditorInFrame((Node)cbn);
                }
            });
        }
    }

    protected String getBufferText(SchemaObject obj, DDLGenerator gen) {
        boolean disableTrigger = false;
        if (obj instanceof Trigger && !((Trigger)obj).isEnabled()) {
            disableTrigger = true;
            ((Trigger)obj).setEnabled(true);
        }
        DDLOptions options = new DDLOptions(true, false);
        String source = gen.getCreateDDL(options, new DBObject[]{obj}).toString(false);
        if (obj instanceof Trigger && disableTrigger) {
            ((Trigger)obj).setEnabled(false);
        }
        return source;
    }

    protected URL getNodeURL(SchemaObject obj, DBObjectProvider pro) {
        String subtype = obj instanceof SpecPlSql ? "Spec" : null;
        URL url = DBURLFactory.getURL(pro, obj, subtype);
        return url;
    }
}

