/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.PlSqlParametersVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.util.ModelUtil;

public class ParamsModel
extends AbstractTableModel {
    static final int NAME_POS = 0;
    static final int TYPE_POS = 1;
    static final int MODE_POS = 2;
    static final int DEFAULT_POS = 3;
    private List<PlSqlParameter> _params = new ArrayList<PlSqlParameter>();
    private DBObjectProvider _prov;
    private boolean _isFunction;
    private Schema _defSchema;

    private String getUniqueParamName() {
        int i;
        String base = "PARAM";
        HashSet<String> names = new HashSet<String>();
        names.add(base);
        int n = i = this._isFunction ? 1 : 0;
        while (i < this._params.size()) {
            names.add(this._params.get(i).getName());
            ++i;
        }
        return DBUtil.getUniqueName(names, (String)base, (boolean)true);
    }

    public void addParameter() {
        this.addParameter(this._params.size() - 1);
    }

    public void addParameter(int idx) {
        PlSqlParameter param = new PlSqlParameter(this.getUniqueParamName(), this._prov.getOrCreateDataType("VARCHAR2"));
        param.setMode(PlSqlParameter.Mode.IN);
        this._params.add(++idx, param);
        this.fireTableRowsInserted(idx, idx);
    }

    public boolean canRemoveRow(int rowIndex) {
        int firstRow = this._isFunction ? 1 : 0;
        return rowIndex >= firstRow && rowIndex < this._params.size();
    }

    public void removeParameter(int idx) {
        this._params.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
    }

    public boolean canMoveRowUp(int rowIndex) {
        int firstRow = this._isFunction ? 1 : 0;
        return rowIndex > firstRow && rowIndex < this._params.size();
    }

    public void moveUp(int idx) {
        if (this.canMoveRowUp(idx)) {
            PlSqlParameter param = this._params.remove(idx);
            this._params.add(idx - 1, param);
            this.fireTableRowsUpdated(idx - 1, idx);
        }
    }

    public boolean canMoveRowDown(int rowIndex) {
        int firstRow = this._isFunction ? 1 : 0;
        return rowIndex >= firstRow && rowIndex < this._params.size() - 1;
    }

    public void moveDown(int idx) {
        if (this.canMoveRowDown(idx)) {
            PlSqlParameter param = this._params.remove(idx);
            this._params.add(idx + 1, param);
            this.fireTableRowsUpdated(idx, idx + 1);
        }
    }

    public void init(DBObjectProvider prov, DeclarativePlSql plsql, boolean isFunction) {
        this.init(prov, plsql, isFunction, null);
    }

    public void init(DBObjectProvider prov, DeclarativePlSql plsql, boolean isFunction, Schema defSchema) {
        PlSqlParameter[] params;
        this._prov = prov;
        this._isFunction = isFunction;
        this._params.clear();
        this._defSchema = defSchema;
        if (isFunction) {
            DBObjectID retTypeID = plsql.getReturnTypeID();
            PlSqlParameter ret = new PlSqlParameter("<Return>");
            if (retTypeID == null) {
                DataType retType = this._prov.getOrCreateDataType("VARCHAR2");
                retTypeID = retType.getID();
            }
            ret.setDataTypeID(retTypeID);
            this._params.add(ret);
        }
        if ((params = plsql.getParameters()) != null) {
            for (PlSqlParameter param : params) {
                this._params.add(param);
            }
        }
    }

    public void commit(DeclarativePlSql plsql, PlSqlParametersVerifier verifier) throws TraversalException {
        int i;
        int offset = this._isFunction ? 1 : 0;
        DBObjectID retTypeID = null;
        PlSqlParameter[] params = new PlSqlParameter[this._params.size() - offset];
        for (i = 0; i < params.length; ++i) {
            params[i] = this._params.get(i + offset);
        }
        plsql.setParameters(params);
        if (this._isFunction) {
            if (this._params.size() > 0) {
                PlSqlParameter param = this._params.get(0);
                retTypeID = param.getDataTypeID();
            }
            if (retTypeID == null) {
                throw new TraversalException(UIArb.getString(429));
            }
            plsql.setReturnTypeID(retTypeID);
        }
        for (i = 0; i < params.length; ++i) {
            verifier.verifyParameter(params[i]);
        }
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this._params.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String value = null;
        PlSqlParameter param = this._params.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                value = this._prov.getExternalName(param.getName());
                break;
            }
            case 1: {
                String typeName = DataTypeHelper.getTypeStringFromID((DBObjectID)param.getDataTypeID(), (Schema)this._defSchema);
                value = typeName != null ? typeName : "";
                break;
            }
            case 2: {
                PlSqlParameter.Mode mode = param.getMode();
                value = mode != null ? mode : "";
                break;
            }
            case 3: {
                value = param.getDefaultValue();
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(columnIndex);
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        PlSqlParameter param = this._params.get(rowIndex);
        String val = null;
        if (aValue instanceof String) {
            val = (String)aValue;
            if (!ModelUtil.hasLength((String)(val = val.trim()))) {
                val = null;
            }
        }
        switch (columnIndex) {
            case 0: {
                param.setName(this._prov.getInternalName(val));
                break;
            }
            case 1: {
                DBObjectID typeID = DataTypeHelper.findOrCreateIDForTypeString((DBObjectProvider)this._prov, (Schema)this._defSchema, (String)val);
                param.setDataTypeID(typeID);
                break;
            }
            case 2: {
                param.setMode(aValue instanceof PlSqlParameter.Mode ? (PlSqlParameter.Mode)aValue : null);
                break;
            }
            case 3: {
                param.setDefaultValue(val);
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(columnIndex);
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !this._isFunction || rowIndex > 0 || columnIndex == 1;
    }
}

