/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.datatypes.ComplexType;

public abstract class NewPlsqlPanel
extends NameAndSchemaEditor<PlSql> {
    private JLabel m_lblType = new JLabel();
    private JComboBox m_cmbType = new JComboBox();
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("NewPlsqlPanel");

    public NewPlsqlPanel() {
        this.m_resHelper.resLabel(this.m_lblType, this.m_cmbType, this.getTypeLabel(), "m_cmbType");
        this.add(this.m_lblType, new GridBagConstraints(0, 30, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_cmbType, new GridBagConstraints(1, 30, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public abstract String getTypeLabel();

    public abstract List getTypeList(PlSql var1);

    public abstract PlSqlComboItem getDefaultComboItem();

    protected abstract void performProcess(PlSql var1, DBObjectProvider var2) throws TraversalException;

    protected final PlSqlComboItem getSelectedType() {
        return (PlSqlComboItem)this.m_cmbType.getSelectedItem();
    }

    @Override
    protected void initialisePanel() {
        DBObjectProvider pro = this.getProvider();
        PlSql obj = (PlSql)this.getDBObject();
        PlSql origObj = (PlSql)this.getOriginalObject();
        List typeList = this.getTypeList(obj);
        if (typeList != null && typeList.size() > 0) {
            this.m_cmbType.setModel(new DefaultListComboBoxModel(typeList));
            if (typeList.size() < 2) {
                this.m_lblType.setVisible(false);
                this.m_cmbType.setVisible(false);
            }
        }
        if (origObj != null || TemplateExpander.isPendingObject((DBObject)obj)) {
            ComboBoxModel model = this.m_cmbType.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!((PlSqlComboItem)model.getElementAt(i)).getCollectionType().equals(((ComplexType)obj).getCollectionType())) continue;
                this.m_cmbType.setSelectedIndex(i);
                this.m_cmbType.setEnabled(false);
                break;
            }
        } else {
            PlSqlComboItem def = this.getDefaultComboItem();
            if (def != null) {
                this.m_cmbType.setSelectedItem(def);
            }
        }
        super.initialisePanel();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        this.performProcess((PlSql)this.getDBObject(), this.getProvider());
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.m_cmbType) {
            if (this.m_listening) {
                try {
                    this.performProcess((PlSql)this.getDBObject(), this.getProvider());
                }
                catch (TraversalException traversalException) {}
            }
        } else {
            super.actionPerformed(ev);
        }
    }

    protected final class PlSqlComboItem {
        private int m_display;
        private int m_plsql;
        private int m_extraPlsql;
        private String m_type;
        private String m_collType;

        public PlSqlComboItem(String type, int display, int plsql) {
            this(type, display, plsql, -1, "");
        }

        public PlSqlComboItem(String type, int display, int plsql, String collType) {
            this(type, display, plsql, -1, collType);
        }

        public PlSqlComboItem(String type, int display, int plsql, int extraPlsql) {
            this(type, display, plsql, extraPlsql, "");
        }

        public PlSqlComboItem(String type, int display, int plsql, int extraPlsql, String collType) {
            this.m_type = type;
            this.m_display = display;
            this.m_plsql = plsql;
            this.m_extraPlsql = extraPlsql;
            this.m_collType = collType;
        }

        public String getType() {
            return this.m_type;
        }

        public int getDisplayString() {
            return this.m_display;
        }

        public int getPlsql() {
            return this.m_plsql;
        }

        public int getExtraPlsql() {
            return this.m_extraPlsql;
        }

        public boolean isCollectionType() {
            return !this.m_collType.equals("");
        }

        public String getCollectionType() {
            return this.m_collType;
        }

        public String toString() {
            return UIArb.getString(this.getDisplayString());
        }
    }
}

