/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.controls.SchemaObjectComboBox;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;

public class TemplateObjectsPanel
extends DefaultTraversablePanel
implements ListSelectionListener,
ActionListener,
ListCellRenderer,
DBObjectChooser.ChangeListener {
    public static final String TEMPLATE_SCHEMA = UIArb.getString(993);
    private JLabel m_tempateSchemaLabel = new JLabel();
    private DBObjectChooser m_templateSchema = new DBObjectChooser("SCHEMA");
    private DefaultListModel m_typeModel = new DefaultListModel();
    private JScrollPane m_scrTypes = new JScrollPane();
    private JList m_typeList = new JList(this.m_typeModel);
    private JLabel m_typeLabel = new JLabel();
    private JComboBox m_typeCombo = new JComboBox();
    private JLabel m_schemaLabel = new JLabel();
    private DBObjectChooser m_templateSchemas = new DBObjectChooser("SCHEMA");
    private JLabel m_templateLabel = new JLabel();
    private SchemaObjectComboBox m_templateObjects = new SchemaObjectComboBox();
    private JButton m_newButt = new JButton(OracleIcons.getIcon((String)"add.png"));
    private JButton m_editButt = new JButton(OracleIcons.getIcon((String)"edit.png"));
    private JCheckBox m_makeDefault = new JCheckBox();
    private HashMap<String, DBObject> m_defaultTemplates = new HashMap();
    private DBObjectProvider m_pro;
    private int m_lastTypeIndex = -1;
    private boolean m_pickOneMode = false;
    private boolean m_initialised = false;
    private DefaultListCellRenderer m_delegateLCR = new DefaultListCellRenderer();
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("TemplateObjectsPanel");
    private TemplateSchemaChangeListener m_tempSchemaList = new TemplateSchemaChangeListener();

    public TemplateObjectsPanel(boolean pickOneMode) {
        this.m_pickOneMode = pickOneMode;
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_typeList.getSelectionModel().addListSelectionListener(this);
        this.m_typeList.setCellRenderer(this);
        this.m_typeCombo.setRenderer(this);
        this.m_templateSchemas.addChangeListener(this);
        this.m_templateSchema.addChangeListener(this.m_tempSchemaList);
        this.m_templateObjects.addActionListener(this);
        this.m_makeDefault.addActionListener(this);
        this.m_typeCombo.addActionListener(this);
        this.m_newButt.addActionListener(this);
        this.m_editButt.addActionListener(this);
        this.m_resHelper.resLabel(this.m_tempateSchemaLabel, this.m_templateSchema, UIArb.getString(984), "m_templateSchema");
        this.m_resHelper.resLabel(this.m_typeLabel, this.m_typeCombo, UIArb.getString(418), "m_typeCombo");
        this.m_resHelper.resLabel(this.m_schemaLabel, this.m_templateSchemas, UIArb.getString(108), "m_templateSchemas");
        this.m_resHelper.resLabel(this.m_templateLabel, this.m_templateObjects, UIArb.getString(109), "m_templateObjects");
        this.m_resHelper.resButton(this.m_makeDefault, UIArb.getString(981), "m_makeDefault");
        this.m_scrTypes.setVerticalScrollBarPolicy(20);
        this.m_typeList.setSelectionMode(0);
        this.m_scrTypes.getViewport().add((Component)this.m_typeList, null);
        if (this.m_pickOneMode) {
            this.add(this.m_typeLabel, this.gbc(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0)));
            this.add(this.m_typeCombo, this.gbc(3, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0)));
        } else {
            JPanel p1 = new JPanel();
            p1.setLayout(new GridBagLayout());
            p1.add((Component)this.m_tempateSchemaLabel, this.gbc(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0)));
            p1.add((Component)this.m_templateSchema, this.gbc(2, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 0, 0)));
            this.add(p1, this.gbc(1, 1, 3, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 10, 0)));
            this.add(this.m_scrTypes, this.gbc(1, 2, 1, 4, 0.0, 1.0, 18, 3, new Insets(10, 0, 0, 10)));
        }
        int y = 2;
        this.add(this.m_schemaLabel, this.gbc(2, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0)));
        this.add(this.m_templateSchemas, this.gbc(3, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0)));
        this.add(this.m_templateLabel, this.gbc(2, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0)));
        this.add(this.m_templateObjects, this.gbc(3, y, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0)));
        JPanel buttPnl = new JPanel(new GridBagLayout());
        if (!this.m_pickOneMode) {
            this.addButton(buttPnl, this.m_newButt, this.gbc(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5)), UIArb.getString(991), UIArb.getString(989), "m_newButt");
        }
        this.addButton(buttPnl, this.m_editButt, this.gbc(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0)), UIArb.getString(992), UIArb.getString(990), "m_editButt");
        this.add(buttPnl, this.gbc(4, y, 1, 1, 0.0, 0.0, 12, 0, new Insets(10, 5, 0, 0)));
        if (this.m_pickOneMode) {
            this.add(this.m_makeDefault, this.gbc(3, ++y, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0)));
        }
        this.add(Box.createVerticalGlue(), this.gbc(2, ++y, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0)));
    }

    public void init(DBObjectProvider pro, HashMap<String, DBObject> map) {
        if (!this.m_initialised) {
            this.m_pro = pro;
            this.m_defaultTemplates = map;
            if (!this.m_pickOneMode || pro instanceof Database) {
                this.m_makeDefault.setVisible(false);
            }
            if (!this.m_pickOneMode && !(pro instanceof Database)) {
                Schema templateSchema = (Schema)this.m_defaultTemplates.get("SCHEMA");
                if (templateSchema == null || templateSchema.getID() == null) {
                    String templateSchemaName = TEMPLATE_SCHEMA;
                    try {
                        templateSchema = this.m_pro.getSchema(templateSchemaName);
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                }
                this.m_templateSchema.setProvider(this.m_pro);
                if (templateSchema != null && templateSchema.getID() != null) {
                    this.m_templateSchema.setDBObject((DBObject)templateSchema);
                }
                this.m_templateSchema.setEditable(true);
            }
            Object[] types = new String[map.size()];
            int i = 0;
            for (String type : map.keySet()) {
                types[i++] = type;
            }
            Arrays.sort(types);
            this.m_typeCombo.removeActionListener(this);
            for (Object type : types) {
                if ("SCHEMA".equals(type) || "TABLESPACE".equals(type)) continue;
                this.m_typeModel.addElement(type);
                this.m_typeCombo.addItem(type);
            }
            this.m_typeCombo.addActionListener(this);
            this.m_typeList.setSelectedIndex(0);
            this.m_lastTypeIndex = 0;
            this.typeChange();
            if (this.m_pickOneMode) {
                this.m_typeCombo.setSelectedItem("TABLE");
            }
            this.m_initialised = true;
        }
    }

    public HashMap<String, DBObject> commit() {
        if (this.m_lastTypeIndex != -1) {
            String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
            this.m_defaultTemplates.put(type, (DBObject)this.m_templateObjects.getSchemaObject());
        }
        String templateSchemaName = this.m_templateSchema.getDBObject() == null ? null : this.m_templateSchema.getDBObject().getName();
        Schema templateSchema = null;
        try {
            if (templateSchemaName != null && templateSchemaName.length() > 0 && (templateSchema = this.m_pro.getSchema(templateSchemaName = this.m_pro.getInternalName(templateSchemaName))) == null) {
                templateSchema = new Schema(templateSchemaName);
                this.m_pro.createSchema(templateSchema, false);
            }
        }
        catch (DBException e) {
            // empty catch block
        }
        this.m_defaultTemplates.put("SCHEMA", (DBObject)templateSchema);
        if (this.m_pickOneMode) {
            SchemaObject so = this.m_templateObjects.getSchemaObject();
            String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
            if (!(this.m_pro instanceof Database) && this.m_makeDefault.isSelected()) {
                this.m_pro.setDefaultTemplateForType(type, (DBObject)so);
            }
            if (so == null) {
                so = (SchemaObject)Metadata.getInstance().newInstance(type);
            }
            this.m_defaultTemplates.clear();
            this.m_defaultTemplates.put(type, (DBObject)so);
        }
        return this.m_defaultTemplates;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.m_lastTypeIndex != -1 && (!this.m_pickOneMode || this.m_makeDefault.isSelected())) {
            String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
            this.m_defaultTemplates.put(type, (DBObject)this.m_templateObjects.getSchemaObject());
        }
        this.m_lastTypeIndex = ((ListSelectionModel)e.getSource()).getMinSelectionIndex();
        this.typeChange();
    }

    private void typeChange() {
        String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
        SchemaObject template = (SchemaObject)this.m_defaultTemplates.get(type);
        Schema schema = null;
        if (template != null) {
            schema = template.getSchema();
        }
        if ((schema = (Schema)this.m_templateSchema.getOrCreateDBObject()) == null) {
            try {
                schema = this.m_pro.getDefaultSchema();
            }
            catch (DBException dbe) {
                DBLog.getLogger((Object)this).warning("Couldn't get default schema: " + dbe.getMessage());
            }
        }
        this.m_templateSchemas.setProvider(this.m_pro);
        this.m_templateSchemas.setDBObject((DBObject)schema);
        this.m_templateObjects.init(this.m_pro, schema, true, type);
        int numberOfObjects = this.m_templateObjects.getModel().getSize();
        this.m_templateObjects.setSchemaObject(template);
        this.m_templateSchemas.setEnabled(true);
        this.m_templateObjects.setEnabled(numberOfObjects > 1);
        String checkBoxLabel = UIArb.format(981, DBTypeDisplayRegistry.getDisplayName(type));
        this.m_resHelper.resButton(this.m_makeDefault, checkBoxLabel, "m_makeDefault");
        this.setCheckBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        SchemaObject selectedObject;
        DBEditorFactory fac;
        this.setListeners(false);
        if (e.getSource() == this.m_makeDefault) {
            String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
            if (this.m_makeDefault.isSelected()) {
                this.m_defaultTemplates.put(type, (DBObject)this.m_templateObjects.getSchemaObject());
            } else {
                this.m_defaultTemplates.put(type, null);
            }
        } else if (e.getSource() == this.m_typeCombo) {
            this.m_typeList.setSelectedIndex(this.m_typeCombo.getSelectedIndex());
            this.m_lastTypeIndex = this.m_typeCombo.getSelectedIndex();
            this.typeChange();
        } else if (e.getSource() == this.m_newButt) {
            SQLQueryBuilder builder;
            Object fac2;
            String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
            SchemaObject templateTemplate = (SchemaObject)Metadata.getInstance().newInstance(type);
            if (templateTemplate instanceof SQLQueryOwner && (fac2 = this.m_pro.getDescriptor().getSQLQueryBuilderFactory()) != null && (builder = fac2.createSQLQueryBuilder(this.m_pro)) != null) {
                try {
                    SQLQueryOwner sqo = (SQLQueryOwner)templateTemplate;
                    builder.buildQuery("SELECT * FROM DUAL");
                    sqo.setSQLQuery((SQLQuery)builder.getSQLQuery());
                }
                catch (SQLQueryException sqe) {
                    // empty catch block
                }
            }
            fac2 = DBEditorFactoryRegistry.getCreateFactory(this.m_pro, type);
            SchemaObject template = null;
            PanelLibrary.setBaseNamePrefix("TEMPLATE_");
            try {
                template = fac2.createDBObject((Schema)this.m_templateSchema.getOrCreateDBObject(), this.m_pro, templateTemplate, true);
            }
            finally {
                PanelLibrary.setBaseNamePrefix(null);
            }
            if (template != null) {
                this.m_defaultTemplates.put(type, (DBObject)template);
                this.typeChange();
            }
        } else if (e.getSource() == this.m_editButt && (fac = DBEditorFactoryRegistry.getEditFactory(selectedObject = this.m_templateObjects.getSchemaObject(), this.m_pro)).editDBObject(selectedObject, this.m_pro)) {
            this.typeChange();
        }
        this.setCheckBox();
        this.setListeners(true);
    }

    private void setListeners(boolean on) {
        if (on) {
            this.m_templateSchemas.addChangeListener(this);
            this.m_templateSchema.addChangeListener(this.m_tempSchemaList);
            this.m_templateObjects.addActionListener(this);
            this.m_makeDefault.addActionListener(this);
            this.m_typeCombo.addActionListener(this);
        } else {
            this.m_templateSchemas.removeChangeListener(this);
            this.m_templateSchema.removeChangeListener(this.m_tempSchemaList);
            this.m_templateObjects.removeActionListener(this);
            this.m_makeDefault.removeActionListener(this);
            this.m_typeCombo.removeActionListener(this);
        }
    }

    private void setCheckBox() {
        if (this.m_lastTypeIndex >= 0 && this.m_lastTypeIndex < this.m_typeModel.getSize()) {
            String objectSchemaName;
            String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
            SchemaObject template = (SchemaObject)this.m_defaultTemplates.get(type);
            SchemaObject selectedObject = this.m_templateObjects.getSchemaObject();
            String templateName = template == null ? null : template.getName();
            String objectName = selectedObject == null ? null : selectedObject.getName();
            String templateSchemaName = template == null ? null : template.getSchema().getName();
            String string = objectSchemaName = selectedObject == null ? null : selectedObject.getSchema().getName();
            if (templateName == objectName && templateSchemaName == objectSchemaName) {
                this.m_makeDefault.setSelected(true);
                this.m_makeDefault.setEnabled(template != null);
            } else if (this.m_templateObjects.getModel().getSize() <= 1) {
                this.m_makeDefault.setSelected(false);
                this.m_makeDefault.setEnabled(false);
            } else {
                this.m_makeDefault.setSelected(false);
                this.m_makeDefault.setEnabled(true);
            }
            this.m_editButt.setEnabled(selectedObject != null);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String type = (String)value;
        type = this.m_pickOneMode ? DBTypeDisplayRegistry.getSingularDisplayName(type) : DBTypeDisplayRegistry.getDisplayName(type);
        JLabel label = (JLabel)this.m_delegateLCR.getListCellRendererComponent((JList<?>)list, type, index, isSelected, cellHasFocus);
        label.setIcon(DBTypeDisplayRegistry.getNodeIcon((String)value));
        return label;
    }

    private void addButton(JPanel panel, JButton button, GridBagConstraints gbc, String tooltip, String mnemonicText, String name) {
        this.m_resHelper.setName(button, name);
        button.setToolTipText(tooltip);
        if (ModelUtil.hasLength((String)mnemonicText)) {
            button.setMnemonic(StringUtils.getMnemonicKeyCode((String)mnemonicText));
        }
        IconicButtonUI.install((AbstractButton)button);
        panel.add((Component)button, gbc);
    }

    public final void setComponentsEnabledStatus(boolean status) {
        this.m_tempateSchemaLabel.setEnabled(status);
        this.m_templateSchema.setEnabled(status);
        this.m_scrTypes.setEnabled(status);
        this.m_typeList.setEnabled(status);
        this.m_typeLabel.setEnabled(status);
        this.m_typeCombo.setEnabled(status);
        this.m_schemaLabel.setEnabled(status);
        this.m_templateSchemas.setEnabled(status);
        this.m_templateLabel.setEnabled(status);
        this.m_templateObjects.setEnabled(status);
        this.m_newButt.setEnabled(status);
        this.m_editButt.setEnabled(status);
        this.m_makeDefault.setEnabled(status);
    }

    @Override
    public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
        this.setListeners(false);
        if (this.m_lastTypeIndex != -1) {
            Schema schema = null;
            schema = (Schema)this.m_templateSchemas.getDBObject();
            String type = (String)this.m_typeModel.get(this.m_lastTypeIndex);
            this.m_templateObjects.init(this.m_pro, schema, true, type);
            SchemaObject template = (SchemaObject)this.m_defaultTemplates.get(type);
            if (template != null && template.getSchema().equals((Object)schema)) {
                this.m_templateObjects.setSchemaObject(template);
            } else {
                this.m_templateObjects.setSelectedIndex(0);
            }
            if (this.m_templateObjects.getModel().getSize() == 1) {
                this.m_templateObjects.setEnabled(false);
            } else {
                this.m_templateObjects.setEnabled(true);
            }
        }
        this.setCheckBox();
        this.setListeners(true);
    }

    class TemplateSchemaChangeListener
    implements DBObjectChooser.ChangeListener {
        TemplateSchemaChangeListener() {
        }

        @Override
        public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
            TemplateObjectsPanel.this.setListeners(false);
            if (TemplateObjectsPanel.this.m_lastTypeIndex != -1) {
                TemplateObjectsPanel.this.typeChange();
            }
            TemplateObjectsPanel.this.setCheckBox();
            TemplateObjectsPanel.this.setListeners(true);
        }
    }
}

