/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.controls.NameAndSchemaAdvancedEditor;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.db.panels.DBTraversablePanel;
import oracle.ide.db.panels.MDDEditorPanel;
import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;

public abstract class PanelLibrary {
    public static final String KEY = "PANEL_LIBRARY";
    public static final String COMMIT_TO_PROVIDER_KEY = "COMMIT_TO_PROVIDER_KEY";
    private String m_type;
    private Map<String, Navigable> m_panels = new HashMap<String, Navigable>();
    private Map<String, String> m_helpIDs;
    private Navigable[] m_defaultPanels;
    private static String s_baseNamePrefix = null;
    private boolean m_alwaysAddDefaultPanels;

    protected PanelLibrary(String type) {
        this(type, null);
    }

    protected PanelLibrary(String type, Map<String, String> helpIDs) {
        this.m_type = type;
        this.m_helpIDs = helpIDs;
    }

    public String getType() {
        return this.m_type;
    }

    public final void setDefaultPanels(Navigable[] navs) {
        this.setDefaultPanels(navs, false);
    }

    public final void setDefaultPanels(Navigable[] navs, boolean alwaysAddDefaultPanels) {
        this.m_defaultPanels = navs;
        this.m_alwaysAddDefaultPanels = alwaysAddDefaultPanels;
    }

    protected final Navigable[] getDefaultPanels(boolean edit) {
        return this.m_defaultPanels;
    }

    protected final void addDefaultPanels(List<Navigable> navs, boolean edit) {
        Navigable[] defPanels = this.getDefaultPanels(edit);
        if (navs != null && defPanels != null && (navs.size() > 0 || this.m_alwaysAddDefaultPanels)) {
            for (int i = 0; i < defPanels.length; ++i) {
                Navigable navCopy = (Navigable)defPanels[i].copyTo(null);
                navs.add(navCopy);
            }
        }
    }

    protected Class<? extends Traversable> getHeader() {
        if (this.getSimpleTitles() != null) {
            return NameAndSchemaAdvancedEditor.class;
        }
        return NameAndSchemaEditor.class;
    }

    public Component getInitialFocus(Traversable mainPanel) {
        if (mainPanel instanceof DBTraversablePanel) {
            return ((DBTraversablePanel)mainPanel).getDefaultFocusComponent();
        }
        return null;
    }

    public final Traversable getMainDialogPanel(DBObject obj, DBObjectProvider pro, DBObject child, Navigable[] navs) {
        String startPage = this.getStartPage(child);
        Traversable header = null;
        try {
            if (this.getHeader() != null) {
                header = this.getHeader().newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.createMainPanel(header, navs, startPage);
    }

    protected Traversable createMainPanel(Traversable header, Navigable[] navs, String startPage) {
        int simpleSize;
        List<Navigable> simples = this.getSimpleNavigables();
        int n = simpleSize = simples == null ? 0 : simples.size();
        if (simpleSize > 0 && navs.length > simpleSize) {
            return new MDDEditorPanel(header, navs, startPage, simpleSize);
        }
        return new TabbedEditorPanel(header, navs, startPage);
    }

    public final List<Navigable> getCreateNavigables(DBObject obj, DBObjectProvider pro) {
        List<Navigable> navs = this.getNavigables(this.getTitles(obj, pro, false), false, false);
        if (navs != null) {
            this.addDefaultPanels(navs, false);
        }
        return navs;
    }

    public final Map<String, Class> getCreateVerifiers() {
        return this.getVerifiers(false);
    }

    public boolean canEditObject(DBObject obj, DBObjectProvider pro) {
        List<Navigable> navs = this.getEditNavigables(obj, pro);
        return navs != null;
    }

    public final List<Navigable> getEditNavigables(DBObject obj, DBObjectProvider pro) {
        List<Navigable> navs = this.getNavigables(this.getTitles(obj, pro, true), true, false);
        if (navs != null && obj instanceof SystemObject) {
            this.addDefaultPanels(navs, true);
        }
        return navs;
    }

    public final Map<String, Class> getEditVerifiers() {
        return this.getVerifiers(true);
    }

    public final List<Navigable> getSimpleNavigables() {
        List<String> titles = this.getSimpleTitles();
        if (titles != null) {
            return this.getNavigables(titles, false, true);
        }
        return null;
    }

    public final DBObject getObjectForCreate(Schema schema, DBObjectProvider pro, DBObject parent) {
        DBObject retval = this.newDBObject(pro, schema, parent);
        this.makeNameUnique(retval, schema, pro, parent);
        retval.setID(TemporaryObjectID.createID((DBObject)retval));
        return retval;
    }

    public final void makeNameUnique(DBObject dbo, Schema schema, DBObjectProvider pro, DBObject parent) {
        Schema nameContext;
        String base = dbo.getName();
        if (pro.getDescriptor().getCasePolicy() == 1) {
            base = base.toLowerCase();
        }
        Object object = nameContext = parent == null ? schema : parent;
        if ("INDEX".equals(this.m_type) || "TRIGGER".equals(this.m_type)) {
            nameContext = schema;
        } else if ("TABLESPACE".equals(this.m_type)) {
            nameContext = null;
        }
        String name = pro.getUniqueName(this.m_type, (DBObject)nameContext, base);
        dbo.setName(name);
        if (dbo instanceof SchemaObject) {
            ((SchemaObject)dbo).setSchema(schema);
        }
    }

    protected String getUniqueName(String type) {
        String base = type;
        if (s_baseNamePrefix != null && s_baseNamePrefix.length() > 0) {
            base = s_baseNamePrefix + base;
        }
        if (base.indexOf(" ") >= 0) {
            StringBuilder buff = new StringBuilder();
            StringTokenizer tok = new StringTokenizer(base, " ");
            while (tok.hasMoreElements()) {
                String next = tok.nextToken();
                if (tok.hasMoreElements()) {
                    buff.append(next.substring(0, 1));
                    continue;
                }
                buff.append(next);
            }
            base = buff.toString();
        }
        return base + 1;
    }

    public String getStartPage(DBObject child) {
        return null;
    }

    protected DBObject newDBObject(DBObjectProvider pro, Schema schema, DBObject parent) {
        Class clz = Metadata.getInstance().getObjectClass(this.m_type);
        DBObject retval = SchemaObject.class.isAssignableFrom(clz) ? pro.getObjectFactory().newObject(clz, (DBObject)schema) : pro.getObjectFactory().newObject(clz, parent);
        return retval;
    }

    protected abstract List<String> getTitles(DBObject var1, DBObjectProvider var2, boolean var3);

    protected Map<String, Class> getVerifiers(boolean editing) {
        return Collections.emptyMap();
    }

    protected List<String> getSimpleTitles() {
        return null;
    }

    private final List<Navigable> getNavigables(List<String> titles, boolean edit, boolean simple) {
        if (titles == null) {
            return null;
        }
        Navigable[] defPanels = this.getDefaultPanels(edit);
        ArrayList<Navigable> retval = new ArrayList<Navigable>();
        for (String title : titles) {
            Navigable panel = this.m_panels.get(title);
            if (panel == null && simple && defPanels != null) {
                for (int i = 0; i < defPanels.length; ++i) {
                    if (!title.equals(defPanels[i].getShortLabel())) continue;
                    panel = defPanels[i];
                    break;
                }
            }
            if (panel == null) {
                DBLog.getLogger().warning("no such editor panel " + title);
                continue;
            }
            panel = (Navigable)panel.copyTo(null);
            if (this.m_helpIDs != null && this.m_helpIDs.containsKey(title)) {
                panel.setHelpID(this.m_helpIDs.get(title));
            }
            retval.add(panel);
        }
        return retval;
    }

    protected final Navigable addPanel(String title, Class clz, String helpId) {
        return this.addPanel(title, clz, helpId, null, null);
    }

    protected final Navigable addPanel(String title, Class clz, String helpId, Class[] constructorSig, Object[] constructorArgs) {
        Navigable n = new Navigable(title, clz, constructorSig, constructorArgs, null);
        n.setHelpID(helpId);
        this.addNavigable(title, n);
        return n;
    }

    protected final void addNavigable(String title, Navigable n) {
        this.m_panels.put(title, n);
    }

    public Dimension getSize(boolean edit) {
        return null;
    }

    public String getCreateText() {
        return DBTypeDisplayRegistry.getNewMenuItemText(this.getType());
    }

    public abstract String getCreateTitle();

    public abstract String getEditTitle();

    public boolean canReplaceByDefault() {
        return false;
    }

    public static void setBaseNamePrefix(String baseNamePrefix) {
        s_baseNamePrefix = baseNamePrefix;
    }

    public static interface HeaderPanel {
        public static final String HEADER_PANEL_KEY = "HEADER_PANEL";
        public static final String DEFAULT_PANEL_KEY = "DEFAULT_PANEL";

        public void addHeaderPanelListener(HeaderPanelListener var1);

        public boolean removeHeaderPanelListener(HeaderPanelListener var1);

        public void validatePanelChange(TraversableContext var1) throws TraversalException;
    }

    public static interface HeaderPanelListener {
        public void panelSetChange(String var1, Navigable[] var2) throws TraversalException;
    }
}

