/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.table.XMLTypeColumnPropertiesPanel;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleNestedTableProperties;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class DataTypePanel
extends JPanel
implements ActionListener {
    private DataTypeUsage m_usage;
    private DataType m_dataType;
    private DBObjectProvider m_prov;
    private Column m_col;
    private boolean m_nestedTable;
    private boolean m_xmlType;
    private HashMap m_componentMap = new HashMap();
    private JPanel m_panel = new JPanel();
    private JScrollPane m_scrollPane = new JScrollPane(20, 31);
    private JButton m_xmltypePropsButt = new JButton();
    private XMLTypeColumnProperties m_XMLTypeColumnProperties = null;
    private ColumnInfoVerifier m_verifier = null;
    private static Long LONG_0 = new Long(0L);

    public DataTypePanel() {
        this.setLayout(new BorderLayout());
        this.m_panel.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_xmltypePropsButt, (String)UIArb.getString(506));
        this.m_xmltypePropsButt.setName("DataTypePanel.m_xmltypePropsButt");
        this.m_xmltypePropsButt.addActionListener(this);
    }

    @Deprecated
    public void initialise(DataTypeUsage dataTypeUsage, DBObjectProvider provider, Column col) {
        this.initialise(dataTypeUsage, provider, col, null);
    }

    public void initialise(DataTypeUsage dataTypeUsage, DBObjectProvider provider, Column col, ColumnInfoVerifier verifier) {
        this.m_usage = dataTypeUsage;
        this.m_dataType = null;
        this.m_prov = provider;
        this.m_col = col;
        this.m_verifier = verifier;
        this.m_nestedTable = false;
        this.m_xmlType = false;
        this.m_XMLTypeColumnProperties = null;
        this.removeAll();
        this.m_panel.removeAll();
        this.m_componentMap.clear();
        if (this.m_usage != null) {
            try {
                this.m_dataType = DataTypeHelper.getDataType((DataTypeUsage)this.m_usage);
            }
            catch (DBException ex) {
                // empty catch block
            }
        }
        if (this.m_dataType != null) {
            DataTypeAttribute[] attributes = this.m_dataType.getDataTypeAttributes();
            if (this.m_usage instanceof ObjectTypeUsage) {
                ComplexType typ = null;
                try {
                    typ = this.m_dataType instanceof ComplexType ? (ComplexType)this.m_dataType : (ComplexType)this.m_usage.getDataTypeID().resolveID();
                }
                catch (DBException e) {
                    // empty catch block
                }
                if (typ != null && "TABLE".equals(typ.getCollectionType())) {
                    this.m_nestedTable = true;
                    attributes = this.pseudoNestedTableAttributes();
                } else if (DataTypeHelper.isXMLType(typ)) {
                    this.m_xmlType = true;
                }
            }
            int numComponents = 0;
            if (attributes != null && attributes.length > 0) {
                for (int idx = 0; idx < attributes.length; ++idx) {
                    if (!attributes[idx].isDeclarable()) continue;
                    JLabel label = new JLabel();
                    Component field = this.getComponent(attributes[idx]);
                    this.m_componentMap.put(attributes[idx].getName(), field);
                    if (field instanceof JCheckBox) {
                        ResourceUtils.resButton((AbstractButton)((JCheckBox)field), (String)attributes[idx].getLabel());
                        this.m_panel.add(field, new GridBagConstraints(0, idx, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 10), 0, 0));
                    } else {
                        ResourceUtils.resLabel((JLabel)label, (Component)field, (String)(attributes[idx].getLabel() + ':'));
                        this.m_panel.add((Component)label, new GridBagConstraints(0, idx, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 10), 0, 0));
                        this.m_panel.add(field, new GridBagConstraints(1, idx, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 5, 0), 0, 0));
                    }
                    ++numComponents;
                }
            }
            if (this.m_xmlType && this.m_prov.getDescriptor().supportsFeature("XMLTYPE COLUMN STORAGE PROPERTIES")) {
                this.m_panel.add((Component)this.m_xmltypePropsButt, new GridBagConstraints(1, numComponents++, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
                this.setEnabled(true);
            }
            if (numComponents > 0) {
                this.m_panel.add(Box.createVerticalGlue(), new GridBagConstraints(1, numComponents, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
                if (numComponents > 2) {
                    this.m_scrollPane.setViewportView(this.m_panel);
                    this.add((Component)this.m_scrollPane, "Center");
                } else {
                    this.add((Component)this.m_panel, "Center");
                }
            }
        }
        this.validate();
        this.repaint();
    }

    public DataTypeUsage commit(Column col) throws TraversalException {
        boolean NestedTableType = false;
        if (this.m_usage instanceof ObjectTypeUsage) {
            XMLTypeColumnProperties xcp;
            OracleColumnProperties ocp;
            ComplexType typ = null;
            try {
                typ = (ComplexType)this.m_usage.getDataTypeID().resolveID();
            }
            catch (DBException e) {
                // empty catch block
            }
            if (typ != null && "TABLE".equals(typ.getCollectionType())) {
                ocp = (OracleColumnProperties)col.getProperty("OracleColumnProperties");
                if (ocp == null) {
                    ocp = new OracleColumnProperties();
                }
                OracleNestedTableProperties ntp = new OracleNestedTableProperties();
                JTextField nestedTable = (JTextField)this.m_componentMap.get("NestedTable");
                String nestedTableName = this.m_prov.getInternalName(nestedTable.getText());
                try {
                    this.m_prov.validateName("TABLE", nestedTableName);
                }
                catch (InvalidNameException ine) {
                    throw new TraversalException(StringUtils.stripMnemonic((String)DBArb.getString((int)184)) + ": " + ine.getMessage());
                }
                JComboBox returnAs = (JComboBox)this.m_componentMap.get("ReturnAs");
                ntp.setTableName(nestedTableName);
                ntp.setReturnAs((String)returnAs.getSelectedItem());
                ocp.setNestedTableProperties(ntp);
                col.setProperty("OracleColumnProperties", (Object)ocp);
                NestedTableType = true;
            } else if (DataTypeHelper.isXMLType((DataType)typ) && (ocp = (OracleColumnProperties)this.m_col.getProperty("OracleColumnProperties")) != null && (xcp = ocp.getXMLTypeColumnProperties()) != null) {
                OracleColumnProperties ocpNew = (OracleColumnProperties)col.getProperty("OracleColumnProperties");
                if (ocpNew == null) {
                    ocpNew = new OracleColumnProperties();
                    col.setProperty("OracleColumnProperties", (Object)ocp);
                }
                ocpNew.setXMLTypeColumnProperties((XMLTypeColumnProperties)xcp.copyTo(null));
            }
        }
        if (this.m_usage != null && !NestedTableType) {
            for (String attrName : this.m_componentMap.keySet()) {
                Object attVal;
                Object value;
                Component component = (Component)this.m_componentMap.get(attrName);
                if (component instanceof NumberField) {
                    value = ((NumberField)((Object)component)).getNumber();
                    if (value == null) {
                        attVal = this.m_usage.getAttributeValue(attrName);
                        if (attVal instanceof String && ModelUtil.hasLength((String)((String)attVal))) {
                            this.m_usage.deleteAttributeValue(attrName);
                            continue;
                        }
                        if (attVal == null) continue;
                        this.m_usage.deleteAttributeValue(attrName);
                        continue;
                    }
                    this.m_usage.putAttributeValue(attrName, value);
                    continue;
                }
                if (component instanceof JTextField) {
                    Object oldValue;
                    value = ((JTextField)component).getText();
                    if (((String)value).length() == 0 && !this.m_dataType.getDataTypeAttribute(attrName).isMandatory()) {
                        attVal = this.m_usage.getAttributeValue(attrName);
                        if (attVal instanceof String && ModelUtil.hasLength((String)((String)attVal))) {
                            this.m_usage.deleteAttributeValue(attrName);
                            continue;
                        }
                        if (attVal == null) continue;
                        this.m_usage.deleteAttributeValue(attrName);
                        continue;
                    }
                    if (this.m_usage instanceof ObjectTypeUsage && attrName.equals("NestedTable")) {
                        value = this.m_prov.getInternalName((String)value);
                    }
                    if ((oldValue = this.m_usage.getAttributeValue(attrName)) instanceof Number && oldValue.toString().equals(value)) continue;
                    this.m_usage.putAttributeValue(attrName, value);
                    continue;
                }
                if (component instanceof JCheckBox) {
                    if (((JCheckBox)component).isSelected()) {
                        this.m_usage.putAttributeValue(attrName, (Object)this.m_dataType.getDataTypeAttribute(attrName).getValues()[0]);
                        continue;
                    }
                    this.m_usage.deleteAttributeValue(attrName);
                    continue;
                }
                if (!(component instanceof JComboBox)) continue;
                value = (String)((JComboBox)component).getSelectedItem();
                if (value == null) {
                    this.m_usage.deleteAttributeValue(attrName);
                    continue;
                }
                this.m_usage.putAttributeValue(attrName, value);
            }
        }
        return this.m_usage;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_scrollPane.setEnabled(enabled);
        this.m_panel.setEnabled(enabled);
        Component[] kids = this.m_panel.getComponents();
        for (int i = 0; kids != null && i < kids.length; ++i) {
            kids[i].setEnabled(enabled);
        }
    }

    private Component getComponent(DataTypeAttribute attribute) {
        return attribute.getValueType() == 1 ? this.getNumberTextField(attribute) : this.getStringComponent(attribute);
    }

    private Component getNumberTextField(DataTypeAttribute attribute) {
        NumberField numberField = new NumberField(attribute);
        Long value = DataTypeHelper.getLongAttributeValue((DataTypeUsage)this.m_usage, (String)attribute.getName());
        if (value == null && attribute.isMandatory() && (value = (Long)attribute.getDefaultValue()) == null) {
            value = attribute.getMinValue();
        }
        if (value != null) {
            numberField.setNumber(value);
        }
        return numberField;
    }

    private Component getStringComponent(DataTypeAttribute attribute) {
        String[] attributeValues = attribute.getValues();
        if (attributeValues == null) {
            return this.getTextField(attribute);
        }
        if (attributeValues.length == 1 && !attribute.isExtensible() && attribute.getDefaultValue() == null) {
            return this.getCheckBox(attribute);
        }
        return this.getComboBox(attribute);
    }

    private Component getTextField(DataTypeAttribute attribute) {
        JTextField textField = this.isOracleNumberPrecision(attribute) ? new OracleNumberPrecision() : new JTextField();
        textField.setEnabled(true);
        Object value = null;
        if (this.m_nestedTable && "NestedTable".equals(attribute.getName())) {
            OracleNestedTableProperties ntp;
            OracleColumnProperties ocp = (OracleColumnProperties)this.m_col.getProperty("OracleColumnProperties");
            if (ocp != null && (ntp = ocp.getNestedTableProperties()) != null) {
                value = this.m_prov.getExternalName(ntp.getTableName());
            }
        } else {
            value = this.m_usage.getAttributeValue(attribute.getName());
        }
        if (value == null && attribute.isMandatory()) {
            value = attribute.getDefaultValue();
        }
        if (value != null) {
            String strValue = value.toString();
            textField.setText(strValue);
        }
        return textField;
    }

    private boolean isOracleNumberPrecision(DataTypeAttribute attribute) {
        DataType dataType = this.m_dataType instanceof DataTypeSynonym ? ((DataTypeSynonym)this.m_dataType).getBaseType() : this.m_dataType;
        return dataType instanceof OracleNumberDataType && attribute.getName() == "precision";
    }

    private Component getCheckBox(DataTypeAttribute attribute) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setEnabled(true);
        Object value = this.m_usage.getAttributeValue(attribute.getName());
        checkBox.setSelected(value != null);
        return checkBox;
    }

    private Component getComboBox(DataTypeAttribute attribute) {
        JComboBox<String> comboBox = new JComboBox<String>();
        DefaultComboBoxModel<String> values = new DefaultComboBoxModel<String>(attribute.getValues());
        Object value = null;
        if (this.m_nestedTable && "ReturnAs".equals(attribute.getName())) {
            OracleNestedTableProperties ntp;
            OracleColumnProperties ocp = (OracleColumnProperties)this.m_col.getProperty("OracleColumnProperties");
            if (ocp != null && (ntp = ocp.getNestedTableProperties()) != null) {
                value = ntp.getReturnAs();
            }
        } else {
            value = this.m_usage.getAttributeValue(attribute.getName());
        }
        if (attribute.isMandatory()) {
            if (value == null && (value = attribute.getDefaultValue()) == null) {
                value = attribute.getValues()[0];
            }
        } else if (values.getIndexOf(null) < 0) {
            values.insertElementAt(null, 0);
        }
        values.setSelectedItem(value == null ? null : value.toString());
        comboBox.setModel(values);
        comboBox.setEnabled(true);
        comboBox.setEditable(attribute.isExtensible());
        return comboBox;
    }

    private DataTypeAttribute[] pseudoNestedTableAttributes() {
        DataTypeAttribute[] attributes = new DataTypeAttribute[2];
        String[] ntReturnAsVals = new String[]{"VALUE", "LOCATOR"};
        attributes[0] = new DataTypeAttribute("NestedTable", 184, "", true);
        attributes[1] = new DataTypeAttribute("ReturnAs", 185, ntReturnAsVals, ntReturnAsVals[0], false, true);
        return attributes;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_xmltypePropsButt) {
            this.showXmlTypeColPropsDlg();
        }
    }

    private void showXmlTypeColPropsDlg() {
        OracleColumnProperties ocp = (OracleColumnProperties)this.m_col.getProperty("OracleColumnProperties");
        if (ocp != null) {
            this.m_XMLTypeColumnProperties = ocp.getXMLTypeColumnProperties();
        }
        this.m_XMLTypeColumnProperties = this.m_XMLTypeColumnProperties == null ? new XMLTypeColumnProperties() : (XMLTypeColumnProperties)this.m_XMLTypeColumnProperties.copyTo(null);
        int buttonMask = 7;
        JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)this), (String)UIArb.getString(947), (int)buttonMask);
        boolean readOnly = false;
        if (this.m_verifier != null) {
            readOnly = !this.m_verifier.canChangeColumnSize(this.m_col);
        }
        final XMLTypeColumnPropertiesPanel panel = new XMLTypeColumnPropertiesPanel(this.m_prov, this.m_XMLTypeColumnProperties, readOnly);
        panel.setHelpID("f1_odbtaxmltypecolprops_html");
        panel.setPreferredSize(new Dimension(500, 200));
        dialog.setContent((Component)((Object)panel));
        dialog.setResizable(true);
        VetoableChangeListener list = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    try {
                        DataTypePanel.this.m_XMLTypeColumnProperties = panel.getProps();
                    }
                    catch (TraversalException e) {
                        DataTypePanel.this.m_XMLTypeColumnProperties = null;
                        MessageDialog.error((Component)((Object)panel), (Object)e.getMessage(), null, null);
                        throw new PropertyVetoException(e.getMessage(), evt);
                    }
                }
            }
        };
        dialog.addVetoableChangeListener(list);
        dialog.runDialog();
        if (this.m_XMLTypeColumnProperties != null) {
            if (ocp == null) {
                ocp = new OracleColumnProperties();
                this.m_col.setProperty("OracleColumnProperties", (Object)ocp);
            }
            ocp.setXMLTypeColumnProperties(this.m_XMLTypeColumnProperties);
        }
    }

    private static class OracleNumberPrecision
    extends JTextField {
        private OracleNumberPrecision() {
        }

        @Override
        public void replaceSelection(String content) {
            boolean isValid;
            String value = this.getText();
            int selStart = this.getSelectionStart();
            int selEnd = this.getSelectionEnd();
            String newValue = value.substring(0, selStart) + content;
            if (selEnd < value.length()) {
                newValue = newValue + value.substring(selEnd);
            }
            boolean bl = isValid = newValue.length() <= 2;
            if (isValid) {
                if (newValue.length() == 1 && !newValue.matches("[123456789*]")) {
                    isValid = false;
                } else if (newValue.length() == 2) {
                    char c1 = newValue.charAt(0);
                    char c2 = newValue.charAt(1);
                    if (c1 < '1' || c1 > '3' || c2 < '0' || c2 > '9' || c1 == '3' && c2 > '8') {
                        isValid = false;
                    }
                }
            }
            this.setText(isValid ? newValue : value);
        }
    }

    private static class NumberField
    extends NumberTextField {
        private DataTypeAttribute m_attribute;

        public NumberField(DataTypeAttribute attribute) {
            this.setDataType(Long.class);
            this.setEnabled(true);
            this.setSigned(attribute.getMinValue() == null || attribute.getMinValue().compareTo(LONG_0) < 0);
            this.m_attribute = attribute;
        }

        public void setNumber(Number n) {
            if (this.m_attribute != null) {
                if (!this.m_attribute.isDeclarable()) {
                    n = null;
                } else if (n == null && this.m_attribute.isMandatory()) {
                    n = (Long)this.m_attribute.getDefaultValue();
                }
            }
            super.setNumber(n);
        }

        protected boolean validateNumber(Number n) {
            long value = n.longValue();
            Long minSize = this.m_attribute.getMinValue();
            Long maxSize = this.m_attribute.getMaxValue();
            return maxSize == null || minSize != null && value >= minSize && value <= maxSize;
        }
    }
}

