/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ReadOnlyScrollPane
extends JScrollPane {
    private JTextArea m_textArea = new JTextArea();
    private Component m_parent;

    public ReadOnlyScrollPane() {
        this(null);
    }

    public ReadOnlyScrollPane(Component parent) {
        this.m_parent = parent;
        this.getViewport().add((Component)this.m_textArea, null);
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(31);
        this.m_textArea.setLineWrap(true);
        this.m_textArea.setWrapStyleWord(true);
        this.m_textArea.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                e.consume();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if (e.isShiftDown()) {
                        ReadOnlyScrollPane.this.m_textArea.transferFocusBackward();
                    } else {
                        ReadOnlyScrollPane.this.m_textArea.transferFocus();
                    }
                }
                if (!(e.isActionKey() || e.isControlDown() && e.getKeyCode() == 67)) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void setText(String text, boolean gainFocus) {
        this.m_textArea.setText(text);
        this.m_textArea.getAccessibleContext().setAccessibleDescription(text);
        if (gainFocus) {
            this.m_textArea.requestFocusInWindow();
        }
        this.m_textArea.setCaretPosition(0);
    }

    public JTextArea getTextArea() {
        return this.m_textArea;
    }

    @Override
    public void validate() {
        if (this.m_parent != null) {
            this.m_textArea.setBackground(this.m_parent.getBackground());
        }
        super.validate();
    }
}

