/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.util.LiveValidationController;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ValidationException;

public class NameTextField
extends JTextField {
    private boolean m_listening;
    private Timer m_timer;
    private LiveValidationController m_vController;
    private DBObject m_originalObject;
    private DBObject m_dbObject;
    private DBObjectProvider m_pro;
    private boolean m_currentlyInvalid = false;

    public NameTextField() {
        this(true);
    }

    public NameTextField(boolean popupValidation) {
        this.setColumns(30);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameTextField.this.commitName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NameTextField.this.commitName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NameTextField.this.commitName();
            }
        });
        if (popupValidation) {
            this.m_vController = new LiveValidationController(this);
        }
    }

    public void commitName() {
        if (this.m_listening) {
            if (this.m_currentlyInvalid) {
                this.showNameError(this.commitIdentifier());
            }
            this.getTimer().restart();
        }
    }

    public void init(DBObject obj, DBObjectProvider pro) {
        this.init(obj, null, pro);
    }

    public void init(DBObject obj, DBObject originalObj, DBObjectProvider pro) {
        this.m_originalObject = originalObj;
        this.m_pro = pro;
        this.m_dbObject = obj;
        this.setText(pro.getExternalName(obj.getName(), obj.getType()));
        this.m_listening = true;
    }

    public void commit() throws TraversalException {
        String err = this.commitIdentifier();
        if (err != null) {
            throw new TraversalException(err);
        }
        this.m_listening = false;
    }

    protected Timer getTimer() {
        if (this.m_timer == null) {
            ActionListener alist = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NameTextField.this.showNameError(NameTextField.this.commitIdentifier());
                }
            };
            this.m_timer = new Timer(1500, alist);
            this.m_timer.setRepeats(false);
        }
        return this.m_timer;
    }

    private String commitIdentifier() {
        this.m_currentlyInvalid = true;
        this.getTimer().stop();
        if (this.m_dbObject != null && this.m_listening) {
            boolean sameAsOriginal;
            String type = this.m_dbObject.getType();
            String oldName = this.m_dbObject.getName();
            String name = this.getText();
            try {
                this.m_pro.validateName(type, name);
            }
            catch (ValidationException ve) {
                return ve.getLocalizedMessage();
            }
            name = this.m_pro.getInternalName(name, type);
            this.m_dbObject.setName(name);
            boolean bl = sameAsOriginal = this.m_originalObject != null && name.equals(this.m_originalObject.getName());
            if (!sameAsOriginal) {
                Object parent;
                String unique;
                if (this.m_dbObject instanceof SchemaObject) {
                    PropertyChangeEvent eve = new PropertyChangeEvent(this.m_dbObject, "name", oldName, name);
                    DBObjectChange.firePropertyChanged((SystemObject)((SchemaObject)this.m_dbObject), (PropertyChangeEvent[])new PropertyChangeEvent[]{eve});
                }
                if (!name.equals(unique = this.m_pro.getUniqueName(type, parent = this.m_dbObject instanceof SchemaObject ? ((SchemaObject)this.m_dbObject).getSchema() : this.m_dbObject.getParent(), name))) {
                    return UIArb.getString(120);
                }
            }
        }
        this.m_currentlyInvalid = false;
        return null;
    }

    protected void showNameError(String error) {
        if (this.m_vController != null) {
            this.m_vController.showError(error);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.m_vController != null) {
            this.m_vController.hidePopup();
        }
        super.setEnabled(enabled);
    }
}

