/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameTextField;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.icons.OracleIcons;

public class NameEditor<T extends SystemObject>
extends BaseEditorPanel<T>
implements ActionListener,
PanelLibrary.HeaderPanel {
    private List<PanelLibrary.HeaderPanelListener> m_list = new ArrayList<PanelLibrary.HeaderPanelListener>();
    private final NameTextField m_fldName = new NameTextField();
    private final JLabel m_templateHint = new JLabel();
    protected boolean m_listening;
    protected String m_initialName;

    public NameEditor() {
        this.buildPanel((JPanel)((Object)this));
    }

    private void buildPanel(JPanel pnlInfo) {
        pnlInfo.setLayout(new GridBagLayout());
        JLabel lblName = new JLabel();
        this.getHelper().registerComponent(lblName, this.m_fldName, UIArb.getString(109), "Name", "name");
        this.m_fldName.setColumns(24);
        pnlInfo.add((Component)lblName, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
        pnlInfo.add((Component)this.m_fldName, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        pnlInfo.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        GridBagConstraints gb = this.getTemplateHintGridBagConstants();
        pnlInfo.add((Component)this.m_templateHint, this.getTemplateHintGridBagConstants());
    }

    protected GridBagConstraints getTemplateHintGridBagConstants() {
        return new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0), 0, 0);
    }

    @Override
    protected boolean isEditable() {
        return super.isEditable() && !this.childEditOnly();
    }

    protected boolean childEditOnly() {
        return this.getDataContext().get("standAlone") == Boolean.TRUE;
    }

    @Override
    protected void initialisePanel() {
        DBObjectProvider pro = this.getProvider();
        SystemObject obj = (SystemObject)this.getDBObject();
        this.m_fldName.init((DBObject)obj, (DBObject)this.getOriginalObject(), pro);
        SystemObject realObj = obj;
        if (this.childEditOnly()) {
            realObj = (DBObject)this.getDataContext().get("NewChildObject");
        }
        this.m_listening = true;
        String templateName = TemplateExpander.getTemplateObjectName((DBObject)realObj);
        if (templateName != null) {
            this.m_templateHint.setText(templateName);
            this.m_templateHint.setIcon(OracleIcons.getIcon((String)"copy.png"));
            if (realObj instanceof MaterializedView) {
                this.m_templateHint.setToolTipText(UIArb.format(987, templateName));
            } else if (realObj instanceof Table) {
                this.m_templateHint.setToolTipText(UIArb.format(986, templateName));
            } else if (realObj instanceof PlSql) {
                this.m_templateHint.setToolTipText(UIArb.format(988, templateName));
            } else {
                this.m_templateHint.setToolTipText(UIArb.format(985, templateName));
            }
        } else {
            this.m_templateHint.setVisible(false);
        }
        this.m_initialName = obj.getName();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        this.m_listening = false;
        this.m_initialName = null;
        this.m_fldName.commit();
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.m_fldName;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.m_listening) {
            this.m_fldName.getTimer().restart();
        }
    }

    @Override
    public final void addHeaderPanelListener(PanelLibrary.HeaderPanelListener list) {
        this.m_list.add(list);
    }

    @Override
    public final boolean removeHeaderPanelListener(PanelLibrary.HeaderPanelListener list) {
        return this.m_list.remove(list);
    }

    protected void setInitialName(String initName) {
        this.m_initialName = initName;
    }

    protected String getInitialName() {
        return this.m_initialName;
    }

    protected void setNameField(String newName) {
        ((SystemObject)this.getDBObject()).setName(newName);
        this.m_fldName.setText(this.getProvider().getExternalName(((SystemObject)this.getDBObject()).getName(), ((SystemObject)this.getDBObject()).getType()));
        this.setInitialName(newName);
    }

    protected final void changePanels(String key, Navigable[] navs) throws TraversalException {
        for (PanelLibrary.HeaderPanelListener list : this.m_list) {
            list.panelSetChange(key, navs);
        }
    }

    @Override
    public void validatePanelChange(TraversableContext data) throws TraversalException {
    }
}

