/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.controls.NameEditor;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public class NameAndSchemaEditor<T extends SchemaObject>
extends NameEditor<T> {
    private List<PanelLibrary.HeaderPanelListener> m_list = new ArrayList<PanelLibrary.HeaderPanelListener>();
    private final DBObjectChooser m_cmbOwner = new DBObjectChooser("SCHEMA");
    private JLabel m_lblPlsqlLowerCase = new JLabel();
    private JCheckBox m_chkPlsqlLowerCase = new JCheckBox();

    public NameAndSchemaEditor() {
        this.buildPanel((JPanel)((Object)this));
    }

    private void buildPanel(JPanel pnlInfo) {
        JLabel lblOwner = new JLabel();
        this.m_cmbOwner.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                if (NameAndSchemaEditor.this.m_listening) {
                    try {
                        NameAndSchemaEditor.this.commitSchema();
                    }
                    catch (TraversalException traversalException) {
                        // empty catch block
                    }
                }
            }
        });
        this.getHelper().registerComponent(lblOwner, this.m_cmbOwner, UIArb.getString(108), "Schema", "schema");
        pnlInfo.add((Component)lblOwner, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        pnlInfo.add((Component)this.m_cmbOwner, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getHelper().registerComponent(this.m_chkPlsqlLowerCase, UIArb.getString(962), "PlSqlLowercase", null);
        pnlInfo.add((Component)this.m_chkPlsqlLowerCase, new GridBagConstraints(0, 100, 0, 0, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void commitSchema() throws TraversalException {
        SchemaObject obj = (SchemaObject)this.getDBObject();
        Schema oldSchema = obj.getSchema();
        Schema schema = (Schema)this.m_cmbOwner.getOrCreateDBObject();
        obj.setSchema(schema);
        if (ModelUtil.areDifferent((Object)oldSchema, (Object)schema)) {
            DBObjectChange.firePropertyChanged((SystemObject)obj, (PropertyChangeEvent[])new PropertyChangeEvent[]{new PropertyChangeEvent(obj, "schema", oldSchema, schema)});
            if (!this.isEditing() && obj.getName().equals(this.getInitialName())) {
                this.setNameField(this.getUniqueNameWithinSchema(schema));
            }
        }
    }

    private Schema[] validateSchemaPermissions(Schema[] schemas) {
        DBObjectProvider pro = this.getProvider();
        if (pro instanceof Database && schemas != null) {
            ArrayList<Schema> retval = new ArrayList<Schema>();
            String type = ((SchemaObject)this.getDBObject()).getType();
            for (int i = 0; i < schemas.length; ++i) {
                if (!pro.hasPriviledge(type, schemas[i], this.isEditing() ? "MODIFY" : "CREATE")) continue;
                retval.add(schemas[i]);
            }
            return retval.toArray(new Schema[retval.size()]);
        }
        return schemas;
    }

    protected DBObjectChooser getSchemaPicker() {
        return this.m_cmbOwner;
    }

    protected String getUniqueNameWithinSchema(Schema schema) {
        Class clz = Metadata.getInstance().getObjectClass(((SchemaObject)this.getDBObject()).getType());
        DBObject retval = null;
        if (SchemaObject.class.isAssignableFrom(clz)) {
            retval = this.getProvider().getObjectFactory().newObject(clz, (DBObject)schema);
        }
        return retval == null ? null : retval.getName();
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        final DBObjectProvider pro = this.getProvider();
        final SchemaObject obj = (SchemaObject)this.getDBObject();
        this.m_cmbOwner.setProvider(pro);
        this.m_cmbOwner.setDBObject((DBObject)obj.getSchema());
        this.m_cmbOwner.setFilter(new DBObjectFilter(){

            public boolean accept(DBObject dbObj) {
                return pro.hasPriviledge(obj.getType(), (Schema)dbObj, NameAndSchemaEditor.this.isEditing() ? "MODIFY" : "CREATE");
            }
        });
        if (pro instanceof Database) {
            this.m_cmbOwner.setEnabled(!this.isEditing());
            this.m_cmbOwner.setEditable(false);
        } else {
            this.m_cmbOwner.setEditable(true);
            this.m_cmbOwner.getDBObjectCriteria().setUserOnly(true);
        }
        SchemaObject realObj = obj;
        if (this.childEditOnly()) {
            realObj = (DBObject)this.getDataContext().get("NewChildObject");
        }
        this.m_listening = true;
        if (obj instanceof SourceObject) {
            this.m_lblPlsqlLowerCase.setVisible(true);
            this.m_chkPlsqlLowerCase.setVisible(true);
            this.m_chkPlsqlLowerCase.setSelected(GlobalSettings.getInstance().isNewPlSqlLowerCase());
            this.m_chkPlsqlLowerCase.setEnabled(this.isEditable());
        } else {
            this.m_lblPlsqlLowerCase.setVisible(false);
            this.m_chkPlsqlLowerCase.setVisible(false);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        this.m_listening = false;
        this.commitSchema();
        if (this.getDBObject() instanceof SourceObject) {
            GlobalSettings.getInstance().setNewPlSqlLowerCase(this.m_chkPlsqlLowerCase.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.m_listening) {
            try {
                this.commitSchema();
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
        }
        super.actionPerformed(ev);
    }
}

