/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.ora.DatabaseLink;

public class NameAndPublicSchemaEditor
extends NameAndSchemaEditor<SchemaObject> {
    public static final String PUBLIC = "PUBLIC";
    private Schema m_lastSchema;
    private JCheckBox m_chkPublic = new JCheckBox();

    public NameAndPublicSchemaEditor() {
        this.getHelper().registerComponent(this.m_chkPublic, UIArb.getString(351), "Public", "public");
        this.m_chkPublic.addActionListener(this);
        this.add(this.m_chkPublic, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        boolean isPublic = this.m_chkPublic.isSelected();
        this.commitPublic(isPublic);
    }

    private void commitPublic(boolean isPublic) {
        SchemaObject obj = (SchemaObject)this.getDBObject();
        if (obj instanceof Synonym) {
            ((Synonym)obj).setPublic(isPublic);
        } else if (obj instanceof DatabaseLink) {
            ((DatabaseLink)obj).setPublic(isPublic);
        }
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        Object obj = this.getDBObject();
        boolean isPublic = false;
        if (obj instanceof Synonym) {
            isPublic = ((Synonym)obj).isPublic();
        } else if (obj instanceof DatabaseLink) {
            isPublic = ((DatabaseLink)obj).isPublic();
        }
        this.setSchema(isPublic);
    }

    private void setSchema(boolean isPublic) {
        this.m_chkPublic.setSelected(isPublic);
        DBObjectChooser cmbSchema = this.getSchemaPicker();
        DBObjectProvider pro = this.getProvider();
        this.m_lastSchema = ((SchemaObject)this.getDBObject()).getSchema();
        if (isPublic) {
            Schema ps = null;
            try {
                ps = this.getProvider().getSchema(PUBLIC);
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "Error finding PUBLIC schema" + dbe.getMessage());
            }
            if (ps == null) {
                ps = new Schema(PUBLIC);
            }
            cmbSchema.setEditable(true);
            cmbSchema.setEnabled(false);
            cmbSchema.setEditable(false);
        } else {
            this.processComponent(cmbSchema);
            if (null == this.m_lastSchema || PUBLIC.equals(this.m_lastSchema.getName())) {
                try {
                    this.m_lastSchema = pro.getDefaultSchema();
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            if (this.m_lastSchema != null) {
                cmbSchema.setDBObject((DBObject)this.m_lastSchema);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DBObject s;
        Object source = e.getSource();
        DBObjectChooser cmbSchema = this.getSchemaPicker();
        if (source == this.m_chkPublic) {
            boolean isPublic = this.m_chkPublic.isSelected();
            this.setSchema(isPublic);
            this.commitPublic(isPublic);
        } else if (source == cmbSchema && (s = cmbSchema.getDBObject()) instanceof Schema && ((Schema)s).getName().equals(PUBLIC)) {
            this.setSchema(true);
        }
        super.actionPerformed(e);
    }
}

