/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ideimpl.db.DBUIHelper;
import oracle.javatools.util.ModelUtil;

public class DBSizeChooser
extends JPanel {
    private JComboBox m_cmbByteMultiple = new JComboBox();
    private NumberTextField m_fldSize = new NumberTextField();
    private String m_name;
    private DBUIHelper m_helper;
    private NonNullableComboBoxModel m_mdlByteMultiples = new NonNullableComboBoxModel();
    private Map<ByteMultiple, BigInteger> m_multiplesAsBytes = new TreeMap<ByteMultiple, BigInteger>();

    public DBSizeChooser() {
        this((String)null);
    }

    public DBSizeChooser(String panelName) {
        this.init(panelName);
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void setName(String name) {
        this.m_name = name;
        this.m_cmbByteMultiple.setName(name);
        this.m_fldSize.setName(name + "_MULTIPLIER");
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public void setEnabled(boolean b) {
        this.m_cmbByteMultiple.setEnabled(b);
        this.m_fldSize.setEnabled(b);
    }

    @Override
    public boolean isEnabled() {
        return this.m_cmbByteMultiple.isEnabled() && this.m_fldSize.isEnabled();
    }

    @Override
    public boolean isVisible() {
        return this.m_cmbByteMultiple.isVisible() && this.m_fldSize.isVisible();
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.m_cmbByteMultiple.setVisible(aFlag);
        this.m_fldSize.setVisible(aFlag);
    }

    private void init(String panelName) {
        this.initialiseMultiplesMap();
        this.m_name = panelName;
        this.m_helper = new DBUIHelper(panelName, this);
        this.m_mdlByteMultiples.addElement((Object)"");
        for (ByteMultiple multiple : ByteMultiple.values()) {
            this.m_mdlByteMultiples.addElement((Object)multiple);
        }
        this.m_cmbByteMultiple.setModel(this.m_mdlByteMultiples);
    }

    private void initialiseMultiplesMap() {
        BigInteger multiplier = new BigInteger("1024");
        BigInteger value = new BigInteger("1024");
        this.m_multiplesAsBytes.put(ByteMultiple.K, value);
        value = value.multiply(multiplier);
        this.m_multiplesAsBytes.put(ByteMultiple.M, value);
        value = value.multiply(multiplier);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_fldSize, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbByteMultiple, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 4, 0, 0), 0, 0));
        this.m_cmbByteMultiple.setMaximumSize(new Dimension(10, 1));
        this.m_fldSize.setMinimumSize(new Dimension(100, 1));
    }

    public void setText(String t) {
        if (ModelUtil.hasLength((String)t)) {
            ByteMultiple[] multiples = ByteMultiple.values();
            BigInteger bytesValue = new BigInteger(t);
            this.m_fldSize.setNumber((Number)bytesValue);
            this.m_cmbByteMultiple.setSelectedIndex(0);
            for (int i = multiples.length - 1; i >= 0; --i) {
                ByteMultiple multiple = multiples[i];
                BigInteger multipleValue = this.m_multiplesAsBytes.get((Object)multiple);
                if (!bytesValue.remainder(multipleValue).equals(BigInteger.ZERO)) continue;
                this.m_cmbByteMultiple.setSelectedIndex(i + 1);
                this.m_fldSize.setNumber((Number)bytesValue.divide(multipleValue));
                break;
            }
        } else {
            this.m_fldSize.setText(null);
            this.m_cmbByteMultiple.setSelectedIndex(0);
        }
    }

    public String getText() {
        if (ModelUtil.hasLength((String)this.m_fldSize.getText())) {
            return this.getNumber().toString();
        }
        return this.m_fldSize.getText();
    }

    public Number getNumber() {
        Object selectedMultiple = this.m_cmbByteMultiple.getSelectedItem();
        if (selectedMultiple instanceof ByteMultiple) {
            BigInteger multiplier = this.m_multiplesAsBytes.get(selectedMultiple);
            if (ModelUtil.hasLength((String)this.m_fldSize.getText())) {
                return multiplier.multiply(new BigInteger(this.m_fldSize.getText()));
            }
            return this.m_fldSize.getNumber();
        }
        return this.m_fldSize.getNumber();
    }

    public void setNumber(Number n) {
        if (n != null) {
            this.setText(n.toString());
        } else {
            this.m_fldSize.setNumber(null);
            this.m_cmbByteMultiple.setSelectedIndex(0);
        }
    }

    public static enum ByteMultiple {
        K,
        M;

    }
}

