/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.relation.RelationInfoVerifier;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.util.ModelUtil;

public class CommentEditor
extends JPanel
implements Traversable {
    public static int NO_LABEL = 0;
    public static int LABEL_ABOVE = 1;
    public static int LABEL_LEFT = 2;
    private JLabel m_label = new JLabel();
    private JScrollPane m_scrollPane = new JScrollPane();
    private JTextArea m_textArea = new JTextArea();
    private DBObjectProvider m_prov;

    public CommentEditor() {
        this(LABEL_ABOVE);
    }

    public CommentEditor(int labelPolicy) {
        this.m_scrollPane.setVerticalScrollBarPolicy(22);
        this.m_scrollPane.setHorizontalScrollBarPolicy(31);
        this.m_textArea.setLineWrap(true);
        this.m_textArea.setWrapStyleWord(true);
        this.m_scrollPane.getViewport().add((Component)this.m_textArea, null);
        this.setLayout(new GridBagLayout());
        int x = 0;
        int y = 0;
        DBUIResourceHelper reshelp = new DBUIResourceHelper("CommentEditor");
        reshelp.resLabel(this.m_label, this.m_textArea, UIArb.getString(537), "Comment");
        if (labelPolicy > NO_LABEL) {
            this.add((Component)this.m_label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
            if (labelPolicy == LABEL_ABOVE) {
                ++y;
            } else {
                ++x;
            }
        }
        this.add((Component)this.m_scrollPane, new GridBagConstraints(x, y, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void init(DBObjectProvider prov, DBObject obj) {
        this.init(prov, obj, null);
    }

    public void init(DBObjectProvider prov, DBObject obj, RelationInfoVerifier verifier) {
        this.m_textArea.setText((String)obj.getProperty("Comment"));
        this.m_prov = prov;
        this.setEnabled(verifier == null || verifier.canChangeComment());
    }

    public void commit(DBObject obj) throws ValidationException {
        String comment = this.m_textArea.getText();
        obj.setProperty("Comment", (Object)(ModelUtil.hasLength((String)comment.trim()) ? comment : null));
        this.m_prov.validateObjectProperty(obj, "Comment");
    }

    @Override
    public void setEnabled(boolean boo) {
        this.m_label.setEnabled(boo);
        this.m_textArea.setEnabled(boo);
    }

    public void onEntry(TraversableContext data) {
        SchemaObject s = (SchemaObject)data.find("NewObject");
        RelationInfoVerifier v = (RelationInfoVerifier)data.find("SchemaObjectInfoVerifier");
        DBObjectProvider pro = (DBObjectProvider)data.get("DBObjectProvider");
        this.init(pro, (DBObject)s, v);
    }

    public Component getComponent() {
        return this;
    }

    public void onExit(TraversableContext data) throws TraversalException {
        SchemaObject s = (SchemaObject)data.find("NewObject");
        try {
            this.commit((DBObject)s);
        }
        catch (ValidationException e) {
            throw new TraversalException(e.getMessage());
        }
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return null;
    }
}

