/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.util.ModelUtil;

public class SchemaObjectDescriptor {
    private transient SystemObject m_obj;
    private String m_name;
    private String m_type;
    private String m_schema;
    private String m_otherName;

    private SchemaObjectDescriptor() {
    }

    public SchemaObjectDescriptor(String name, String type, String schema) {
        this.m_name = name;
        this.m_type = type;
        this.m_schema = schema;
    }

    public SchemaObjectDescriptor(SystemObject obj) {
        if (obj != null) {
            this.m_name = obj.getName();
            this.m_type = obj.getType();
            if (obj instanceof SchemaObject) {
                Schema schema = ((SchemaObject)obj).getSchema();
                this.m_schema = schema.getName();
            }
        }
        this.m_obj = obj;
    }

    public String getName() {
        if (this.m_obj == null) {
            return this.m_name;
        }
        return this.m_obj.getName();
    }

    @Deprecated
    public String getOriginalName() {
        return this.getName();
    }

    public String getType() {
        if (this.m_obj == null) {
            return this.m_type;
        }
        return this.m_obj.getType();
    }

    public String getSchema() {
        Schema schema;
        if (this.m_obj != null && this.m_obj instanceof SchemaObject && (schema = ((SchemaObject)this.m_obj).getSchema()) != null) {
            return schema.getName();
        }
        return this.m_schema;
    }

    public SystemObject getObject() {
        return this.m_obj;
    }

    public String getOtherName() {
        return this.m_otherName;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Deprecated
    public void setOriginalName(String name) {
        this.setName(name);
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setOtherName(String name) {
        this.m_otherName = name;
    }

    public boolean equals(Object obj) {
        return obj instanceof SchemaObjectDescriptor && this.equalsImpl((SchemaObjectDescriptor)obj, false);
    }

    protected boolean equalsImpl(SchemaObjectDescriptor obj, boolean strict) {
        return ModelUtil.areEqual((Object)this.getName(), (Object)obj.getName()) && ModelUtil.areEqual((Object)this.getType(), (Object)obj.getType()) && ModelUtil.areEqual((Object)this.getSchema(), (Object)obj.getSchema()) && (!strict || ModelUtil.areEqual((Object)this.m_name, (Object)obj.m_name));
    }

    public boolean equals(Object obj, boolean strict) {
        return obj instanceof SchemaObjectDescriptor && this.equalsImpl((SchemaObjectDescriptor)obj, strict);
    }

    public Object copyTo(Object obj) {
        SchemaObjectDescriptor copy = obj == null ? new SchemaObjectDescriptor() : (SchemaObjectDescriptor)obj;
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(SchemaObjectDescriptor copy) {
        copy.m_name = this.m_name;
        copy.m_schema = this.m_schema;
        copy.m_type = this.m_type;
        copy.m_otherName = this.m_otherName;
    }

    public String toString() {
        return this.getName() + " (" + this.getSchema() + ")";
    }

    public SchemaObject unwrapDescriptor(DBObjectProvider source) throws DBException {
        if (this.m_obj == null && source != null) {
            Schema dbs = source.getSchema(this.getSchema());
            this.m_obj = source.getObject(this.getType(), dbs, this.getOriginalName());
        }
        return (SchemaObject)this.m_obj;
    }

    public SystemObject unwrapSystemObjectDescriptor(DBObjectProvider source) throws DBException {
        if (this.m_obj == null && source != null) {
            Schema dbs = source.getSchema(this.getSchema());
            DBObjectCriteria dbc = DBObjectCriteria.createCriteria((String)this.getType(), (Schema)dbs, (String)this.getName());
            this.m_obj = source.getObject(dbc);
        }
        return this.m_obj;
    }

    public static SchemaObject[] unwrapDescriptors(SchemaObjectDescriptor[] descs, DBObjectProvider source) throws DBException {
        if (descs != null) {
            SchemaObject[] retval = new SchemaObject[descs.length];
            for (int i = 0; i < descs.length; ++i) {
                retval[i] = descs[i].unwrapDescriptor(source);
            }
            return retval;
        }
        return null;
    }

    public static SystemObject[] unwrapSystemObjectDescriptors(SchemaObjectDescriptor[] descs, DBObjectProvider source) throws DBException {
        if (descs != null) {
            SystemObject[] retval = new SystemObject[descs.length];
            for (int i = 0; i < descs.length; ++i) {
                retval[i] = descs[i].unwrapSystemObjectDescriptor(source);
            }
            return retval;
        }
        return null;
    }

    public static SchemaObjectDescriptor[] createDescriptors(SchemaObject[] objs, boolean saveObj) {
        if (objs != null) {
            SchemaObjectDescriptor[] retval = new SchemaObjectDescriptor[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                retval[i] = saveObj ? new SchemaObjectDescriptor((SystemObject)objs[i]) : new SchemaObjectDescriptor(objs[i].getName(), objs[i].getType(), objs[i].getSchema().getName());
            }
            return retval;
        }
        return null;
    }

    public static SchemaObjectDescriptor[] createDescriptors(SystemObject[] objs, boolean saveObj) {
        if (objs != null) {
            SchemaObjectDescriptor[] retval = new SchemaObjectDescriptor[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                if (saveObj) {
                    retval[i] = new SchemaObjectDescriptor(objs[i]);
                    continue;
                }
                String schema = null;
                if (objs[i] instanceof SchemaObject) {
                    schema = ((SchemaObject)objs[i]).getSchema().getName();
                }
                retval[i] = new SchemaObjectDescriptor(objs[i].getName(), objs[i].getType(), schema);
            }
            return retval;
        }
        return null;
    }

    public static SchemaObjectDescriptor[] createDescriptors(SchemaObject[] objs) {
        return SchemaObjectDescriptor.createDescriptors(objs, true);
    }

    public static SchemaObjectDescriptor[] createDescriptors(SystemObject[] objs) {
        return SchemaObjectDescriptor.createDescriptors(objs, true);
    }

    public static SchemaObjectDescriptor[] createDescriptors(DBObjectID[] ids) {
        if (ids != null) {
            SchemaObjectDescriptor[] retval = new SchemaObjectDescriptor[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                try {
                    DBObject obj = ids[i].resolveID();
                    if (obj == null || !(obj instanceof SystemObject)) continue;
                    retval[i] = new SchemaObjectDescriptor((SystemObject)obj);
                    continue;
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            return retval;
        }
        return null;
    }

    public int hashCode() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_name).append(".").append(this.m_type).append(".").append(this.m_schema);
        return buf.toString().hashCode();
    }
}

