/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import oracle.ideimpl.db.resource.PropertyUI;
import oracle.ideimpl.db.resource.PropertyValueUI;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.util.ModelUtil;

public final class PropertyDisplayRegistry {
    private ExtrasPlugin m_extrasPlugin = new ExtrasPlugin();
    private Collection<Plugin> m_plugins = new ArrayList<Plugin>();
    private Collection<ResourceBundle> m_bundles = new ArrayList<ResourceBundle>();

    private PropertyDisplayRegistry() {
        this.registerBundle(PropertyUI.getBundle());
        this.registerPlugin(this.m_extrasPlugin);
    }

    public static synchronized PropertyDisplayRegistry getInstance() {
        DBCore core = DBCore.getInstance();
        PropertyDisplayRegistry instance = (PropertyDisplayRegistry)core.get(PropertyDisplayRegistry.class);
        if (instance == null) {
            instance = new PropertyDisplayRegistry();
            core.put((Object)instance);
        }
        return instance;
    }

    public static final String getDisplayName(String propName) {
        return PropertyDisplayRegistry.getDisplayName(propName, null, null);
    }

    public static final String getDisplayName(String propName, DBObjectProvider pro, DBObject obj) {
        PropertyDisplayRegistry reg = PropertyDisplayRegistry.getInstance();
        String displayName = reg.getDisplayNameFromResourceBundle(propName);
        if (displayName == null) {
            displayName = reg.getDisplayNameFromPlugins(propName, pro, obj);
        }
        return displayName == null ? propName : displayName;
    }

    private String getDisplayNameFromPlugins(String propName, DBObjectProvider pro, DBObject obj) {
        for (Plugin p : this.m_plugins) {
            try {
                String displayName = p.getDisplayName(propName, pro, obj);
                if (!ModelUtil.hasLength((String)displayName)) continue;
                return displayName;
            }
            catch (Exception e) {
                DBLog.getLogger(PropertyDisplayRegistry.class).log(Level.WARNING, "Error calling property display plugin " + p.getClass().getName(), e);
            }
        }
        return null;
    }

    private final String getDisplayNameFromResourceBundle(String propName) {
        String displayName = null;
        for (ResourceBundle b : this.m_bundles) {
            try {
                displayName = b.getString(propName);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (!ModelUtil.hasLength((String)displayName)) continue;
            break;
        }
        return displayName;
    }

    public static final String getPropValueDisplay(String propName, Object value) {
        String retval = String.valueOf(value);
        try {
            String key = propName + "." + retval;
            retval = PropertyValueUI.get(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return retval;
    }

    public void registerBundle(ResourceBundle bundle) {
        Collection<ResourceBundle> bundles = this.m_bundles;
        if (!bundles.contains(bundle)) {
            bundles.add(bundle);
        }
    }

    public boolean unregisterBundle(ResourceBundle bundle) {
        if (bundle != PropertyUI.getBundle()) {
            return this.m_bundles.remove(bundle);
        }
        return false;
    }

    public void registerDisplayName(String propName, String displayName) {
        this.m_extrasPlugin.registerDisplayName(propName, displayName);
    }

    public void registerPlugin(Plugin plugin) {
        Collection<Plugin> plugins = this.m_plugins;
        if (!plugins.contains(plugin)) {
            plugins.add(plugin);
        }
    }

    public boolean unregisterPlugin(Plugin plugin) {
        return this.m_plugins.remove(plugin);
    }

    private static class ExtrasPlugin
    extends Plugin {
        private final Map<String, String> m_extras = new HashMap<String, String>();

        private ExtrasPlugin() {
        }

        @Override
        public String getDisplayName(String name, DBObjectProvider pro, DBObject obj) {
            return this.m_extras.get(name);
        }

        public void registerDisplayName(String propName, String displayName) {
            this.m_extras.put(propName, displayName);
        }
    }

    public static abstract class Plugin {
        public abstract String getDisplayName(String var1, DBObjectProvider var2, DBObject var3);
    }
}

