/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDispayRegistryEntry;
import oracle.ide.db.DefaultDBTypeRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.javatools.icons.OracleIcons;

public final class DBTypeDisplayRegistry {
    public static final String CONNECTIONS_TYPE = "Connections";
    private static List<DBTypeDispayRegistryEntry> s_registries = new ArrayList<DBTypeDispayRegistryEntry>();
    private static HashMap<String, Icon> s_generatedFolderIcons = new HashMap();

    private DBTypeDisplayRegistry() {
    }

    public static void addDBTypeRegistry(DBTypeDispayRegistryEntry registry) {
        s_registries.add(0, registry);
    }

    public static Icon getFolderIcon(String type) {
        Icon icon = s_generatedFolderIcons.get(type);
        if (icon != null) {
            return icon;
        }
        for (DBTypeDispayRegistryEntry reg : s_registries) {
            icon = reg.getFolderIcon(type);
            if (icon == null) continue;
            return icon;
        }
        if (DBTypeDisplayRegistry.getNodeIcon(type) != null) {
            icon = new FolderIcon(type);
            s_generatedFolderIcons.put(type, icon);
            return icon;
        }
        return null;
    }

    public static Icon getNodeIcon(String type) {
        DBTypeDispayRegistryEntry reg;
        Icon icon = null;
        Iterator<DBTypeDispayRegistryEntry> i$ = s_registries.iterator();
        while (i$.hasNext() && (icon = (reg = i$.next()).getNodeIcon(type)) == null) {
        }
        return icon;
    }

    public static String getDisplayName(String type) {
        DBTypeDispayRegistryEntry reg;
        String name = null;
        Iterator<DBTypeDispayRegistryEntry> i$ = s_registries.iterator();
        while (i$.hasNext() && ((name = (reg = i$.next()).getDisplayName(type)) == null || name.equals(type))) {
        }
        return name;
    }

    public static String getSingularDisplayName(String type) {
        DBTypeDispayRegistryEntry reg;
        String name = null;
        Iterator<DBTypeDispayRegistryEntry> i$ = s_registries.iterator();
        while (i$.hasNext() && ((name = (reg = i$.next()).getSingularDisplayName(type)) == null || name.equals(type))) {
        }
        return name;
    }

    public static String getNewMenuItemText(String type) {
        DBTypeDispayRegistryEntry reg;
        String text = null;
        Iterator<DBTypeDispayRegistryEntry> i$ = s_registries.iterator();
        while (i$.hasNext() && (text = (reg = i$.next()).getNewMenuItemText(type)) == null) {
        }
        if (text == null) {
            text = UIArb.format(91, DBTypeDisplayRegistry.getSingularDisplayName(type));
        }
        return text;
    }

    static {
        DBTypeDisplayRegistry.addDBTypeRegistry(new DefaultDBTypeRegistry());
    }

    public static class FolderIcon
    extends IconWithSmallOverlay {
        public FolderIcon(String type) {
            super(OracleIcons.getIcon((String)"folder.png"), DBTypeDisplayRegistry.getNodeIcon(type));
        }
    }
}

