/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.ide.db.UIArb;
import oracle.javatools.db.DBLog;
import oracle.javatools.icons.OracleIcons;

public abstract class DBTypeDispayRegistryEntry {
    private Map<String, TypeEntry> m_typeEntries;

    private static Logger getLogger() {
        return DBLog.getAndInitialiseLogger((String)"oracle.ide.db");
    }

    protected final TypeEntry getEntry(String type) {
        this.checkInit();
        return this.m_typeEntries.get(type);
    }

    public void registerType(String type, String displayName, String singularDisplayName, String newMenuText, Icon folderIcon, Icon nodeIcon) {
        this.m_typeEntries.put(type, new TypeEntry(displayName, singularDisplayName, newMenuText, folderIcon, nodeIcon));
    }

    public void registerType(String type, int displayNameKey, int singularDisplayNameKey, int newMenuTextKey, String nodeKey) {
        this.registerType(type, displayNameKey, singularDisplayNameKey, newMenuTextKey, null, nodeKey);
    }

    public void registerType(String type, int displayNameKey, int singularDisplayNameKey, int newMenuTextKey, String folderKey, String nodeKey) {
        this.m_typeEntries.put(type, new TypeEntry(displayNameKey, singularDisplayNameKey, newMenuTextKey, folderKey, nodeKey));
    }

    protected final void checkInit() {
        if (this.m_typeEntries == null) {
            this.m_typeEntries = new HashMap<String, TypeEntry>();
            this.populateEntries();
        }
    }

    protected abstract void populateEntries();

    public String getDisplayName(String type) {
        TypeEntry entry = this.getEntry(type);
        String retval = null;
        if (entry != null) {
            retval = entry.getDisplayName();
        }
        return retval == null ? type : retval;
    }

    public String getSingularDisplayName(String type) {
        TypeEntry entry = this.getEntry(type);
        String retval = null;
        if (entry != null) {
            retval = entry.getSingularDisplayName();
        }
        return retval == null ? type : retval;
    }

    public Icon getNodeIcon(String type) {
        TypeEntry entry = this.getEntry(type);
        return entry == null ? null : entry.getNodeIcon();
    }

    public Icon getFolderIcon(String type) {
        TypeEntry entry = this.getEntry(type);
        return entry == null ? null : entry.getFolderIcon();
    }

    public String getNewMenuItemText(String type) {
        TypeEntry entry = this.getEntry(type);
        return entry == null ? null : entry.getNewMenuItemText();
    }

    protected static class TypeEntry {
        private String m_displayName;
        private int m_displayNameKey = -1;
        private String m_singularDisplayName;
        private int m_singularDisplayNameKey = -1;
        private String m_newMenuText;
        private int m_newMenuTextKey = -1;
        private Icon m_folderIcon;
        private String m_folderIconKey;
        private Icon m_nodeIcon;
        private String m_nodeIconKey;

        protected TypeEntry(String displayName, String singularDisplayName, String newMenuText, Icon folderIcon, Icon nodeIcon) {
            this.m_displayName = displayName;
            this.m_singularDisplayName = singularDisplayName;
            this.m_folderIcon = folderIcon;
            this.m_nodeIcon = nodeIcon;
            this.m_newMenuText = newMenuText;
        }

        protected TypeEntry(int displayNameKey, int singularDisplayNameKey, int newMenuTextKey, String folderIconKey, String nodeIconKey) {
            this.m_displayNameKey = displayNameKey;
            this.m_singularDisplayNameKey = singularDisplayNameKey;
            this.m_folderIconKey = folderIconKey;
            this.m_nodeIconKey = nodeIconKey;
            this.m_newMenuTextKey = newMenuTextKey;
        }

        private void logKeyMissingException(Object key, String entry) {
        }

        private String getFromUIArb(int key, String defValue, String what) {
            if (key >= 0) {
                try {
                    return UIArb.getString(key);
                }
                catch (MissingResourceException mre) {
                    DBTypeDispayRegistryEntry.getLogger().log(Level.WARNING, "{0} key {1} not found in UI resource bundle.", new Object[]{what, key});
                }
            }
            return defValue;
        }

        public String getDisplayName() {
            return this.getFromUIArb(this.m_displayNameKey, this.m_displayName, "Display Name");
        }

        public String getSingularDisplayName() {
            return this.getFromUIArb(this.m_singularDisplayNameKey, this.m_singularDisplayName, "Singular Display Name");
        }

        public String getNewMenuItemText() {
            return this.getFromUIArb(this.m_newMenuTextKey, this.m_newMenuText, "New Menu Item Text");
        }

        private Icon getFromOracleIcons(String key, Icon defIcon, String what) {
            if (key != null) {
                try {
                    return OracleIcons.getIcon((String)key);
                }
                catch (OracleIcons.IconNotFoundException infe) {
                    DBTypeDispayRegistryEntry.getLogger().log(Level.WARNING, "{0} {1} not found in OracleIcons", new Object[]{what, key});
                }
            }
            return defIcon;
        }

        public Icon getFolderIcon() {
            return this.getFromOracleIcons(this.m_folderIconKey, this.m_folderIcon, "Folder Icon");
        }

        public Icon getNodeIcon() {
            return this.getFromOracleIcons(this.m_nodeIconKey, this.m_nodeIcon, "Node Icon");
        }
    }
}

