/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;

public class PointingBorder
extends AbstractBorder {
    private Point point;
    public static int PAD = 15;
    private static int i = 1;
    private static int j = 8;
    private static int a = 4;
    private static Insets INSETS = new Insets(i + a, j + a, i + a, i + a);
    private Color interiorColor = Color.WHITE;
    private Color lineColor = Color.BLACK;

    public PointingBorder(Color lineColor, Color interiorColor) {
        this.lineColor = lineColor;
        this.interiorColor = interiorColor;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath path = new GeneralPath();
        path.moveTo(x + j + a, y + i);
        path.lineTo(width - i - a, y + i);
        path.quadTo(width - i, y + i, width - i, y + a + i);
        path.lineTo(width - i, height - a - i);
        path.quadTo(width - i, height - i, width - i - a, height - i);
        path.lineTo(x + a + j, height - i);
        path.quadTo(x + j, height - i, x + j, height - a - i);
        if (this.point != null) {
            Point p = new Point(this.point);
            SwingUtilities.convertPointFromScreen(p, c);
            if (p.y <= height - PAD && p.y >= PAD) {
                path.lineTo(x + j, p.y + 6);
                path.lineTo(x + i, p.y);
                path.lineTo(x + j, p.y - 6);
            }
        }
        path.lineTo(x + j, y + a + i);
        path.quadTo(x + j, y + i, x + a + j, y + i);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(this.interiorColor);
        g2.fill(path);
        g2.setColor(this.lineColor);
        g2.draw(path);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = PointingBorder.INSETS.top;
        insets.left = PointingBorder.INSETS.left;
        insets.bottom = PointingBorder.INSETS.bottom;
        insets.right = PointingBorder.INSETS.right;
        return insets;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public Point getPoint() {
        return this.point;
    }
}

