/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.config.DTCache;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.AbstractLanguageSupport;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.OffsetDescriptionProvider;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.bookmarks.Bookmark;
import oracle.jdevimpl.bookmarks.BookmarkEvent;
import oracle.jdevimpl.bookmarks.BookmarkIcons;
import oracle.jdevimpl.bookmarks.BookmarkList;
import oracle.jdevimpl.bookmarks.BookmarkListener;
import oracle.jdevimpl.bookmarks.BookmarkOptions;
import oracle.jdevimpl.bookmarks.OpenBookmark;
import oracle.jdevimpl.bookmarks.OpenEditor;
import oracle.jdevimpl.bookmarks.resource.BookmarkArb;

final class BookmarkManager
implements EditorListener,
GutterColumnListener {
    private static final int VERY_BIG_LINE = 2000000000;
    private static final HighlightStyle bookmarkStyle;
    private static final String BOOKMARK_STYLE = "bookmark-style";
    private static final String BOOKMARK_COLUMN = "bookmark-column";
    private static final String BOOKMARKLIST_KEY = "ojb.BookmarkList";
    private BookmarkList bookmarkList = new BookmarkList();
    private List openEditorList = new ArrayList();
    private DocumentL documentL = new DocumentL();
    private Collection<BookmarkListener> listeners = new ArrayList<BookmarkListener>();
    private Map<Bookmark, Integer> bookmarkChangeIdMap = new HashMap<Bookmark, Integer>();

    BookmarkManager() {
        this.startup();
    }

    private void startup() {
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.addEditorListener((EditorListener)this);
        if (this.shouldRemoveBookmarksWhenShutdown()) {
            this.clearBookmarksFromStorage();
        } else {
            this.loadBookmarksFromStorage();
        }
    }

    void shutdown() {
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.removeEditorListener((EditorListener)this);
        if (this.shouldRemoveBookmarksWhenShutdown()) {
            this.clearBookmarksFromStorage();
        } else {
            this.saveBookmarksToStorage();
        }
    }

    void toggleBookmark(CodeEditor codeEditor) {
        int line = codeEditor.getCaretLine();
        this.toggleBookmark(codeEditor, line, -1);
    }

    void toggleBookmark(CodeEditor codeEditor, int line) {
        this.toggleBookmark(codeEditor, line, -1);
    }

    void toggleBookmark(CodeEditor codeEditor, int line, int number) {
        Bookmark bookmark;
        Bookmark numBookmark;
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return;
        }
        if (!(number == -1 || (numBookmark = this.bookmarkList.findNumberedBookmark(number)) == null || line == numBookmark.getLine() && url.equals(numBookmark.getURL()))) {
            this.removeBookmark(numBookmark);
        }
        if ((bookmark = this.bookmarkList.findBookmark(url, line)) == null) {
            this.createBookmarkFor(url, line, number);
        } else {
            this.removeBookmark(bookmark);
            if (number >= 0 && bookmark.getNumber() != number) {
                this.createBookmarkFor(url, line, number);
            }
        }
    }

    void changeBookmarkNumber(Bookmark bookmark, int newNumber) {
        if (newNumber != -1) {
            for (Bookmark existingBookmark : this.getAllBookmarks()) {
                if (existingBookmark.getNumber() != newNumber) continue;
                existingBookmark.setNumber(-1);
                this.updateBookmarkIcon(existingBookmark);
            }
        }
        bookmark.setNumber(newNumber);
        this.updateBookmarkIcon(bookmark);
    }

    private void updateBookmarkIcon(Bookmark bookmark) {
        for (OpenBookmark openBookmark : this.getOpenBookmarksFor(bookmark)) {
            Icon icon = BookmarkIcons.getIcon(bookmark.getNumber());
            openBookmark.guttermark.setIcon(icon);
        }
    }

    boolean hasBookmarks() {
        return this.bookmarkList.getBookmarkCount() != 0;
    }

    boolean hasBookmarks(CodeEditor codeEditor) {
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return false;
        }
        Bookmark bookmark = this.bookmarkList.getNextBookmark(url, 0, true);
        return bookmark != null;
    }

    Bookmark[] getAllBookmarks() {
        return this.bookmarkList.getAllBookmarks();
    }

    boolean canGotoNextBookmark(CodeEditor codeEditor) {
        return this.gotoNextBookmark(codeEditor, false);
    }

    void gotoNextBookmark(CodeEditor codeEditor) {
        this.gotoNextBookmark(codeEditor, true);
    }

    boolean gotoNextBookmark(CodeEditor codeEditor, boolean performGoto) {
        boolean thisURLOnly = this.shouldOnlyTraverseCurrent();
        boolean openEditorsOnly = this.shouldOnlyTraverseOpen();
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return false;
        }
        int line = codeEditor.getCaretLine();
        Bookmark nextBookmark = this.bookmarkList.getNextBookmark(url, line, thisURLOnly);
        if (openEditorsOnly) {
            URL nextURL;
            Bookmark sentinel = nextBookmark;
            while (nextBookmark != null && !this.hasOpenEditorsFor(nextURL = nextBookmark.getURL())) {
                int lineToUse = Math.max(nextBookmark.getLine() + 1, 2000000000);
                if ((nextBookmark = this.bookmarkList.getNextBookmark(nextURL, lineToUse, false)) != sentinel) continue;
                nextBookmark = null;
            }
        }
        if (nextBookmark != null) {
            if (performGoto) {
                this.gotoBookmark(nextBookmark);
            }
            return true;
        }
        return false;
    }

    boolean canGotoPreviousBookmark(CodeEditor codeEditor) {
        return this.gotoPreviousBookmark(codeEditor, false);
    }

    void gotoPreviousBookmark(CodeEditor codeEditor) {
        this.gotoPreviousBookmark(codeEditor, true);
    }

    boolean gotoPreviousBookmark(CodeEditor codeEditor, boolean performGoto) {
        boolean thisURLOnly = this.shouldOnlyTraverseCurrent();
        boolean openEditorsOnly = this.shouldOnlyTraverseOpen();
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return false;
        }
        int line = codeEditor.getCaretLine();
        Bookmark previousBookmark = this.bookmarkList.getPreviousBookmark(url, line, thisURLOnly);
        if (openEditorsOnly) {
            URL previousURL;
            Bookmark sentinel = previousBookmark;
            while (previousBookmark != null && !this.hasOpenEditorsFor(previousURL = previousBookmark.getURL())) {
                previousBookmark = this.bookmarkList.getPreviousBookmark(previousURL, 1, false);
                if (previousBookmark != sentinel) continue;
                previousBookmark = null;
            }
        }
        if (previousBookmark != null) {
            if (performGoto) {
                this.gotoBookmark(previousBookmark);
            }
            return true;
        }
        return false;
    }

    void gotoNumberedBookmark(int number) {
        Bookmark bookmark = this.bookmarkList.findNumberedBookmark(number);
        if (bookmark != null) {
            this.gotoBookmark(bookmark);
        }
    }

    void gotoBookmark(Bookmark bookmark) {
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        Project activeProject = Ide.getActiveProject();
        Context context = new Context(activeWorkspace, activeProject);
        URL url = bookmark.getURL();
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            context.setNode(node);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
            EditorManager editorManager = EditorManager.getEditorManager();
            Editor editor = editorManager.openEditor(openEditorOptions);
            if (editor instanceof CodeEditor) {
                NavigationManager mgr = NavigationManager.getNavigationManager();
                Context editorContext = editor.getContext();
                LineNavigationPoint point = new LineNavigationPoint(editorContext, bookmark.getLine(), 0, false);
                mgr.navigateTo((NavigationPoint)point);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void removeAllBookmarks() {
        Bookmark[] allBookmarks = this.getAllBookmarks();
        int numBookmarks = allBookmarks.length;
        for (int i = 0; i < numBookmarks; ++i) {
            this.removeBookmark(allBookmarks[i]);
        }
    }

    void removeAllBookmarks(CodeEditor codeEditor) {
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return;
        }
        Bookmark bookmark = this.bookmarkList.getNextBookmark(url, 0, true);
        while (bookmark != null) {
            this.removeBookmark(bookmark);
            bookmark = this.bookmarkList.getNextBookmark(url, 0, true);
        }
    }

    void removeBookmark(Bookmark bookmark) {
        this.bookmarkList.removeBookmark(bookmark);
        for (OpenBookmark openBookmark : this.getOpenBookmarksFor(bookmark)) {
            OpenEditor openEditor = this.getOpenEditorFor(openBookmark);
            if (openEditor == null) continue;
            openEditor.openBookmarkList.remove(openBookmark);
            openBookmark.guttermark.getGutterColumn().removeGutterMark(openBookmark.guttermark);
        }
        this.fireBookmarkEvent(new BookmarkEvent(BookmarkEvent.Type.REMOVAL, bookmark));
    }

    private void fireBookmarkEvent(BookmarkEvent event) {
        for (BookmarkListener l : this.listeners) {
            l.bookmarksChanged(event);
        }
    }

    private void clearBookmarksFromStorage() {
        BookmarkList emptyCopy = new BookmarkList();
        DTCache storage = Ide.getDTCache();
        storage.putData(BOOKMARKLIST_KEY, (Copyable)emptyCopy);
    }

    private void createBookmarkFor(URL url, int line, int number) {
        Bookmark bookmark = this.bookmarkList.addBookmark(url, line);
        bookmark.setNumber(number);
        OpenEditor[] openEditors = this.getOpenEditorsFor(url);
        int numEditors = openEditors.length;
        for (int i = 0; i < numEditors; ++i) {
            OpenEditor openEditor = openEditors[i];
            this.createGutterColumnFor(openEditor.editor);
            OpenBookmark openBookmark = this.createOpenBookmarkFor(openEditor.gutter, bookmark);
            openEditor.openBookmarkList.add(openBookmark);
        }
        if (openEditors.length > 0) {
            this.addDescription(bookmark, openEditors[0].editor, line);
        }
        this.fireBookmarkEvent(new BookmarkEvent(BookmarkEvent.Type.ADDITION, bookmark));
    }

    private void addDescription(Bookmark bookmark, CodeEditor editor, int line) {
        BasicDocument bDoc;
        LanguageSupport ls;
        Document doc = editor.getFocusedEditorPane().getDocument();
        if (doc instanceof BasicDocument && (ls = (bDoc = (BasicDocument)doc).getLanguageSupport()) instanceof AbstractLanguageSupport) {
            OffsetDescriptionProvider odp = ((AbstractLanguageSupport)ls).getOffsetDescriptionProvider();
            int offset = Math.max(bDoc.getLineStartOffset(line), bDoc.getLineEndOffset(line) - 1);
            if (odp != null) {
                bookmark.setDescription(odp.getDescription(bDoc.getTextBuffer(), offset));
            }
        }
    }

    private boolean isBookmarkOnOpenList(Bookmark bookmark) {
        URL url = bookmark.getURL();
        return this.hasOpenEditorsFor(url);
    }

    private void loadBookmarksFromStorage() {
        DTCache storage = Ide.getDTCache();
        BookmarkList storageCopy = (BookmarkList)storage.getData(BOOKMARKLIST_KEY);
        if (storageCopy != null) {
            storageCopy.copyTo(this.bookmarkList);
        }
    }

    private void saveBookmarksToStorage() {
        BookmarkList copyList = (BookmarkList)this.bookmarkList.copyTo(null);
        DTCache storage = Ide.getDTCache();
        storage.putData(BOOKMARKLIST_KEY, (Copyable)copyList);
    }

    private BookmarkOptions getBookmarkOptions() {
        return BookmarkOptions.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private boolean shouldOnlyTraverseCurrent() {
        int behavior = this.getBookmarkOptions().getTraverseBehavior();
        return behavior == 1;
    }

    private boolean shouldOnlyTraverseOpen() {
        int behavior = this.getBookmarkOptions().getTraverseBehavior();
        return behavior == 2;
    }

    private boolean shouldRemoveBookmarksWhenEditorClose() {
        return this.getBookmarkOptions().getDiscardOnClose();
    }

    private boolean shouldRemoveBookmarksWhenShutdown() {
        return this.getBookmarkOptions().getDiscardOnExit();
    }

    private boolean shouldRemoveBookmarkForNonExistentLine() {
        int behavior = this.getBookmarkOptions().getMissingLineBehavior();
        return behavior == 2;
    }

    private OpenBookmark getOpenBookmarkFor(GutterMark gutterMark) {
        CodeEditorGutter gutter = (CodeEditorGutter)gutterMark.getGutter();
        OpenEditor openEditor = this.getOpenEditorFor(gutter);
        List openBookmarkList = openEditor.openBookmarkList;
        int numBookmarks = openBookmarkList.size();
        for (int i = 0; i < numBookmarks; ++i) {
            OpenBookmark openBookmark = (OpenBookmark)openBookmarkList.get(i);
            if (openBookmark.guttermark != gutterMark) continue;
            return openBookmark;
        }
        return null;
    }

    private OpenEditor getOpenEditorFor(CodeEditorGutter gutter) {
        int numEditors = this.openEditorList.size();
        for (int i = 0; i < numEditors; ++i) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (openEditor.gutter != gutter) continue;
            return openEditor;
        }
        return null;
    }

    private OpenBookmark[] getOpenBookmarksFor(Bookmark bookmark) {
        ArrayList<OpenBookmark> matchingList = new ArrayList<OpenBookmark>();
        int numEditors = this.openEditorList.size();
        for (int i = 0; i < numEditors; ++i) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            OpenBookmark openBookmark = this.getOpenBookmarkFor(openEditor, bookmark);
            if (openBookmark == null) continue;
            matchingList.add(openBookmark);
        }
        int numMatches = matchingList.size();
        return matchingList.toArray(new OpenBookmark[numMatches]);
    }

    private OpenBookmark getOpenBookmarkFor(OpenEditor openEditor, Bookmark bookmark) {
        List openBookmarkList = openEditor.openBookmarkList;
        int numBookmarks = openBookmarkList.size();
        for (int i = 0; i < numBookmarks; ++i) {
            OpenBookmark openBookmark = (OpenBookmark)openBookmarkList.get(i);
            if (openBookmark.bookmark != bookmark) continue;
            return openBookmark;
        }
        return null;
    }

    private OpenEditor getOpenEditorFor(OpenBookmark openBookmark) {
        int numEditors = this.openEditorList.size();
        for (int i = 0; i < numEditors; ++i) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (!openEditor.openBookmarkList.contains(openBookmark)) continue;
            return openEditor;
        }
        return null;
    }

    private boolean hasOpenEditorsFor(URL url) {
        int numEditors = this.openEditorList.size();
        for (int i = 0; i < numEditors; ++i) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (!openEditor.url.equals(url)) continue;
            return true;
        }
        return false;
    }

    private OpenEditor[] getOpenEditorsFor(URL url) {
        ArrayList<OpenEditor> matchingList = new ArrayList<OpenEditor>();
        int numEditors = this.openEditorList.size();
        for (int i = 0; i < numEditors; ++i) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (!openEditor.url.equals(url)) continue;
            matchingList.add(openEditor);
        }
        int numMatches = matchingList.size();
        return matchingList.toArray(new OpenEditor[numMatches]);
    }

    private OpenEditor getOpenEditorFor(CodeEditor codeEditor) {
        int numEditors = this.openEditorList.size();
        for (int i = 0; i < numEditors; ++i) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (openEditor.editor != codeEditor) continue;
            return openEditor;
        }
        return null;
    }

    private URL getURLFor(CodeEditor codeEditor) {
        Node node;
        Context context;
        if (codeEditor != null && (context = codeEditor.getContext()) != null && (node = context.getNode()) != null) {
            return node.getURL();
        }
        return null;
    }

    private void updateBookmarks() {
        for (Bookmark mark : this.bookmarkList.getAllBookmarks()) {
            OpenEditor[] openEditors = this.getOpenEditorsFor(mark.getURL());
            if (openEditors.length <= 0) continue;
            CodeEditor ce = openEditors[0].editor;
            BasicDocument doc = (BasicDocument)ce.getFocusedEditorPane().getDocument();
            int id = doc.getTextBuffer().getChangeId();
            Integer prevId = this.bookmarkChangeIdMap.get(mark);
            if (prevId != null && id == prevId) continue;
            this.addDescription(mark, ce, mark.getLine());
            this.bookmarkChangeIdMap.put(mark, id);
            this.fireBookmarkEvent(new BookmarkEvent(BookmarkEvent.Type.UPDATE, mark));
        }
    }

    private Bookmark[] getNormalizedBookmarksFor(CodeEditor codeEditor, URL url) {
        ArrayList<Bookmark> validList = new ArrayList<Bookmark>();
        Bookmark[] bookmarks = this.bookmarkList.findBookmarks(url);
        int numBookmarks = bookmarks.length;
        int lineCount = codeEditor.getLineCount();
        for (int i = 0; i < numBookmarks; ++i) {
            boolean lineNotFound;
            Bookmark bookmark = bookmarks[i];
            boolean bl = lineNotFound = bookmark.getLine() > lineCount;
            if (lineNotFound) {
                boolean bookmarkMoved;
                if (this.isBookmarkOnOpenList(bookmark)) {
                    throw new IllegalStateException("bad line open elsewhere");
                }
                boolean shouldRemove = this.shouldRemoveBookmarkForNonExistentLine();
                if (!shouldRemove && !(bookmarkMoved = this.bookmarkList.modifyBookmark(bookmark, lineCount))) {
                    shouldRemove = true;
                }
                if (shouldRemove) {
                    this.bookmarkList.removeBookmark(bookmark);
                    this.fireBookmarkEvent(new BookmarkEvent(BookmarkEvent.Type.REMOVAL, bookmark));
                    bookmarks[i] = null;
                    continue;
                }
            }
            validList.add(bookmark);
        }
        int validBookmarks = validList.size();
        return validList.toArray(new Bookmark[validBookmarks]);
    }

    private void createGutterColumnFor(CodeEditor codeEditor) {
        CodeEditorGutter gutter = codeEditor.getGutter();
        if (gutter.lookupGutterColumn(BOOKMARK_COLUMN) == null) {
            gutter.createGutterColumn(BOOKMARK_COLUMN, this);
        }
    }

    private void removeGutterColumnFrom(CodeEditor codeEditor) {
        CodeEditorGutter gutter = codeEditor.getGutter();
        if (gutter == null) {
            return;
        }
        GutterColumn column = gutter.lookupGutterColumn(BOOKMARK_COLUMN);
        if (column != null) {
            gutter.removeGutterColumn(column);
        }
    }

    private OpenBookmark createOpenBookmarkFor(CodeEditorGutter gutter, Bookmark bookmark) {
        GutterColumn column = gutter.lookupGutterColumn(BOOKMARK_COLUMN);
        GutterMark gutterMark = column.addGutterMark(bookmark.getLine(), BookmarkIcons.getIcon(bookmark.getNumber()), bookmarkStyle, 2000, 5);
        OpenBookmark openBookmark = new OpenBookmark(bookmark, gutterMark);
        return openBookmark;
    }

    private OpenEditor createOpenEditorFor(CodeEditor codeEditor) {
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return null;
        }
        Bookmark[] bookmarks = this.getNormalizedBookmarksFor(codeEditor, url);
        int numBookmarks = bookmarks.length;
        CodeEditorGutter gutter = codeEditor.getGutter();
        ArrayList<OpenBookmark> openBookmarkList = new ArrayList<OpenBookmark>();
        if (numBookmarks > 0) {
            this.createGutterColumnFor(codeEditor);
            for (int i = 0; i < numBookmarks; ++i) {
                Bookmark bookmark = bookmarks[i];
                OpenBookmark openBookmark = this.createOpenBookmarkFor(gutter, bookmark);
                openBookmarkList.add(openBookmark);
            }
        }
        OpenEditor openEditor = new OpenEditor(codeEditor, url, gutter, openBookmarkList);
        return openEditor;
    }

    public void editorOpened(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)editor;
            OpenEditor openEditor = this.createOpenEditorFor(codeEditor);
            this.openEditorList.add(openEditor);
            codeEditor.getFocusedEditorPane().getDocument().addDocumentListener(this.documentL);
        }
    }

    public void editorClosed(Editor editor) {
        if (editor instanceof CodeEditor) {
            OpenEditor[] otherEditors;
            URL url;
            CodeEditor codeEditor = (CodeEditor)editor;
            if (codeEditor.getFocusedEditorPane() != null && codeEditor.getFocusedEditorPane().getDocument() != null) {
                codeEditor.getFocusedEditorPane().getDocument().removeDocumentListener(this.documentL);
            }
            OpenEditor openEditor = this.getOpenEditorFor(codeEditor);
            this.removeGutterColumnFrom(codeEditor);
            this.openEditorList.remove(openEditor);
            if (this.shouldRemoveBookmarksWhenEditorClose() && (url = this.getURLFor(codeEditor)) != null && (otherEditors = this.getOpenEditorsFor(url)).length == 0) {
                List openBookmarkList = openEditor.openBookmarkList;
                int numBookmarks = openBookmarkList.size();
                for (int i = 0; i < numBookmarks; ++i) {
                    OpenBookmark openBookmark = (OpenBookmark)openBookmarkList.get(i);
                    Bookmark bookmark = openBookmark.bookmark;
                    this.removeBookmark(bookmark);
                }
            }
        }
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
        Bookmark bookmark;
        boolean bookmarkMoved;
        OpenBookmark openBookmark = this.getOpenBookmarkFor(gutterMark);
        if (openBookmark != null && !(bookmarkMoved = this.bookmarkList.modifyBookmark(bookmark = openBookmark.bookmark, newLine))) {
            this.removeBookmark(bookmark);
        }
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
        OpenBookmark openBookmark = this.getOpenBookmarkFor(gutterMark);
        if (openBookmark != null) {
            Bookmark bookmark = openBookmark.bookmark;
            this.removeBookmark(bookmark);
        }
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
        this.markRemoved(gutterMark, clickedLine);
    }

    public String getMarkToolTip(GutterMark mark, MouseEvent event) {
        OpenBookmark openBookmark = this.getOpenBookmarkFor(mark);
        if (openBookmark != null) {
            Bookmark bookmark = openBookmark.bookmark;
            return BookmarkArb.format(1, Integer.toString(bookmark.getLine()));
        }
        return null;
    }

    public void addBookmarkListener(BookmarkListener bookmarkListener) {
        if (!this.listeners.contains(bookmarkListener)) {
            this.listeners.add(bookmarkListener);
        }
    }

    public void removeBookmarkListener(BookmarkListener bookmarkListener) {
        if (this.listeners.contains(bookmarkListener)) {
            this.listeners.remove(bookmarkListener);
        }
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        String translatedName = BookmarkArb.getString(0);
        bookmarkStyle = registry.createStyle(BOOKMARK_STYLE, translatedName, 20, Color.black, new Color(153, 255, 255));
        FileOverviewMargin.setMarkColor((String)BOOKMARK_COLUMN, (HighlightStyle)bookmarkStyle);
    }

    private class DocumentL
    implements DocumentListener,
    ActionListener {
        private Timer timer = new Timer(1000, this);

        private DocumentL() {
            this.timer.setRepeats(false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.scheduleUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.scheduleUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.scheduleUpdate();
        }

        private void scheduleUpdate() {
            this.timer.restart();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BookmarkManager.this.updateBookmarks();
        }
    }
}

