/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.controls.OverlayIcon;
import oracle.javatools.icons.OracleIcons;

public final class BookmarkIcons {
    private static Map<Integer, Icon> icons = new HashMap<Integer, Icon>();

    public static Icon getIcon(int number) {
        if (number < 0) {
            return OracleIcons.getIcon((String)"bookmark_gutter.png");
        }
        Icon icon = icons.get(number);
        if (icon == null) {
            icon = BookmarkIcons.createIcon(number);
        }
        return icon;
    }

    private static Icon createIcon(int number) {
        NumberIcon numIcon = new NumberIcon(number);
        OverlayIcon oIcon = new OverlayIcon(OracleIcons.getIcon((String)"bookmark_gutter.png"), (Icon)numIcon);
        icons.put(number, (Icon)oIcon);
        return oIcon;
    }

    private static class NumberIcon
    implements Icon {
        int number;
        Rectangle2D r;
        Font f;

        private NumberIcon(int number) {
            this.number = number;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.f == null) {
                this.f = new Font("Monospaced", 1, 9);
            }
            g2.setFont(this.f);
            if (this.r == null) {
                this.r = g2.getFontMetrics().getStringBounds("0", g2);
            }
            x = (int)((double)x + ((double)this.getIconWidth() - this.r.getWidth()) / 2.0);
            y = (int)((double)y + (this.r.getHeight() - 1.0));
            g2.setColor(Color.BLACK);
            g2.drawString(Integer.toString(this.number), x, y);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 14;
        }
    }
}

