/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.Component;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.jdevimpl.bookmarks.BookmarkManager;
import oracle.jdevimpl.bookmarks.BookmarkPanel;
import oracle.jdevimpl.bookmarks.resource.BookmarkArb;

public class BookmarkDockable
extends DockableWindow
implements ContextMenuListener {
    public static final String BOOKMARK_VIEW_ID = "BOOKMARK_VIEW_ID";
    private BookmarkPanel bookmarkPanel;

    public BookmarkDockable(BookmarkManager bookmarkManager) {
        super("BOOKMARKS_VIEW_TYPE.BOOKMARK_VIEW_ID");
        this.bookmarkPanel = new BookmarkPanel(bookmarkManager);
        this.getContextMenu().addContextMenuListener((ContextMenuListener)this);
    }

    public synchronized ContextMenu getContextMenu() {
        return this.bookmarkPanel.getContextMenu();
    }

    public String getTabName() {
        return BookmarkArb.getString(2);
    }

    public String getTitleName() {
        return BookmarkArb.getString(2);
    }

    public Component getGUI() {
        return this.bookmarkPanel;
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idedgotobookmark_html");
    }

    public void activate() {
        super.activate();
        this.bookmarkPanel.setActive(true);
    }

    public void deactivate() {
        super.deactivate();
        this.bookmarkPanel.setActive(false);
    }

    public Toolbar getToolbar() {
        return this.bookmarkPanel.getToolbar();
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.bookmarkPanel.menuWillShow(contextMenu);
    }

    public void menuWillHide(ContextMenu contextMenu) {
        this.bookmarkPanel.menuWillHide(contextMenu);
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

