/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.saveactions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.ceditor.saveactions.AddActionsDialog;
import oracle.ide.ceditor.saveactions.SaveActionsArb;
import oracle.ide.ceditor.saveactions.SaveActionsOptions;
import oracle.ide.controller.IdeAction;
import oracle.ide.nulls.NullIcon;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.ListStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.list.EmptyListTextLayer;
import oracle.javatools.util.StringUtil;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

public class SaveActionsOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JList list;
    private JButton downButton;
    private JButton upButton;
    private JButton addButton;
    private JButton removeButton;

    public SaveActionsOptionsPanel() {
        this.setHelpID("f1_idedidesetsaveactions_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    private static SaveActionsOptions getSaveOptions(TraversableContext tc) {
        return SaveActionsOptions.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.loadSettingsFrom(SaveActionsOptionsPanel.getSaveOptions(tc));
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this.saveSettingsTo(SaveActionsOptionsPanel.getSaveOptions(tc));
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        SaveActionsOptions options = SaveActionsOptionsPanel.getSaveOptions(tc);
        SaveActionsOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(SaveActionsOptions options) {
    }

    void loadSettingsFrom(SaveActionsOptions options) {
        ArrayList<IdeAction> actionList = new ArrayList<IdeAction>();
        ListStructure ls = options.getActionList();
        for (Object name : ls) {
            Integer id = Ide.findCmdID((String)((String)name));
            if (id == null) continue;
            IdeAction action = IdeAction.find((int)id);
            actionList.add(action);
        }
        ActionListModel model = new ActionListModel(actionList);
        this.list.setModel(model);
        this.enableButtons();
    }

    void saveSettingsTo(SaveActionsOptions options) throws TraversalException {
        options.setActionList(((ActionListModel)this.list.getModel()).getListStructure());
    }

    private void initializeComponent() {
        this.setLayout(new BorderLayout(0, 4));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        JLabel label = new JLabel(SaveActionsArb.getString(3));
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new ActionRenderer());
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SaveActionsOptionsPanel.this.enableButtons();
            }
        });
        JScrollPane sp = new JScrollPane(this.list);
        EmptyListTextLayer emptyTextLayer = new EmptyListTextLayer(this.list, SaveActionsArb.getString(8));
        emptyTextLayer.setFont(EmptyListTextLayer.LARGE_FONT);
        JXLayer layer = new JXLayer((Component)sp, (LayerUI)emptyTextLayer);
        JPanel upDownPanel = new JPanel();
        upDownPanel.setLayout(new BoxLayout(upDownPanel, 1));
        this.upButton = new JButton(OracleIcons.getIcon((String)"up.png"));
        this.upButton.setToolTipText(SaveActionsArb.getString(4));
        this.upButton.setMargin(new Insets(0, 2, 0, 2));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ActionListModel)SaveActionsOptionsPanel.this.list.getModel()).moveUp(SaveActionsOptionsPanel.this.list.getSelectedIndex());
            }
        });
        this.downButton = new JButton(OracleIcons.getIcon((String)"down.png"));
        this.downButton.setToolTipText(SaveActionsArb.getString(5));
        this.downButton.setMargin(new Insets(0, 2, 0, 2));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ActionListModel)SaveActionsOptionsPanel.this.list.getModel()).moveDown(SaveActionsOptionsPanel.this.list.getSelectedIndex());
            }
        });
        upDownPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 200));
        upDownPanel.add(Box.createGlue());
        upDownPanel.add(this.upButton);
        upDownPanel.add(Box.createVerticalStrut(5));
        upDownPanel.add(this.downButton);
        upDownPanel.add(Box.createGlue());
        JPanel addPanel = new JPanel();
        addPanel.setLayout(new BoxLayout(addPanel, 0));
        String addText = SaveActionsArb.getString(6);
        this.addButton = new JButton(StringUtils.stripMnemonic((String)addText));
        this.addButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)addText));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveActionsOptionsPanel.this.add();
            }
        });
        addPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        String downText = SaveActionsArb.getString(7);
        this.removeButton = new JButton(StringUtils.stripMnemonic((String)downText));
        this.removeButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)downText));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ActionListModel)SaveActionsOptionsPanel.this.list.getModel()).remove(SaveActionsOptionsPanel.this.list.getSelectedIndex());
            }
        });
        addPanel.add(this.addButton);
        addPanel.add(Box.createHorizontalStrut(5));
        addPanel.add(this.removeButton);
        addPanel.add(Box.createGlue());
        this.add(label, "North");
        this.add((Component)layer, "Center");
        this.add(upDownPanel, "After");
        this.add(addPanel, "South");
        this.enableButtons();
    }

    private void enableButtons() {
        this.removeButton.setEnabled(this.list.getSelectedIndex() > -1);
        this.upButton.setEnabled(this.list.getModel().getSize() > 1 && this.list.getSelectedIndex() > 0);
        this.downButton.setEnabled(this.list.getModel().getSize() > 1 && this.list.getSelectedIndex() < this.list.getModel().getSize() - 1 && this.list.getSelectedIndex() >= 0);
    }

    private void add() {
        ActionListModel model = (ActionListModel)this.list.getModel();
        AddActionsDialog addDialog = new AddActionsDialog(model.getActionList());
        if (addDialog.runDialog()) {
            for (IdeAction action : addDialog.getSelectedActions()) {
                if (model.contains(action)) continue;
                model.add(action);
            }
        }
        this.enableButtons();
    }

    static class ActionRenderer
    extends DefaultListCellRenderer {
        private static Icon NULL_ICON = new NullIcon();

        ActionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof IdeAction) {
                IdeAction action = (IdeAction)value;
                Icon icon = (Icon)action.getValue("SmallIcon");
                if (icon == null) {
                    icon = NULL_ICON;
                }
                c.setIcon(icon);
                String text = StringUtil.textWithoutMnemonic((Action)action);
                c.setText(text);
            }
            return c;
        }
    }

    private class ActionListModel
    extends AbstractListModel {
        private ArrayList<IdeAction> actionList;

        public ActionListModel(List<IdeAction> actionList) {
            this.actionList = new ArrayList<IdeAction>(actionList);
        }

        @Override
        public int getSize() {
            return this.actionList.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.actionList.get(index);
        }

        public boolean contains(Object obj) {
            return this.actionList.contains(obj);
        }

        public void moveUp(int index) {
            IdeAction action = this.actionList.remove(index);
            int i = Math.max(0, index - 1);
            this.actionList.add(i, action);
            this.fireContentsChanged(this, index, i);
            SaveActionsOptionsPanel.this.list.setSelectedIndex(i);
            SaveActionsOptionsPanel.this.enableButtons();
        }

        public void moveDown(int index) {
            IdeAction action = this.actionList.remove(index);
            int i = Math.min(this.actionList.size(), index + 1);
            this.actionList.add(i, action);
            this.fireContentsChanged(this, index, i);
            SaveActionsOptionsPanel.this.list.setSelectedIndex(i);
            SaveActionsOptionsPanel.this.enableButtons();
        }

        public void remove(int index) {
            this.actionList.remove(index);
            this.fireIntervalRemoved(this, index, index);
            if (SaveActionsOptionsPanel.this.list.getModel().getSize() > 0) {
                SaveActionsOptionsPanel.this.list.setSelectedIndex(Math.min(index, SaveActionsOptionsPanel.this.list.getModel().getSize() - 1));
            }
            SaveActionsOptionsPanel.this.enableButtons();
        }

        public void add(IdeAction action) {
            this.actionList.add(action);
            this.fireIntervalAdded(this, this.actionList.size() - 1, this.actionList.size() - 1);
            SaveActionsOptionsPanel.this.list.setSelectedIndex(this.actionList.size() - 1);
            SaveActionsOptionsPanel.this.enableButtons();
        }

        public ListStructure getListStructure() {
            ListStructure ls = ListStructure.newInstance();
            for (IdeAction action : this.actionList) {
                String name = Ide.findCmdName((int)action.getCommandId());
                if (name == null) continue;
                ls.add((Object)name);
            }
            return ls;
        }

        public List<IdeAction> getActionList() {
            return this.actionList;
        }
    }
}

