/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.ceditor.options.FontManager;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.ceditor.options.PrintingOptions;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.print.EditorPageable;
import oracle.javatools.editor.print.PrintOptions;

public final class PrintingOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener,
DocumentListener,
ItemListener {
    private JComboBox combobox_fontFamily;
    private JComboBox combobox_fontSize;
    private JCheckBox checkbox_lineNumbers;
    private JCheckBox checkbox_pageNumbers;
    private JCheckBox checkbox_fileHeader;
    private JCheckBox checkbox_wrapLines;
    private JTextField textfield_wrapSymbol;
    private JCheckBox checkbox_printColors;
    private JCheckBox checkbox_printStyles;
    private Previewer previewer;

    public PrintingOptionsPanel() {
        this.setHelpID("f1_idedidesetprinting_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        PrintingOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        PrintingOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private PrintingOptions findOptions(TraversableContext tc) {
        PrintingOptions options = PrintingOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        PrintingOptions options = this.findOptions(tc);
        PrintingOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(PrintingOptions options) {
    }

    void loadSettingsFrom(PrintingOptions options) {
        boolean lineNumbers = options.getPrintLineNumbers() == 1;
        boolean pageNumbers = options.getPrintPageNumbers();
        boolean fileHeader = options.getPrintFileHeader();
        boolean printColors = options.getPrintColors();
        boolean printStyles = options.getPrintFontStyles();
        boolean wrapLines = options.getWrapBehavior() == 1;
        String wrapSymbol = options.getWrapSymbol().trim();
        String fontFamily = options.getFontFamily();
        int fontSize = options.getFontSize();
        this.checkbox_lineNumbers.setSelected(lineNumbers);
        this.checkbox_pageNumbers.setSelected(pageNumbers);
        this.checkbox_fileHeader.setSelected(fileHeader);
        this.checkbox_printColors.setSelected(printColors);
        this.checkbox_printStyles.setSelected(printStyles);
        this.checkbox_wrapLines.setSelected(wrapLines);
        this.textfield_wrapSymbol.setText(wrapSymbol);
        this.setSelectedFontFamily(fontFamily);
        this.setSelectedFontSize(fontSize);
    }

    private void setSelectedFontFamily(String fontFamily) {
        ComboBoxModel model = this.combobox_fontFamily.getModel();
        int numItems = model.getSize();
        for (int i = 0; i < numItems; ++i) {
            Object element = model.getElementAt(i);
            if (!element.equals(fontFamily)) continue;
            this.combobox_fontFamily.setSelectedItem(fontFamily);
        }
    }

    private void setSelectedFontSize(int fontSize) {
        ComboBoxModel model = this.combobox_fontSize.getModel();
        int numItems = model.getSize();
        for (int i = 0; i < numItems; ++i) {
            Integer size = (Integer)model.getElementAt(i);
            if (size != fontSize) continue;
            this.combobox_fontSize.setSelectedItem(size);
        }
    }

    void saveSettingsTo(PrintingOptions options) throws TraversalException {
        int lineNumbers = this.checkbox_lineNumbers.isSelected() ? 1 : 0;
        boolean pageNumbers = this.checkbox_pageNumbers.isSelected();
        boolean fileHeader = this.checkbox_fileHeader.isSelected();
        boolean printColors = this.checkbox_printColors.isSelected();
        boolean printStyles = this.checkbox_printStyles.isSelected();
        int wrapLines = this.checkbox_wrapLines.isSelected() ? 1 : 0;
        String wrapSymbol = this.textfield_wrapSymbol.getText().trim();
        String fontFamily = (String)this.combobox_fontFamily.getSelectedItem();
        Integer size = (Integer)this.combobox_fontSize.getSelectedItem();
        int fontSize = size;
        options.setPrintLineNumbers(lineNumbers);
        options.setPrintPageNumbers(pageNumbers);
        options.setPrintFileHeader(fileHeader);
        options.setPrintColors(printColors);
        options.setPrintFontStyles(printStyles);
        options.setWrapBehavior(wrapLines);
        options.setWrapSymbol(wrapSymbol);
        options.setFontFamily(fontFamily);
        options.setFontSize(fontSize);
    }

    private void initializeComponent() {
        String fontFamilyText = OptionsArb.getString(169);
        JLabel label_fontFamily = new JLabel();
        FontManager fontManager = FontManager.getInstance();
        Object[] families = fontManager.getAllFontFamilies();
        NonNullableComboBoxModel fontModel = new NonNullableComboBoxModel(families);
        this.combobox_fontFamily = new JComboBox(fontModel);
        this.combobox_fontFamily.setEditable(false);
        this.combobox_fontFamily.setSelectedItem("DialogInput");
        this.combobox_fontFamily.addItemListener(this);
        ResourceUtils.resLabel((JLabel)label_fontFamily, (Component)this.combobox_fontFamily, (String)fontFamilyText);
        String fontSizeText = OptionsArb.getString(170);
        JLabel label_fontSize = new JLabel();
        Object[] sizes = new Integer[]{new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20), new Integer(21), new Integer(22), new Integer(23), new Integer(24)};
        NonNullableComboBoxModel sizeModel = new NonNullableComboBoxModel(sizes);
        this.combobox_fontSize = new JComboBox(sizeModel);
        this.combobox_fontSize.setEditable(false);
        this.combobox_fontSize.setSelectedItem(sizes[0]);
        this.combobox_fontSize.addItemListener(this);
        ResourceUtils.resLabel((JLabel)label_fontSize, (Component)this.combobox_fontSize, (String)fontSizeText);
        String lineNumbersText = OptionsArb.getString(171);
        this.checkbox_lineNumbers = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_lineNumbers, (String)lineNumbersText);
        this.checkbox_lineNumbers.addItemListener(this);
        String pageNumbersText = OptionsArb.getString(172);
        this.checkbox_pageNumbers = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_pageNumbers, (String)pageNumbersText);
        this.checkbox_pageNumbers.addItemListener(this);
        String fileHeaderText = OptionsArb.getString(173);
        this.checkbox_fileHeader = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_fileHeader, (String)fileHeaderText);
        this.checkbox_fileHeader.addItemListener(this);
        String wrapLinesText = OptionsArb.getString(174);
        this.checkbox_wrapLines = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_wrapLines, (String)wrapLinesText);
        this.checkbox_wrapLines.addItemListener(this);
        String wrapSymbolText = OptionsArb.getString(175);
        JLabel label_wrapSymbol = new JLabel();
        this.textfield_wrapSymbol = new JTextField(4);
        ResourceUtils.resLabel((JLabel)label_wrapSymbol, (Component)this.textfield_wrapSymbol, (String)wrapSymbolText);
        Document document = this.textfield_wrapSymbol.getDocument();
        document.addDocumentListener(this);
        Component[] dependents = new Component[]{this.textfield_wrapSymbol, label_wrapSymbol};
        ItemSelectableTracker tracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_wrapLines, dependents);
        String printColorsText = OptionsArb.getString(176);
        this.checkbox_printColors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_printColors, (String)printColorsText);
        this.checkbox_printColors.addItemListener(this);
        String printStylesText = OptionsArb.getString(177);
        this.checkbox_printStyles = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_printStyles, (String)printStylesText);
        this.checkbox_printStyles.addItemListener(this);
        String previewText = OptionsArb.getString(178);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(previewText);
        JPanel panel_preview = new JPanel(new BorderLayout());
        panel_preview.setBorder(titledBorder);
        this.previewer = new Previewer();
        panel_preview.add((Component)this.previewer, "Center");
        Insets comboInsets = new Insets(5, 2, 5, 2);
        Insets defaultInsets = new Insets(2, 2, 2, 2);
        Insets indentedInsets = new Insets(2, 30, 2, 2);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        JPanel panel_font = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, comboInsets, 0, 0);
        panel_font.add((Component)label_fontFamily, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, comboInsets, 0, 0);
        panel_font.add((Component)this.combobox_fontFamily, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, comboInsets, 0, 0);
        panel_font.add((Component)label_fontSize, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, comboInsets, 0, 0);
        panel_font.add((Component)this.combobox_fontSize, constraints);
        constraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        panel_font.add(Box.createGlue(), constraints);
        JPanel panel_numbers = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_numbers.add((Component)this.checkbox_lineNumbers, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_numbers.add((Component)this.checkbox_pageNumbers, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_numbers.add((Component)this.checkbox_fileHeader, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        panel_numbers.add(Box.createGlue(), constraints);
        JPanel panel_wrap = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_wrap.add((Component)this.checkbox_wrapLines, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_wrap.add((Component)label_wrapSymbol, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, indentedInsets, 0, 0);
        panel_wrap.add((Component)this.textfield_wrapSymbol, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        panel_wrap.add(Box.createGlue(), constraints);
        JPanel panel_styles = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_styles.add((Component)this.checkbox_printColors, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_styles.add((Component)this.checkbox_printStyles, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        panel_styles.add(Box.createGlue(), constraints);
        constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_font, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createHorizontalStrut(8), constraints);
        constraints = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_styles, constraints);
        constraints = new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createVerticalStrut(2), constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_wrap, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createHorizontalStrut(8), constraints);
        constraints = new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_numbers, constraints);
        constraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_preview, constraints);
    }

    private void repaintPreview() {
        try {
            PrintingOptions options = new PrintingOptions();
            this.saveSettingsTo(options);
            this.previewer.setPrintOptions(options);
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.repaintPreview();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.repaintPreview();
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        this.repaintPreview();
    }

    private static final class Previewer
    extends JComponent {
        private PrintingOptions options = null;
        private EditorPageable pageable;
        private static final int OUTER_INSETS = 5;
        private static final int INNER_INSETS = 4;

        private Previewer() {
            String javaType = "java";
            LanguageModule javaModule = LanguageModule.getModuleForFileType((String)"java");
            String javaSample = javaModule.getContentSample();
            TextBuffer buffer = TextBufferFactory.createTextBuffer();
            buffer.append(javaSample.toCharArray());
            String filename = "PrintingPreview.java";
            BasicDocument document = new BasicDocument(filename, buffer);
            this.options = new PrintingOptions();
            this.pageable = new EditorPageable(filename, document, (PrintOptions)this.options, new PageFormat());
        }

        private void setPrintOptions(PrintingOptions printingOptions) {
            this.options = printingOptions;
            this.options.setFontSize(this.options.getFontSize() + 1);
            this.repaint();
        }

        @Override
        public void paint(Graphics graphics) {
            int x = 5;
            int y = 5;
            int width = this.getWidth() - 10;
            int height = this.getHeight() - 10;
            graphics.setColor(Color.white);
            graphics.fillRect(x, y, width, height);
            graphics.setColor(Color.black);
            graphics.drawRect(x, y, width, height);
            Paper paper = new Paper();
            paper.setImageableArea(x += 4, y += 4, width -= 8, height -= 8);
            PageFormat format = new PageFormat();
            format.setPaper(paper);
            this.pageable.setPageFormat(format);
            this.pageable.setPrintOptions((PrintOptions)this.options);
            this.pageable.repaginate();
            try {
                graphics.clipRect(x, y, width, height);
                this.pageable.print(graphics, format, 0);
            }
            catch (PrinterException e) {
                // empty catch block
            }
        }
    }
}

