/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.ide.ceditor.options.FontManager;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.ceditor.options.PrintingHTMLOptions;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public final class PrintingHTMLOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_useFontInfo;
    private JComboBox combobox_fontFamily;
    private JComboBox combobox_fontSize;
    private JCheckBox checkbox_anchors;
    private JCheckBox checkbox_lineNumbers;
    private JCheckBox checkbox_fileHeader;
    private JCheckBox checkbox_timeStamp;
    private JCheckBox checkbox_wrapLines;
    private WholeNumberField textfield_wrapColumn;
    private JTextField textfield_wrapSymbol;
    private JCheckBox checkbox_printColors;
    private JCheckBox checkbox_printStyles;

    public PrintingHTMLOptionsPanel() {
        this.setHelpID("f1_idedidesetprintinghtml_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        PrintingHTMLOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        PrintingHTMLOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private PrintingHTMLOptions findOptions(TraversableContext tc) {
        PrintingHTMLOptions options = PrintingHTMLOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        PrintingHTMLOptions options = this.findOptions(tc);
        PrintingHTMLOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(PrintingHTMLOptions options) {
    }

    void loadSettingsFrom(PrintingHTMLOptions options) {
        boolean anchors = options.getUseAnchors();
        boolean lineNumbers = options.getPrintLineNumbers() == 1;
        boolean fileHeader = options.getPrintFileHeader();
        boolean timeStamp = options.getPrintTimeStamp();
        boolean printColors = options.getPrintColors();
        boolean printStyles = options.getPrintFontStyles();
        boolean wrapLines = options.getWrapBehavior() == 1;
        int wrapColumn = options.getWrapColumn();
        String wrapSymbol = options.getWrapSymbol().trim();
        boolean useFontInfo = options.getUseFontInfo();
        String fontFamily = options.getFontFamily();
        int fontSize = options.getFontSize();
        this.checkbox_anchors.setSelected(anchors);
        this.checkbox_lineNumbers.setSelected(lineNumbers);
        this.checkbox_fileHeader.setSelected(fileHeader);
        this.checkbox_timeStamp.setSelected(timeStamp);
        this.checkbox_printColors.setSelected(printColors);
        this.checkbox_printStyles.setSelected(printStyles);
        this.checkbox_wrapLines.setSelected(wrapLines);
        this.textfield_wrapColumn.setValue(wrapColumn);
        this.textfield_wrapSymbol.setText(wrapSymbol);
        this.checkbox_useFontInfo.setSelected(useFontInfo);
        this.setSelectedFontFamily(fontFamily);
        this.setSelectedFontSize(fontSize);
    }

    private void setSelectedFontFamily(String fontFamily) {
        ComboBoxModel model = this.combobox_fontFamily.getModel();
        int numItems = model.getSize();
        for (int i = 0; i < numItems; ++i) {
            Object element = model.getElementAt(i);
            if (!element.equals(fontFamily)) continue;
            this.combobox_fontFamily.setSelectedItem(fontFamily);
        }
    }

    private void setSelectedFontSize(int fontSize) {
        ComboBoxModel model = this.combobox_fontSize.getModel();
        int numItems = model.getSize();
        for (int i = 0; i < numItems; ++i) {
            Integer size = (Integer)model.getElementAt(i);
            if (size != fontSize) continue;
            this.combobox_fontSize.setSelectedItem(size);
        }
    }

    void saveSettingsTo(PrintingHTMLOptions options) throws TraversalException {
        int wrapColumn;
        try {
            wrapColumn = this.textfield_wrapColumn.getValue();
        }
        catch (NullPointerException e) {
            wrapColumn = -1;
        }
        if (wrapColumn < 10) {
            String wrapColumnError = OptionsArb.getString(190);
            String wrapColumnTitle = OptionsArb.getString(191);
            this.showErrorDialog(wrapColumnError, wrapColumnTitle);
            this.textfield_wrapColumn.selectAll();
            this.textfield_wrapColumn.requestFocus();
            throw new TraversalException(null);
        }
        boolean anchors = this.checkbox_anchors.isSelected();
        int lineNumbers = this.checkbox_lineNumbers.isSelected() ? 1 : 0;
        boolean fileHeader = this.checkbox_fileHeader.isSelected();
        boolean timeStamp = this.checkbox_timeStamp.isSelected();
        boolean printColors = this.checkbox_printColors.isSelected();
        boolean printStyles = this.checkbox_printStyles.isSelected();
        int wrapLines = this.checkbox_wrapLines.isSelected() ? 1 : 0;
        String wrapSymbol = this.textfield_wrapSymbol.getText().trim();
        String fontFamily = (String)this.combobox_fontFamily.getSelectedItem();
        boolean useFontInfo = this.checkbox_useFontInfo.isSelected();
        Integer size = (Integer)this.combobox_fontSize.getSelectedItem();
        int fontSize = size;
        options.setUseAnchors(anchors);
        options.setPrintLineNumbers(lineNumbers);
        options.setPrintFileHeader(fileHeader);
        options.setPrintTimeStamp(timeStamp);
        options.setPrintColors(printColors);
        options.setPrintFontStyles(printStyles);
        options.setWrapBehavior(wrapLines);
        options.setWrapColumn(wrapColumn);
        options.setWrapSymbol(wrapSymbol);
        options.setUseFontInfo(useFontInfo);
        options.setFontFamily(fontFamily);
        options.setFontSize(fontSize);
    }

    private void initializeComponent() {
        String fontInfoText = OptionsArb.getString(181);
        this.checkbox_useFontInfo = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_useFontInfo, (String)fontInfoText);
        String fontFamilyText = OptionsArb.getString(182);
        JLabel label_fontFamily = new JLabel();
        FontManager fontManager = FontManager.getInstance();
        Object[] families = fontManager.getAllFontFamilies();
        NonNullableComboBoxModel fontModel = new NonNullableComboBoxModel(families);
        this.combobox_fontFamily = new JComboBox(fontModel);
        this.combobox_fontFamily.setEditable(false);
        this.combobox_fontFamily.setSelectedItem("DialogInput");
        ResourceUtils.resLabel((JLabel)label_fontFamily, (Component)this.combobox_fontFamily, (String)fontFamilyText);
        String fontSizeText = OptionsArb.getString(183);
        JLabel label_fontSize = new JLabel();
        Object[] sizes = new Integer[]{new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20), new Integer(21), new Integer(22), new Integer(23), new Integer(24)};
        NonNullableComboBoxModel sizeModel = new NonNullableComboBoxModel(sizes);
        this.combobox_fontSize = new JComboBox(sizeModel);
        this.combobox_fontSize.setEditable(false);
        this.combobox_fontSize.setSelectedItem(sizes[0]);
        ResourceUtils.resLabel((JLabel)label_fontSize, (Component)this.combobox_fontSize, (String)fontSizeText);
        Component[] dependents = new Component[]{label_fontFamily, this.combobox_fontFamily, label_fontSize, this.combobox_fontSize};
        ItemSelectableTracker tracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_useFontInfo, dependents);
        String anchorsText = OptionsArb.getString(184);
        this.checkbox_anchors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_anchors, (String)anchorsText);
        String lineNumbersText = OptionsArb.getString(185);
        this.checkbox_lineNumbers = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_lineNumbers, (String)lineNumbersText);
        String fileHeaderText = OptionsArb.getString(186);
        this.checkbox_fileHeader = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_fileHeader, (String)fileHeaderText);
        String timeStampText = OptionsArb.getString(187);
        this.checkbox_timeStamp = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_timeStamp, (String)timeStampText);
        dependents = new Component[]{this.checkbox_timeStamp};
        tracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_fileHeader, dependents);
        String wrapLinesText = OptionsArb.getString(188);
        this.checkbox_wrapLines = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_wrapLines, (String)wrapLinesText);
        String wrapColumnText = OptionsArb.getString(189);
        JLabel label_wrapColumn = new JLabel();
        this.textfield_wrapColumn = new WholeNumberField(80, 4);
        ResourceUtils.resLabel((JLabel)label_wrapColumn, (Component)this.textfield_wrapColumn, (String)wrapColumnText);
        String wrapSymbolText = OptionsArb.getString(192);
        JLabel label_wrapSymbol = new JLabel();
        this.textfield_wrapSymbol = new JTextField(4);
        ResourceUtils.resLabel((JLabel)label_wrapSymbol, (Component)this.textfield_wrapSymbol, (String)wrapSymbolText);
        dependents = new Component[]{this.textfield_wrapColumn, label_wrapColumn, this.textfield_wrapSymbol, label_wrapSymbol};
        tracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_wrapLines, dependents);
        String printColorsText = OptionsArb.getString(193);
        this.checkbox_printColors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_printColors, (String)printColorsText);
        String printStylesText = OptionsArb.getString(194);
        this.checkbox_printStyles = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_printStyles, (String)printStylesText);
        String previewText = OptionsArb.getString(195);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(previewText);
        JPanel panel_preview = new JPanel(new BorderLayout());
        panel_preview.setBorder(titledBorder);
        Insets defaultInsets = new Insets(2, 2, 2, 2);
        Insets indentedInsets = new Insets(2, 30, 2, 2);
        Insets comboInsets = defaultInsets;
        Insets indentedComboInsets = indentedInsets;
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        JPanel panel_font = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_font.add((Component)this.checkbox_useFontInfo, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, indentedComboInsets, 0, 0);
        panel_font.add((Component)label_fontFamily, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, comboInsets, 0, 0);
        panel_font.add((Component)this.combobox_fontFamily, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, indentedComboInsets, 0, 0);
        panel_font.add((Component)label_fontSize, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, comboInsets, 0, 0);
        panel_font.add((Component)this.combobox_fontSize, constraints);
        JPanel panel_numbers = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_numbers.add((Component)this.checkbox_anchors, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_numbers.add((Component)this.checkbox_lineNumbers, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_numbers.add((Component)this.checkbox_fileHeader, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_numbers.add((Component)this.checkbox_timeStamp, constraints);
        JPanel panel_wrap = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_wrap.add((Component)this.checkbox_wrapLines, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_wrap.add((Component)label_wrapColumn, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_wrap.add((Component)this.textfield_wrapColumn, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_wrap.add((Component)label_wrapSymbol, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_wrap.add((Component)this.textfield_wrapSymbol, constraints);
        JPanel panel_styles = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_styles.add((Component)this.checkbox_printColors, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_styles.add((Component)this.checkbox_printStyles, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        panel_styles.add(Box.createGlue(), constraints);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_font, constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_styles, constraints);
        constraints = new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_numbers, constraints);
        constraints = new GridBagConstraints(0, 11, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_wrap, constraints);
        constraints = new GridBagConstraints(0, 15, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
    }

    private void showErrorDialog(String message, String title) {
        JOptionPane.showMessageDialog((Component)((Object)this), message, title, 2);
    }
}

