/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.ide.IdeConstants;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;

public final class GutterOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkBox_showLineNumbers;
    private JRadioButton button_useLnF;
    private JRadioButton button_useEditor;
    private JRadioButton button_useCustom;
    private CustomColorChoice colorChoice_gutterBgColor;
    private CustomColorChoice colorChoice_gutterFgColor;
    private JCheckBox checkbox_clickDragging;

    public GutterOptionsPanel() {
        this.setHelpID("f1_idedidesetlinegutter_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        DisplayOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        DisplayOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private DisplayOptions findOptions(TraversableContext tc) {
        DisplayOptions options = DisplayOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        DisplayOptions options = this.findOptions(tc);
        GutterOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(DisplayOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        boolean showLineNumbers = options.getShowLineNumbers();
        properties.putBooleanProperty("show-line-numbers", showLineNumbers);
        int gutterColorSource = options.getGutterColorSource();
        properties.putIntegerProperty("gutter-color-source", gutterColorSource);
        int gutterBgColorRGB = options.getGutterBackgroundColor();
        properties.putProperty("gutter-custom-bgcolor", (Object)new Color(gutterBgColorRGB));
        int gutterFgColorRGB = options.getGutterForegroundColor();
        properties.putProperty("gutter-custom-fgcolor", (Object)new Color(gutterFgColorRGB));
        boolean enableClickDragging = options.getEnableClickDragging();
        properties.putBooleanProperty("gutter-enable-selection", enableClickDragging);
        Color defaultBorder = IdeConstants.COLOR_IDE_LINES;
        if (defaultBorder != null) {
            properties.putProperty("gutter-default-bordercolor", (Object)defaultBorder);
        }
    }

    void loadSettingsFrom(DisplayOptions options) {
        JRadioButton buttonToCheck;
        boolean showLineNumbers = options.getShowLineNumbers();
        int gutterColorSource = options.getGutterColorSource();
        int gutterBgColorRGB = options.getGutterBackgroundColor();
        int gutterFgColorRGB = options.getGutterForegroundColor();
        boolean enableClickDragging = options.getEnableClickDragging();
        this.checkBox_showLineNumbers.setSelected(showLineNumbers);
        this.checkbox_clickDragging.setSelected(enableClickDragging);
        switch (gutterColorSource) {
            case 3: {
                buttonToCheck = this.button_useCustom;
                break;
            }
            case 2: {
                buttonToCheck = this.button_useEditor;
                break;
            }
            default: {
                buttonToCheck = this.button_useLnF;
            }
        }
        buttonToCheck.setSelected(true);
        this.colorChoice_gutterBgColor.setClosestSelectedColor(new Color(gutterBgColorRGB));
        this.colorChoice_gutterFgColor.setClosestSelectedColor(new Color(gutterFgColorRGB));
    }

    void saveSettingsTo(DisplayOptions options) {
        int gutterColorSource = 1;
        if (this.button_useEditor.isSelected()) {
            gutterColorSource = 2;
        } else if (this.button_useCustom.isSelected()) {
            gutterColorSource = 3;
        }
        boolean showLineNumbers = this.checkBox_showLineNumbers.isSelected();
        Color gutterBgColor = this.colorChoice_gutterBgColor.getSelectedColor();
        Color gutterFgColor = this.colorChoice_gutterFgColor.getSelectedColor();
        boolean enableClickDragging = this.checkbox_clickDragging.isSelected();
        options.setShowLineNumbers(showLineNumbers);
        options.setGutterColorSource(gutterColorSource);
        options.setGutterBackgroundColor(gutterBgColor.getRGB());
        options.setGutterForegroundColor(gutterFgColor.getRGB());
        options.setEnableClickDragging(enableClickDragging);
    }

    private void initializeComponent() {
        String showLineNumbersText = OptionsArb.getString(36);
        this.checkBox_showLineNumbers = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_showLineNumbers, (String)showLineNumbersText);
        String clickDraggingText = OptionsArb.getString(43);
        this.checkbox_clickDragging = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_clickDragging, (String)clickDraggingText);
        String gutterGroupText = OptionsArb.getString(37);
        JLabel label_gutterGroup = new JLabel(gutterGroupText);
        String useLnFText = OptionsArb.getString(38);
        this.button_useLnF = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.button_useLnF, (String)useLnFText);
        String useEditorText = OptionsArb.getString(39);
        this.button_useEditor = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.button_useEditor, (String)useEditorText);
        String useCustomText = OptionsArb.getString(40);
        this.button_useCustom = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.button_useCustom, (String)useCustomText);
        ButtonGroup group_gutterColors = new ButtonGroup();
        group_gutterColors.add(this.button_useLnF);
        group_gutterColors.add(this.button_useEditor);
        group_gutterColors.add(this.button_useCustom);
        String gutterBgText = OptionsArb.getString(41);
        JLabel label_gutterBg = new JLabel();
        this.colorChoice_gutterBgColor = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)label_gutterBg, (Component)this.colorChoice_gutterBgColor, (String)gutterBgText);
        String gutterFgText = OptionsArb.getString(42);
        JLabel label_gutterFg = new JLabel();
        this.colorChoice_gutterFgColor = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)label_gutterFg, (Component)this.colorChoice_gutterFgColor, (String)gutterFgText);
        Component[] dependents = new Component[]{label_gutterBg, this.colorChoice_gutterBgColor, label_gutterFg, this.colorChoice_gutterFgColor};
        ItemSelectableTracker tracker = new ItemSelectableTracker((ItemSelectable)this.button_useCustom, dependents);
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets indentedInsets = new Insets(2, 30, 2, 5);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_showLineNumbers, constraints);
        constraints = new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_clickDragging, constraints);
        constraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(label_gutterGroup, constraints);
        constraints = new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.button_useLnF, constraints);
        constraints = new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.button_useEditor, constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.button_useCustom, constraints);
        constraints = new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(label_gutterBg, constraints);
        constraints = new GridBagConstraints(2, 6, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add((Component)this.colorChoice_gutterBgColor, constraints);
        constraints = new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(label_gutterFg, constraints);
        constraints = new GridBagConstraints(2, 7, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add((Component)this.colorChoice_gutterFgColor, constraints);
        constraints = new GridBagConstraints(0, 8, 3, 1, 1.0, 1.0, 17, 1, defaultInsets, 0, 0);
        this.add(Box.createVerticalGlue(), constraints);
    }
}

