/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.insight;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.ceditor.htmlpopup.ContentProvider;
import oracle.ide.ceditor.htmlpopup.HtmlPopup;
import oracle.ide.ceditor.htmlpopup.HtmlPopupView;
import oracle.ide.ceditor.htmlpopup.PopupEventListener;
import oracle.ide.ceditor.htmlpopup.StaticContentProvider;
import oracle.ide.ceditor.insight.InsightBundle;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;

public abstract class AbstractDocPopupController
implements CodeMenuConstants,
ContextMenuListener,
Controller,
DynamicMenuListener {
    private boolean _cmdInitialized;
    private Class<? extends TextNode> _nodeClass;
    private String _labelWithMnemonic;
    private JComponent[] _dynamicItems;
    public static final String SHOW_DOC_POPUP_CMD = "AbstractDocPopupController.SHOW_DOC_POPUP_CMD";
    public static final int SHOW_DOC_POPUP_CMD_ID = Ide.findOrCreateCmdID((String)"AbstractDocPopupController.SHOW_DOC_POPUP_CMD");
    private static IdeAction _showDocAction;
    private static JMenuItem _showDocPopupMenuItem;
    private static Map<String, String> _nodeClassNameToLabelMap;

    public AbstractDocPopupController(Class<? extends TextNode> nodeClass, String labelWithMnemonic) {
        this._nodeClass = nodeClass;
        this._labelWithMnemonic = labelWithMnemonic;
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = editorManager.getContextMenu();
        if (contextMenu != null) {
            contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        _nodeClassNameToLabelMap.put(this._nodeClass.getName(), this._labelWithMnemonic);
        IdeAction action = AbstractDocPopupController._getShowDocAction();
        action.addController((Controller)this);
        KeyStrokeContextRegistry ksr = Ide.getKeyStrokeContextRegistry();
        ksr.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/ide/ceditor/insight/accelerators.xml");
        this._initializeDynamicActions();
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
    }

    public void shutdown() {
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = editorManager.getContextMenu();
        if (contextMenu != null) {
            contextMenu.removeContextMenuListener((ContextMenuListener)this);
        }
        _showDocPopupMenuItem = null;
        Ide.getMainWindow().removeDynamicMenuListener((DynamicMenuListener)this);
    }

    protected abstract boolean isEnabled(Context var1);

    protected abstract ContentProvider getContentProvider(Context var1) throws Exception;

    public boolean update(IdeAction action, Context context) {
        int cmdID = action.getCommandId();
        if (cmdID == SHOW_DOC_POPUP_CMD_ID) {
            boolean enable = false;
            if (context.getProject() != null) {
                View view = context.getView();
                Node node = context.getNode();
                if (view instanceof CodeEditor && this._nodeClass.isInstance(node)) {
                    enable = !this._cmdInitialized ? true : this.isEnabled(context);
                    action.setEnabled(enable);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(IdeAction action, Context context) {
        View view;
        int cmdID = action.getCommandId();
        if (cmdID == SHOW_DOC_POPUP_CMD_ID && context.getProject() != null && (view = context.getView()) instanceof CodeEditor && this._nodeClass.isInstance(context.getNode())) {
            CodeEditor codeEditor = (CodeEditor)view;
            BasicEditorPane editorPane = codeEditor.getFocusedEditorPane();
            WaitCursor cursor = Ide.getWaitCursor();
            if (!this._cmdInitialized) {
                this._cmdInitialized = true;
            }
            try {
                HtmlPopupView htmlPopupView;
                cursor.show();
                ContentProvider contentProvider = this.getContentProvider(context);
                if (contentProvider == null) {
                    String message = InsightBundle.get("POPUP_MSG_NO_DOC");
                    contentProvider = new StaticContentProvider(message);
                }
                if ((htmlPopupView = HtmlPopup.invokePopup(editorPane, contentProvider)) != null) {
                    Listener listener = new Listener(editorPane, htmlPopupView);
                    editorPane.addCaretListener((CaretListener)listener);
                    htmlPopupView.addPopupEventListener(listener);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                cursor.hide();
            }
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context;
        Context context2 = context = popup != null ? popup.getContext() : null;
        if (this._nodeClass.isInstance(context.getNode()) && context.getView() instanceof CodeEditor) {
            popup.add((Component)_showDocPopupMenuItem, SECTION_SOURCE_CTXT_MENU);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public JComponent[] gatherDynamicActions(Context context) {
        if (context.getView() instanceof CodeEditor && this._nodeClass.isInstance(context.getNode())) {
            return this._dynamicItems;
        }
        return new JComponent[0];
    }

    private static IdeAction _getShowDocAction() {
        if (_showDocAction == null) {
            String res = InsightBundle.get("SHOW_DOC_POPUP_MENU_LABEL");
            String menuLabel = StringUtils.stripMnemonic((String)res);
            _showDocAction = IdeAction.get((int)SHOW_DOC_POPUP_CMD_ID, (String)AddinManager.getAddinManager().getCommand(SHOW_DOC_POPUP_CMD_ID, null), (String)menuLabel, (String)CATEGORY_CODE_MENU, (Integer)StringUtils.getMnemonicIndex((String)res), null, null, (boolean)true);
            _showDocAction.putValue("editor-pseudo-name", (Object)"show-doc-popup");
            if (_showDocAction.getLabelUpdater() == null) {
                _showDocAction.setLabelUpdater((LabelUpdater)new ShowDocActionLabelUpdater());
            }
            _showDocPopupMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)_showDocAction, 140.0f);
        }
        return _showDocAction;
    }

    private void _initializeDynamicActions() {
        Menubar ideMenuManager = Ide.getMenubar();
        IdeAction showDocCommentsAction = IdeAction.find((int)SHOW_DOC_POPUP_CMD_ID);
        JMenuItem showDocCommentsItem = ideMenuManager.createMenuItem((ToggleAction)showDocCommentsAction, 140.0f);
        showDocCommentsItem.putClientProperty("menu-section-id", new Float(1.0f));
        this._dynamicItems = new JComponent[]{showDocCommentsItem};
    }

    static {
        _nodeClassNameToLabelMap = new HashMap<String, String>();
    }

    private static class ShowDocActionLabelUpdater
    implements LabelUpdater {
        private ShowDocActionLabelUpdater() {
        }

        public String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
            Node node;
            if (context != null && (node = context.getNode()) != null) {
                String label = (String)_nodeClassNameToLabelMap.get(node.getClass().getName());
                if (label != null) {
                    return label;
                }
                Set entries = _nodeClassNameToLabelMap.entrySet();
                for (Map.Entry entry : entries) {
                    try {
                        Class<?> clazz = AbstractDocPopupController.class.getClassLoader().loadClass((String)entry.getKey());
                        if (!clazz.isInstance(node)) continue;
                        return (String)entry.getValue();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
            return originalLabel;
        }

        public String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
            return this.labelWhenEnabled(context, action, originalLabel);
        }

        public void setEnabledFormat(String format) {
        }

        public void setDisabledFormat(String format) {
        }
    }

    private static class Listener
    implements CaretListener,
    PopupEventListener {
        private BasicEditorPane _editorPane;
        private HtmlPopupView _htmlPopupView;

        private Listener(BasicEditorPane editorPane, HtmlPopupView htmlPopupView) {
            this._editorPane = editorPane;
            this._htmlPopupView = htmlPopupView;
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            HtmlPopup.cancelPopup(this._editorPane);
        }

        @Override
        public void popupCanceled() {
        }

        @Override
        public void contentsChanged() {
        }

        @Override
        public void popupClosed() {
            this._editorPane.removeCaretListener((CaretListener)this);
            this._htmlPopupView.removePopupEventListener(this);
        }
    }
}

