/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Toolkit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.find.FindArb;
import oracle.ide.ceditor.find.FindDialog;
import oracle.ide.ceditor.find.FindNavigator;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.ceditor.find.GotoLineDialog;
import oracle.ide.ceditor.find.ISearchDialog;
import oracle.ide.ceditor.find.IncrementalSearch;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.model.Node;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.vcs.VCSManager;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.util.Copyable;

public final class FindController
implements Controller {
    private static FindController INSTANCE;
    static final String PLUGIN_PROPERTY = "*find_plugin*";
    private static IdeAction ideSearchAgainAction;
    private static IdeAction ideSearchBackwardAction;
    private static final int FIND_NEXT_AT_CURSOR_CMD_ID;
    private static final int FIND_PREVIOUS_AT_CURSOR_CMD_ID;
    private FindDialog finder;
    private GotoLineDialog gotoLiner;
    private ISearchDialog iSearcher;

    private FindController() {
        ideSearchAgainAction = IdeActions.getSearchFindNextAction();
        ideSearchBackwardAction = IdeActions.getSearchFindPreviousAction();
        String findNextAtCursorName = FindArb.getString(31);
        IdeAction findNextAtCursorAction = IdeAction.get((int)FIND_NEXT_AT_CURSOR_CMD_ID, null, (String)findNextAtCursorName, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, null, (ArrayResourceBundle)FindArb.getInstance(), (int)32, null, (boolean)false);
        findNextAtCursorAction.addController((Controller)this);
        String findPreviousAtCursorName = FindArb.getString(33);
        IdeAction findPreviousAtCursorAction = IdeAction.get((int)FIND_PREVIOUS_AT_CURSOR_CMD_ID, null, (String)findPreviousAtCursorName, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, null, (ArrayResourceBundle)FindArb.getInstance(), (int)34, null, (boolean)false);
        findPreviousAtCursorAction.addController((Controller)this);
        ideSearchAgainAction.addController((Controller)this);
        ideSearchBackwardAction.addController((Controller)this);
        IdeActions.getSearchFindAction().addController((Controller)this);
        IdeActions.getSearchReplaceAction().addController((Controller)this);
        IdeActions.getNavigateGoToLineAction().addController((Controller)this);
        IdeActions.getSearchIncrementalFindForwardAction().addController((Controller)this);
        IdeActions.getSearchIncrementalFindBackwardAction().addController((Controller)this);
        FindNavigator.createFindNavigator();
        this.finder = new FindDialog();
        this.iSearcher = new ISearchDialog(this);
        this.gotoLiner = new GotoLineDialog();
        FindOptions findOptions = FindOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        Ide.getSettings().putLegacyData("FindOptions", (Copyable)findOptions);
    }

    static void createController() {
        INSTANCE = new FindController();
    }

    static FindController getInstance() {
        return INSTANCE;
    }

    void dispose() {
        IdeAction.find((int)23).removeController((Controller)this);
        ideSearchAgainAction.removeController((Controller)this);
        ideSearchBackwardAction.removeController((Controller)this);
        IdeAction.find((int)24).removeController((Controller)this);
        IdeAction.find((int)29).removeController((Controller)this);
        IdeAction.find((int)26).removeController((Controller)this);
        IdeAction.find((int)27).removeController((Controller)this);
        this.finder = null;
        this.gotoLiner = null;
        this.iSearcher = null;
    }

    void updateSearchText(String text) {
        if (this.finder != null) {
            this.finder.setSearchText(text);
            ideSearchAgainAction.updateAction();
            ideSearchBackwardAction.updateAction();
        }
    }

    String getSearchText() {
        String ret = null;
        if (this.finder != null) {
            ret = this.finder.getSearchText();
        }
        return ret;
    }

    private static BasicEditorPane getBasicEditorPane(Context context) {
        View view;
        BasicEditorPane ret = null;
        if (context != null && (view = context.getView()) instanceof FindableEditor) {
            FindableEditor findableEditor = (FindableEditor)view;
            ret = findableEditor.getFocusedEditorPane();
        }
        return ret;
    }

    public boolean update(IdeAction action, Context context) {
        boolean canHandle;
        BasicEditorPane editorPane = FindController.getBasicEditorPane(context);
        int cmdId = action.getCommandId();
        if (editorPane == null) {
            return false;
        }
        boolean isEditable = editorPane.isEditable();
        FindNavigator findNavigator = FindNavigator.getFindNavigator();
        if (cmdId == 23) {
            canHandle = this.finder.canPerformFind(1, FindController.getFindOptions());
        } else if (cmdId == 25) {
            canHandle = findNavigator.isSearchHighlightMode() ? findNavigator.hasHighlights(editorPane) : this.finder.canPerformFind(2, FindController.getFindOptions());
        } else if (cmdId == 53) {
            canHandle = findNavigator.isSearchHighlightMode() ? findNavigator.hasHighlights(editorPane) : this.finder.canPerformFind(4, FindController.getFindOptions());
        } else if (cmdId == 24) {
            canHandle = (isEditable || this.isNodeVersioned(context)) && this.finder.canPerformFind(3, FindController.getFindOptions());
        } else if (cmdId == FIND_NEXT_AT_CURSOR_CMD_ID) {
            canHandle = this.finder.canPerformFind(5, FindController.getFindOptions());
        } else if (cmdId == FIND_PREVIOUS_AT_CURSOR_CMD_ID) {
            canHandle = this.finder.canPerformFind(6, FindController.getFindOptions());
        } else if (cmdId == 29) {
            canHandle = this.gotoLiner.canPerformGotoLine(context);
        } else if (cmdId == 26) {
            canHandle = this.iSearcher.canPerformISearchForward(context);
        } else if (cmdId == 27) {
            canHandle = this.iSearcher.canPerformISearchBackward(context);
        } else {
            return false;
        }
        action.setEnabled(canHandle);
        return true;
    }

    private boolean isNodeVersioned(Context context) {
        Node node = context.getNode();
        return node != null && node.getURL() != null && VCSManager.getVCSManager().isVersioned(node.getURL());
    }

    public boolean handleEvent(IdeAction action, Context context) {
        BasicEditorPane editorPane = FindController.getBasicEditorPane(context);
        if (editorPane == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        FindNavigator findNavigator = FindNavigator.getFindNavigator();
        if (cmdId == 23) {
            if (!IncrementalSearch.activateSearch(editorPane)) {
                this.invokeFindDialog(context, FindController.getFindOptions());
            }
        } else if (cmdId == 25) {
            String iString = IncrementalSearch.getIncrementalSearchString(editorPane);
            if (iString.length() > 0) {
                this.updateSearchText(iString);
            }
            if (findNavigator.isSearchHighlightMode()) {
                findNavigator.searchForward(editorPane);
            } else {
                this.finder.performFind(2, context, FindController.getFindOptions());
            }
        } else if (cmdId == 53) {
            String iString = IncrementalSearch.getIncrementalSearchString(editorPane);
            if (iString.length() > 0) {
                this.updateSearchText(iString);
            }
            if (findNavigator.isSearchHighlightMode()) {
                findNavigator.searchBackward(editorPane);
            } else {
                this.finder.performFind(4, context, FindController.getFindOptions());
            }
        } else if (cmdId == 24) {
            if (editorPane.isEditable() || this.isNodeVersioned(context)) {
                this.finder.performFind(3, context, FindController.getFindOptions());
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (cmdId == FIND_NEXT_AT_CURSOR_CMD_ID) {
            this.finder.performFind(5, context, FindController.getFindOptions());
            findNavigator.setSearchHighlightMode(false);
        } else if (cmdId == FIND_PREVIOUS_AT_CURSOR_CMD_ID) {
            this.finder.performFind(6, context, FindController.getFindOptions());
            findNavigator.setSearchHighlightMode(false);
        } else if (cmdId == 29) {
            this.gotoLiner.performGotoLine(context);
        } else if (cmdId == 26) {
            this.finder.performCancelHighlighting(editorPane);
            this.iSearcher.performISearchForward(context);
        } else if (cmdId == 27) {
            this.finder.performCancelHighlighting(editorPane);
            this.iSearcher.performISearchBackward(context);
        } else {
            return false;
        }
        return true;
    }

    void invokeFindDialog(Context context, FindOptions findOptions) {
        if (this.finder.canPerformFind(1, findOptions)) {
            FindNavigator findNavigator = FindNavigator.getFindNavigator();
            this.finder.performFind(1, context, findOptions);
            findNavigator.setSearchHighlightMode(false);
        }
    }

    static FindOptions getFindOptions() {
        FindOptions ret = FindOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        return ret;
    }

    static FindHighlightPlugin getFindHighlightPlugin(BasicEditorPane editor) {
        FindHighlightPlugin plugin = (FindHighlightPlugin)editor.getProperty(PLUGIN_PROPERTY);
        if (plugin == null) {
            plugin = new FindHighlightPlugin();
            editor.installPlugin((EditorPlugin)plugin);
            editor.putProperty(PLUGIN_PROPERTY, (Object)plugin);
        }
        return plugin;
    }

    static {
        FIND_NEXT_AT_CURSOR_CMD_ID = Ide.findOrCreateCmdID((String)"FindNextAtCursorCommand");
        FIND_PREVIOUS_AT_CURSOR_CMD_ID = Ide.findOrCreateCmdID((String)"FindPreviousAtCursorCommand");
    }
}

