/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.TextBufferTracker;
import oracle.ide.model.TextNode;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class CodeNavigationPoint
extends DefaultNavigationPoint {
    protected int start;
    protected int selLength;
    protected int change;
    protected TextBufferTracker tracker;
    protected Class preferredType = CodeEditor.class;
    protected boolean explicit;

    public CodeNavigationPoint() {
    }

    protected CodeNavigationPoint(Context context, int start, int length) {
        this();
        this.setContext(context);
        this.start = start >= 0 ? start : 0;
        this.selLength = length >= 0 ? length : 0;
    }

    public void setContext(Context context) {
        Node node;
        super.setContext(context);
        Node node2 = node = context != null ? context.getNode() : null;
        if (node instanceof TextNode) {
            this.tracker = TextBufferTracker.getTracker((TextNode)((TextNode)node));
            this.change = this.tracker != null ? this.tracker.getVersion() : 0;
        } else {
            this.tracker = null;
            this.change = 0;
        }
    }

    public Object copyTo(Object target) {
        CodeNavigationPoint point = target != null ? (CodeNavigationPoint)((Object)target) : new CodeNavigationPoint();
        this.copyToImpl(point);
        return point;
    }

    protected final void copyToImpl(CodeNavigationPoint point) {
        super.copyToImpl((DefaultNavigationPoint)point);
        point.tracker = this.tracker;
        point.start = this.start;
        point.selLength = this.selLength;
        point.change = this.change;
        point.preferredType = this.preferredType;
        point.explicit = this.explicit;
    }

    public void refresh() {
        Editor editor;
        EditorInfo info = CodeNavigationPoint.findEditorInfo((String)this.viewID, (URL)this.nodeURL);
        Editor editor2 = editor = info != null ? info._getEditor() : null;
        if (editor instanceof FindableEditor) {
            try {
                BasicEditorPane pane = ((FindableEditor)editor).getFocusedEditorPane();
                this.change = this.tracker != null ? this.tracker.getVersion() : this.change;
                this.start = pane.getSelectionStart();
                this.selLength = pane.getSelectionEnd() - pane.getSelectionStart();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    protected int renavigate() throws Exception {
        Editor editor = this.findOrCreateEditor(true);
        if (editor == null) {
            return 1;
        }
        if (editor instanceof FindableEditor && this.start >= 0) {
            int[] values = new int[]{this.start, this.selLength};
            if (this.tracker != null) {
                this.tracker.adjustOffsetLength(this.start, this.selLength, this.change, values);
            }
            CodeNavigationPoint.gotoOffset((FindableEditor)editor, values[0], values[1]);
        }
        return 0;
    }

    public Class getPreferredEditorType() {
        return this.preferredType;
    }

    public void setPreferredEditorType(Class cls) {
        this.preferredType = cls;
    }

    protected Editor findOrCreateEditor(boolean activate) {
        EditorManager mgr;
        Editor editor;
        EditorInfo info = CodeNavigationPoint.findEditorInfo((String)this.viewID, (URL)this.nodeURL);
        Editor editor2 = editor = info != null ? info._getEditor() : null;
        if (editor == null) {
            EditorManager mgr2 = EditorManager.getEditorManager();
            if (mgr2 == null) {
                return null;
            }
            Class cls = this.getPreferredEditorType();
            editor = cls == null ? mgr2.openDefaultEditorInFrame(this.getContext()) : mgr2.openEditorInFrame(cls, this.getContext());
            if (editor != null) {
                mgr2.setExplicit(editor, this.explicit);
                this.viewClass = editor.getClass();
                this.viewID = editor.getId();
            }
        } else if (activate && (mgr = EditorManager.getEditorManager()) != null) {
            mgr.activateEditor(info);
        }
        return editor;
    }

    protected static void gotoOffset(FindableEditor editor, int offset, int range) {
        int endOffset;
        BasicEditorPane pane = editor.getFocusedEditorPane();
        BasicDocument document = (BasicDocument)pane.getDocument();
        int documentLength = document.getLength();
        int startOffset = Math.max(0, Math.min(offset, documentLength));
        if (startOffset != (endOffset = Math.max(startOffset, Math.min(startOffset + range, documentLength)))) {
            pane.setCaretPositionCenter(startOffset);
            pane.moveCaretPositionCenter(endOffset);
        } else {
            pane.setCaretPositionCenter(startOffset);
        }
    }
}

