/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web.content;

import java.io.IOException;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.HttpResources;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.WebException;
import oracle.dbtools.rt.web.content.ContentInfo;
import oracle.dbtools.rt.web.content.ContentRules;

@Service
public class StaticContentHandler
implements RequestDispatcher {
    @Reference
    private ContentRules contentRules;

    @Override
    public RequestDispatcher.Score canDispatch(RequestEntity request) {
        ContentInfo content;
        String path = request.path();
        if (!StaticContentHandler.hasQueryString(path) && (content = this.contentRules.match(LocalePreference.preference(request), path)) != null) {
            return new RequestDispatcher.Score(1, content.security().realm(), content);
        }
        return RequestHandler.NO_MATCH;
    }

    private static boolean hasQueryString(String path) {
        return path.indexOf(63) != -1;
    }

    @Override
    public HttpResource dispatch(RequestDispatcher.Score score, RequestEntity request) throws IOException {
        if (score == null) {
            score = this.canDispatch(request);
        }
        if (score.score() < 0) {
            throw WebException.notFound();
        }
        ContentInfo content = (ContentInfo)score.handle();
        this.authorize(request, content);
        return HttpResources.resource(content.uri());
    }

    private void authorize(RequestEntity request, ContentInfo content) {
        RequestHandler.SecurityConfig security = content.security();
        request.verifySecurityConstraint(security.constraint(), security.logonRedirect());
    }
}

