/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web.content;

import oracle.dbtools.rt.web.RequestHandler;

class ContentRule {
    private final boolean ignore;
    private final String pattern;
    private final RequestHandler.SecurityConfig security;
    private static final String WILDCARD = "*";

    ContentRule(String pattern, boolean ignore, RequestHandler.SecurityConfig security) {
        this.pattern = pattern;
        this.ignore = ignore;
        this.security = security;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentRule other = (ContentRule)obj;
        if (this.ignore != other.ignore) {
            return false;
        }
        if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
            return false;
        }
        return !(this.security == null ? other.security != null : !this.security.equals(other.security));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ignore ? 1231 : 1237);
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ContentRule [pattern=");
        builder.append(this.pattern);
        builder.append(", ignore=");
        builder.append(this.ignore);
        builder.append(", security=");
        builder.append(this.security);
        builder.append("]");
        return builder.toString();
    }

    boolean ignore() {
        return this.ignore;
    }

    boolean matches(String path) {
        if (this.pattern.endsWith(WILDCARD)) {
            String prefix = this.pattern.substring(0, this.pattern.length() - 1);
            return path.startsWith(prefix);
        }
        return this.pattern.equals(path);
    }

    RequestHandler.SecurityConfig security() {
        return this.security;
    }
}

