/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import oracle.dbtools.apex.Connections;
import oracle.dbtools.apex.Version;
import oracle.dbtools.apex.cache.CacheManager;
import oracle.dbtools.apex.hooks.ProcessorRegistry;
import oracle.dbtools.apex.security.Security;
import oracle.dbtools.common.config.ConfigurationsProvider;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.config.file.ConfigurationFolder;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.web.DispatchLog;
import oracle.dbtools.rt.web.ForceSecure;
import oracle.dbtools.rt.web.ServletContexts;

public class SCListener
implements ServletContextListener {
    private boolean initialized = false;
    private static final Log LOG = Log.get(SCListener.class);

    public void contextDestroyed(ServletContextEvent evt) {
        if (this.initialized) {
            ForceSecure.teardown();
            DispatchLog.teardown();
            ServiceLocator.teardown();
            ConfigurationsProvider.INSTANCE.teardown();
            ConfigurationFolder.INSTANCE.teardown();
        }
    }

    public synchronized void contextInitialized(ServletContextEvent evt) {
        if (!this.initialized) {
            this.initialized = true;
            ServletContext ctx = evt.getServletContext();
            try {
                ConfigurationFolder.INSTANCE.setup(ServletContexts.getContextPath(ctx), ctx.getInitParameter("config.dir"));
                ConfigurationsProvider.INSTANCE.setup();
                ServiceLocator.setup((ClassLoader)this.getClass().getClassLoader());
                Connections.setup();
                CacheManager.setup();
                Security.setup();
                DispatchLog.setup();
                ForceSecure.setup();
                String exts = GlobalConfiguration.globalConfiguration().get("apex.extensions");
                if (exts != null) {
                    ProcessorRegistry.register((String[])Text.commaDelimited((String)exts));
                }
                String version = ctx.getInitParameter("version");
                String serverInfo = ctx.getServerInfo();
                Version.INSTANCE.setup(version, serverInfo);
                StringBuilder msg = new StringBuilder();
                msg.append("Oracle Application Express Listener initialized\n");
                msg.append("Application Express Listener version : ");
                msg.append(version);
                msg.append("\n");
                msg.append("Application Express Listener server info: ");
                msg.append(serverInfo);
                msg.append("\n");
                if (LOG.isLoggable(Log.INFO)) {
                    LOG.info(msg.toString());
                } else {
                    LOG.console(msg.toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

