/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import oracle.dbtools.apex.Connections;
import oracle.dbtools.apex.ErrorResponse;
import oracle.dbtools.apex.ErrorResponses;
import oracle.dbtools.apex.ModApex;
import oracle.dbtools.apex.Version;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.web.BaseAndPath;
import oracle.dbtools.rt.web.DispatchLog;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.RequestDispatchers;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestFilter;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebErrorResponse;
import oracle.dbtools.rt.web.WebErrorResponses;
import oracle.dbtools.rt.web.WebException;

public class HttpEndpointBase
extends HttpServlet {
    private final ModApex defaultServlet = new ModApex();
    private static final Log LOG = Log.get(HttpEndpointBase.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void init() throws ServletException {
        Connections.isPoolReady();
    }

    public URI serverUri(HttpServletRequest request) {
        int port = request.getServerPort();
        if (this.isStandardPort(request)) {
            port = -1;
        }
        try {
            return new URI(request.getScheme(), null, request.getServerName(), port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw URIs.illegalUri((URISyntaxException)e);
        }
    }

    /*
     * Exception decompiling
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RequestEntity applyFilters(RequestEntity req) {
        for (RequestFilter filter : ServiceLocator.acquireAll(RequestFilter.class, (String[])new String[0])) {
            RequestEntity mutated;
            if (DispatchLog.isEnabled()) {
                DispatchLog.log("Applying filter: " + filter.getClass().getName() + " to the request");
            }
            if ((mutated = (RequestEntity)filter.apply(req)) == null) continue;
            req = mutated;
        }
        return req;
    }

    private void checkForTrailingSlashOnContextPath(HttpServletRequest request) {
        String absolutePath = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (contextPath.equals(absolutePath)) {
            if (DispatchLog.isEnabled()) {
                DispatchLog.log("missing trailing slash, redirecting to: " + contextPath + "/");
            }
            throw RedirectException.permanentRedirect(contextPath + "/");
        }
    }

    private void defaultServlet(HttpServletRequest request, RequestEntity req, HttpServletResponse response, WebErrorResponse errors) throws ServletException, IOException {
        JDBCPrincipal jdbcPrincipal = (JDBCPrincipal)req.principal().principal(JDBCPrincipal.class);
        if (jdbcPrincipal == null) {
            if (LOG.isLoggable(Log.INFO)) {
                LOG.info("No DB connection found for: " + req.path());
            }
            errors.notFound();
        } else {
            request.setAttribute("jdbcPrincipal", (Object)jdbcPrincipal);
            DefaultServletResponseWrapper wrapper = new DefaultServletResponseWrapper(response, errors);
            try {
                if (DispatchLog.isEnabled()) {
                    DispatchLog.log("passing: " + req.path() + " to pl/sql gateway for pool: " + jdbcPrincipal);
                }
                this.defaultServlet.service(request, (HttpServletResponse)wrapper, this.getServletContext(), (ErrorResponse)errors);
            }
            catch (ConnectionPoolException e) {
                LOG.severe((Throwable)e);
                if (ConnectionPoolException.Error.DOES_NOT_EXIST == e.error()) {
                    errors.notFound();
                }
                errors.serviceUnavailable(e);
            }
        }
    }

    private final RequestDispatchers dispatchers() {
        return (RequestDispatchers)ServiceLocator.acquire(RequestDispatchers.class);
    }

    private WebErrorResponses errorResponses() {
        return (WebErrorResponses)ServiceLocator.acquire(WebErrorResponses.class);
    }

    private boolean isStandardPort(HttpServletRequest req) {
        return req.isSecure() && req.getServerPort() == 443 || req.getServerPort() == 80;
    }

    private LocalePreference localePreference(HttpServletRequest request) {
        String value = request.getHeader(HttpHeader.ACCEPT_LANGUAGE.text());
        return LocalePreference.preference(value);
    }

    private String location(URI baseUri, RedirectException e) {
        String redirect = e.redirectLocation();
        if (redirect == null) {
            return null;
        }
        URI absUri = URIs.resolve((URI)baseUri, (String)redirect);
        return absUri.toString();
    }

    private void redirect(HttpServletRequest request, HttpServletResponse response, RedirectException e) throws IOException {
        String[] baseAndPath = BaseAndPath.baseAndPath(request);
        String base = baseAndPath[0];
        URI baseUri = URIs.create((String)base);
        String location = this.location(baseUri, e);
        HttpStatusCode statusCode = e.statusCode();
        if (this.validateLocation(request, location)) {
            this.storeSessionState(request, e);
            if (HttpStatusCode.MOVED_PERMANENTLY.equals((Object)statusCode)) {
                response.setStatus(HttpStatusCode.MOVED_PERMANENTLY.statusCode());
                response.setHeader(HttpHeader.LOCATION.text(), location);
            } else {
                response.sendRedirect(location);
            }
        } else {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    private RequestEntity request(HttpServletRequest request) throws IOException {
        return Requests.request(request);
    }

    private void sendEntity(String path, Entity res, HttpServletResponse response) throws IOException {
        EntityHeaders headers = res.headers();
        String contentType = null;
        String location = null;
        for (String header : headers) {
            if (!header.toUpperCase().startsWith("X-APEX-")) {
                Iterable<String> values = headers.header(header).values();
                if (HttpHeader.CONTENT_TYPE.text().equalsIgnoreCase(header)) {
                    contentType = (String)Iterables.first(values);
                }
                if (HttpHeader.LOCATION.text().equalsIgnoreCase(header)) {
                    location = (String)Iterables.first(values);
                }
                for (String value : values) {
                    response.addHeader(header, value);
                }
            }
            if (contentType == null || !contentType.equals("content/unknown") || (contentType = location != null ? this.getServletContext().getMimeType(location) : this.getServletContext().getMimeType(path)) == null) continue;
            response.setHeader(HttpHeader.CONTENT_TYPE.text(), contentType);
        }
        Version.setServerHeader((HttpServletResponse)response);
        EntityHeader statusCode = headers.header("X-APEX-STATUS-CODE");
        if (statusCode != null) {
            response.setStatus(statusCode.intValue());
        }
        ServletOutputStream outputStream = response.getOutputStream();
        StreamCopy.drain((InputStream)res.body(), (OutputStream)outputStream);
        outputStream.flush();
    }

    private void storeSessionState(HttpServletRequest request, RedirectException e) {
        AssociativeArray<String, Object> servletSession = e.session();
        if (!NullOrEmpty.nullOrEmpty(servletSession)) {
            HttpSession session = request.getSession(true);
            for (String attributeName : servletSession) {
                session.setAttribute(attributeName, servletSession.get((Object)attributeName));
            }
        }
    }

    private boolean validateLocation(HttpServletRequest request, String location) {
        StringBuilder requestPath = new StringBuilder(request.getRequestURI());
        String queryString = request.getQueryString();
        if (queryString != null) {
            requestPath.append('?');
            requestPath.append(queryString);
        }
        return !requestPath.toString().equals(location);
    }

    private static class DefaultServletResponseWrapper
    extends HttpServletResponseWrapper {
        private final WebErrorResponse errorResponse;
        private static final String IGNORE_HEADER = "X-ORACLE-IGNORE";

        public void addHeader(String name, String value) {
            if (!IGNORE_HEADER.equalsIgnoreCase(name)) {
                super.addHeader(name, value);
            }
        }

        public DefaultServletResponseWrapper(HttpServletResponse response, WebErrorResponse errorResponse) {
            super(response);
            this.errorResponse = errorResponse;
        }

        public void flushBuffer() throws IOException {
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.errorResponse.getOutputStream(super.getOutputStream());
        }

        @Deprecated
        public void sendError(int sc) throws IOException {
            throw new IllegalStateException("Use ErrorResponse.error() instead");
        }

        @Deprecated
        public void sendError(int sc, String msg) throws IOException {
            throw new IllegalStateException("Use ErrorResponse.error() instead");
        }

        public void setStatus(int sc) {
            if (ErrorResponses.isError((int)sc)) {
                throw new IllegalStateException("Use ErrorResponse.error() instead");
            }
            super.setStatus(sc);
        }

        @Deprecated
        public void setStatus(int sc, String sm) {
            throw new IllegalStateException("Use ErrorResponse.error() if reporting an error or setStatus(int) otherwise");
        }
    }
}

