/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.tenants;

import java.security.Principal;
import oracle.dbtools.common.util.CompoundPrincipal;

public class TenantPrincipal
implements Principal {
    private final long id;
    private final String name;
    public static final long NO_TENANT_ID = -1L;
    public static final String NO_TENANT_NAME = "__no_tenant__";
    private static final TenantPrincipal NO_TENANT = new TenantPrincipal("__no_tenant__", -1L);

    private TenantPrincipal(String name, long id) {
        this.name = name;
        this.id = id;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TenantPrincipal other = (TenantPrincipal)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TenantPrincipal [name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }

    boolean hasTenant() {
        return this.id != -1L;
    }

    long id() {
        return this.id;
    }

    public static TenantPrincipal tenant(Principal principal) {
        TenantPrincipal tenant = null;
        if (principal instanceof TenantPrincipal) {
            tenant = (TenantPrincipal)principal;
        } else if (principal instanceof CompoundPrincipal) {
            tenant = (TenantPrincipal)((CompoundPrincipal)principal).principal(TenantPrincipal.class);
        }
        return tenant;
    }

    public static boolean hasTenant(TenantPrincipal tenant) {
        if (tenant == null) {
            return false;
        }
        return tenant.hasTenant();
    }

    public static long id(TenantPrincipal tenant) {
        if (tenant == null) {
            return -1L;
        }
        return tenant.id();
    }

    public static TenantPrincipal noTenant() {
        return NO_TENANT;
    }

    static TenantPrincipal tenant(String name, long id) {
        return new TenantPrincipal(name, id);
    }
}

