/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import com.sleepycat.persist.SecondaryIndex;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Tree;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.home.DataStore;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.ExistingEntity;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityStorage;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityTreeStorage;
import oracle.dbtools.rt.home.tenants.MultiTenantStorageDelegate;
import oracle.dbtools.rt.resource.templates.v2.EntityIds;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Service(provides={ResourceModules.class, ExistingEntity.class, EntityStorage.class}, properties={@Property(name="oracle.dbtools.rt.home.ExistingEntity", value="oracle.dbtools.rt.resource.templates.v2.ResourceModule")})
public class ResourceModules
implements ExistingEntity<ResourceModule>,
MultiTenantEntityStorage<ResourceModule> {
    @Reference
    MultiTenantEntityTreeStorage storage;
    private SecondaryIndex<String, MultiTenantEntityPK, ResourceModule> byName;
    private MultiTenantStorageDelegate<ResourceModule> modules;
    @Reference
    private DataStore store;

    @Override
    public Iterable<MultiTenantEntityPK> childIds(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK id) {
        return this.modules.childIds(txn, principal, id);
    }

    @Override
    public void delete(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK entityId) {
        this.modules.delete(txn, principal, entityId);
    }

    @Override
    public Iterable<ResourceModule> entities(Transaction txn, CompoundPrincipal principal) {
        return this.modules.entities(txn, principal);
    }

    @Override
    public ResourceModule entity(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK entityId) {
        return (ResourceModule)this.modules.entity(txn, principal, entityId);
    }

    @Override
    public ResourceModule exists(Transaction txn, CompoundPrincipal principal, ResourceModule instance) {
        ResourceModule existing = null;
        existing = (ResourceModule)this.byName.get(DataStore.unwrap(txn), (Object)instance.name(), null);
        if (EntityIds.sameParent(existing, instance)) {
            return existing;
        }
        return null;
    }

    public InputStream get(CompoundPrincipal principal, String id) {
        long entityId;
        long tenantId = TenantPrincipal.id(TenantPrincipal.tenant((Principal)principal));
        ResourceModule module = (ResourceModule)this.modules.entity(null, principal, MultiTenantEntityPK.key(tenantId, entityId = EntityIds.parseId(id)));
        if (module == null) {
            throw WebException.notFound();
        }
        return module.content();
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        return this.store.newTransaction();
    }

    public MultiTenantEntityPK store(CompoundPrincipal principal, MultiTenantEntityPK entityId, InputStream content, TreeReader<MultiTenantEntity> reader, StoreMode mode) {
        try {
            TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
            Tree entities = reader.read(principal, content);
            ResourceModule resourceModule = (ResourceModule)entities.node();
            if (mode != StoreMode.UPDATE && resourceModule.isDefaultModule()) {
                resourceModule.id(ResourceModule.defaultModuleId(tenant));
            }
            return this.storage.store(principal, entityId, entities, mode);
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    @Override
    public ResourceModule store(StoreMode storeMode, Transaction txn, CompoundPrincipal principal, ResourceModule instance) {
        return this.modules.store(storeMode, txn, principal, instance);
    }

    protected void activate(ServiceProperties properties) {
        this.modules = new MultiTenantStorageDelegate<ResourceModule>(this.store, ResourceModule.class, null);
        this.byName = this.modules.getSecondaryIndex(String.class, "name");
    }
}

