/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import com.sleepycat.persist.SecondaryIndex;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.home.DataStore;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.ExistingEntity;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityStorage;
import oracle.dbtools.rt.home.tenants.MultiTenantStorageDelegate;
import oracle.dbtools.rt.resource.templates.v2.EntityIds;
import oracle.dbtools.rt.resource.templates.v2.HasResourceTemplates;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.web.HttpMethod;

@Service(provides={ResourceHandlers.class, HasResourceTemplates.class, ExistingEntity.class, EntityStorage.class}, properties={@Property(name="oracle.dbtools.rt.home.ExistingEntity", value="oracle.dbtools.rt.resource.templates.v2.ResourceHandler")})
public class ResourceHandlers
implements ExistingEntity<ResourceHandler>,
MultiTenantEntityStorage<ResourceHandler> {
    private MultiTenantStorageDelegate<ResourceHandler> handlers;
    private SecondaryIndex<MultiTenantEntityPK, MultiTenantEntityPK, ResourceHandler> handlersByTemplate;
    @Reference
    private DataStore store;

    @Override
    public Iterable<MultiTenantEntityPK> childIds(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK id) {
        return this.handlers.childIds(txn, principal, id);
    }

    @Override
    public void delete(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK entityId) {
        this.handlers.delete(txn, principal, entityId);
    }

    @Override
    public Iterable<ResourceHandler> entities(Transaction txn, CompoundPrincipal principal) {
        return this.handlers.entities(txn, principal);
    }

    @Override
    public ResourceHandler entity(Transaction txn, CompoundPrincipal principal, MultiTenantEntityPK entityId) {
        return (ResourceHandler)this.handlers.entity(txn, principal, entityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceHandler exists(Transaction txn, CompoundPrincipal principal, ResourceHandler instance) {
        MultiTenantEntityPK templateId = instance.parentId();
        String method = instance.method();
        if (NullOrEmpty.nullOrEmpty((CharSequence)method)) {
            method = HttpMethod.GET.method();
        }
        ResourceHandler existing = null;
        Iterable<ResourceHandler> handlers = null;
        try {
            handlers = this.handlersByTemplate(txn, templateId);
            for (ResourceHandler h : handlers) {
                String handlerMethod = NullOrEmpty.nullOrEmpty((CharSequence)h.method()) ? HttpMethod.GET.method() : h.method();
                if (!handlerMethod.equalsIgnoreCase(method)) continue;
                existing = h;
                break;
            }
            if (EntityIds.sameParent(existing, instance)) {
                ResourceHandler resourceHandler = existing;
                return resourceHandler;
            }
        }
        finally {
            Closeables.close(handlers);
        }
        return null;
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        return this.store.newTransaction();
    }

    @Override
    public ResourceHandler store(StoreMode storeMode, Transaction txn, CompoundPrincipal principal, ResourceHandler instance) {
        return this.handlers.store(storeMode, txn, principal, instance);
    }

    protected void activate(ServiceProperties props) {
        this.handlers = new MultiTenantStorageDelegate<ResourceHandler>(this.store, ResourceHandler.class, "templateId");
        this.handlersByTemplate = this.handlers.getSecondaryIndex(MultiTenantEntityPK.class, "templateId");
    }

    Iterable<ResourceHandler> handlersByTemplate(Transaction txn, MultiTenantEntityPK id) {
        return DataStore.track(this.handlersByTemplate.entities(DataStore.unwrap(txn), (Object)id, true, (Object)id, true, null));
    }
}

