/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.x3p.ElementFilter;
import oracle.dbtools.common.x3p.MatchFilter;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PFilter;
import oracle.dbtools.common.x3p.X3PPath;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesProfile;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.SecurityConstraint;

public class ResourceHandlerReader {
    private final X3PPath contentPath;
    private final List<Reason> errors = new ArrayList<Reason>();
    private final X3PPath handlerPath;
    private final List<ResourceHandler.Builder> handlers = new ArrayList<ResourceHandler.Builder>();
    private final X3PPath parameterPath;
    public static final QName CONTENT = new QName("http://xmlns.oracle.com/apex/resource-template", "content");
    private static final String ACCEPT = "accept";
    private static final String ACCESS = "access";
    private static final String ALIASING = "aliasing";
    private static final String CONTENT_TYPE = "type";
    private static final String HEADER = "header";
    private static final String METHOD = "method";
    private static final String NAME = "name";
    private static final String PRIMITIVE_TYPE = "type";
    private static final String SECURITY_CONSTRAINT = "security-constraint";
    private static final String SOURCE = "source";

    public ResourceHandlerReader(X3PPath root) {
        this.contentPath = X3PPath.path((X3PPath)root, (QName[])new QName[]{CONTENT});
        this.parameterPath = X3PPath.path((X3PPath)root, (QName[])new QName[]{ResourceTemplatesProfile.PARAMETER});
        this.handlerPath = root;
    }

    public X3PFilter[] filters() {
        return new X3PFilter[]{new HandlerFilter(), new MethodFilter(), new ParameterFilter(), new ContentFilter()};
    }

    public Iterable<ResourceHandler> handlers() {
        return Iterables.transform(this.handlers, (Transform)new Transform<ResourceHandler.Builder, ResourceHandler>(){

            public ResourceHandler apply(ResourceHandler.Builder b) {
                return b.build();
            }
        });
    }

    private ResourceHandler.Builder current() {
        return this.handlers.get(this.handlers.size() - 1);
    }

    public void reset() {
        this.handlers.clear();
    }

    private class ParameterFilter
    extends ElementFilter {
        ParameterFilter() {
            super(new X3PPath[]{ResourceHandlerReader.this.parameterPath});
        }

        protected void element(X3PPath path, X3PAttributes atts, String text, X3PFilter.Mutator mutator) {
            String name;
            ResourceParameter.Kind type = ResourceParameter.Kind.URI;
            String source = atts.get(ResourceHandlerReader.SOURCE);
            if (ResourceHandlerReader.HEADER.equals(source)) {
                type = ResourceParameter.Kind.HEADER;
            }
            if ((name = atts.get(ResourceHandlerReader.NAME)) == null) {
                ResourceHandlerReader.this.errors.add(Reason.reason(path.toString(), new TranslatableMessage(ResourceTemplateMessages.class, "ResourceHandlerReader.1", "A {0} attribute must be supplied", new Object[]{ResourceHandlerReader.NAME})));
            }
            String aliasing = atts.get(ResourceHandlerReader.ALIASING);
            String primitiveType = atts.get("type");
            if (primitiveType == null) {
                primitiveType = "String";
            }
            ParameterAccess access = ParameterAccess.value((String)atts.get(ResourceHandlerReader.ACCESS));
            ResourceHandlerReader.this.current().parameter(type, name, aliasing, PrimitiveTypes.classOf((String)primitiveType), access);
        }
    }

    private class MethodFilter
    extends MatchFilter {
        MethodFilter() {
            super((Selector)ResourceHandlerReader.this.handlerPath);
        }

        protected void startElement(X3PPath path, X3PAttributes atts, X3PFilter.Mutator mutator) {
            String m = atts.get(ResourceHandlerReader.METHOD);
            if (m == null) {
                m = HttpMethod.GET.method();
            }
            ResourceHandlerReader.this.current().method(m);
        }
    }

    private class HandlerFilter
    extends MatchFilter {
        HandlerFilter() {
            super((Selector)ResourceHandlerReader.this.handlerPath);
        }

        protected void endElement(X3PPath path, X3PFilter.Mutator mutator) {
            if (!ResourceHandlerReader.this.current().hasContent()) {
                ResourceHandlerReader.this.errors.add(Reason.reason(path.toString(), new TranslatableMessage(ResourceTemplateMessages.class, "ResourceHandlerReader.2", "Must have a content element", new Object[0])));
            }
        }

        protected void startElement(X3PPath path, X3PAttributes atts, X3PFilter.Mutator mutator) {
            ResourceHandlerReader.this.handlers.add(ResourceHandler.builder());
            String contentType = atts.get("type");
            ResourceHandlerReader.this.current().contentType(contentType);
            String text = atts.get(ResourceHandlerReader.SECURITY_CONSTRAINT);
            ResourceHandlerReader.this.current().securityConstraint(SecurityConstraint.fromString(text));
            String pageSize = atts.get("page-size");
            if (pageSize != null) {
                ResourceHandlerReader.this.current().itemsPerPage((Integer)PrimitiveTypes.valueOf((String)pageSize, Integer.class));
            }
            if ((text = atts.get(ResourceHandlerReader.ACCEPT)) != null) {
                String[] accepts;
                for (String accept : accepts = Text.commaDelimited((String)text)) {
                    ResourceHandlerReader.this.current().acceptable(accept);
                }
            }
        }
    }

    private class ContentFilter
    extends ElementFilter {
        ContentFilter() {
            super(new X3PPath[]{ResourceHandlerReader.this.contentPath});
        }

        protected void element(X3PPath path, X3PAttributes atts, String text, X3PFilter.Mutator mutator) {
            if (text.trim().isEmpty()) {
                ResourceHandlerReader.this.errors.add(Reason.reason(path.toString(), new TranslatableMessage(ResourceTemplateMessages.class, "ResourceHandlerReader.0", "Content cannot be empty", new Object[0])));
            }
            ResourceHandlerReader.this.current().content(text);
        }
    }
}

