/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.MultiTenantEntity;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityTreeStorage;
import oracle.dbtools.rt.resource.templates.v2.ExportResourceModules;
import oracle.dbtools.rt.resource.templates.v2.ResourceModuleReader;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesProfile;
import oracle.dbtools.rt.validation.Validator;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.HttpResources;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;
import oracle.dbtools.rt.web.fileupload.FileUploadEntity;
import org.apache.commons.fileupload.FileItemStream;

@Service(provides={RequestDispatcher.class})
public class ImportResourceModules
extends RequestHandler {
    @Reference
    protected Validator validator;
    @Reference
    private MultiTenantEntityTreeStorage storage;
    static final String URI_TEMPLATE = ExportResourceModules.PATH;
    static final ContentType ZIP_MEDIA_TYPE = ContentType.contentType(ContentTypes.ZIP);
    private static final ContentType JAR_MEDIA_TYPE = ContentType.contentType("application/java-archive");
    private static final ContentType RESOURCE_MEDIA_TYPE = ContentType.contentType("application/vnd.oracle.apex+xml");

    public ImportResourceModules() {
        super(HttpMethod.POST, SECURE_RESOURCE_TEMPLATE, ExportResourceModules.URI_TEMPLATE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResource dispatch(RequestEntity request) throws IOException {
        Requests.acceptable(request, ZIP_MEDIA_TYPE);
        if (FileUploadEntity.isMultipartContent(request)) {
            FileUploadEntity uploads = FileUploadEntity.fileUpload(request);
            for (FileItemStream upload : uploads) {
                if (upload.isFormField()) continue;
                ContentType contentType = ContentType.contentType(upload.getContentType());
                InputStream content = null;
                try {
                    content = upload.openStream();
                    this.create(request.principal(), contentType, content);
                }
                finally {
                    Closeables.close((Object)content);
                }
            }
        } else {
            this.create(request.principal(), request.contentType(), request.body());
        }
        return HttpResources.created(ResourceTemplatesProfile.URI_TEMPLATES.collection().encode(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create(CompoundPrincipal principal, ContentType contentType, InputStream content) throws IOException {
        block4: {
            block5: {
                block3: {
                    if (null != contentType && !RESOURCE_MEDIA_TYPE.matches(contentType)) break block3;
                    this.create(principal, RESOURCE_MEDIA_TYPE, content, StoreMode.OVERWRITE);
                    break block4;
                }
                if (!ZIP_MEDIA_TYPE.matches(contentType) && !JAR_MEDIA_TYPE.matches(contentType)) break block5;
                ZipInputStream zip = null;
                try {
                    zip = new ZipInputStream(content);
                    IgnoreClose dontClose = new IgnoreClose(zip);
                    ZipEntry entry = zip.getNextEntry();
                    while (entry != null) {
                        this.create(principal, RESOURCE_MEDIA_TYPE, dontClose, StoreMode.OVERWRITE);
                        entry = zip.getNextEntry();
                    }
                }
                catch (Throwable throwable) {
                    Closeables.close(zip);
                    throw throwable;
                }
                Closeables.close((Object)zip);
                break block4;
            }
            throw WebException.unsupportedMediaType();
        }
    }

    protected void create(CompoundPrincipal principal, ContentType contentType, InputStream content, StoreMode mode) throws IOException {
        this.storage.store(principal, null, content, this.entityGraphReader(), mode);
    }

    protected TreeReader<MultiTenantEntity> entityGraphReader() {
        return new ResourceModuleReader(this.validator);
    }

    private final class IgnoreClose
    extends FilterInputStream {
        private IgnoreClose(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

