/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.jdbc;

import java.io.IOException;
import java.io.Reader;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.QueryProvider;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCResourceHandler;
import oracle.dbtools.rt.resource.templates.jdbc.JDBCResourceTemplate;
import oracle.dbtools.rt.resource.templates.v2.HasResourceTemplates;
import oracle.dbtools.rt.resource.templates.v2.ResourceHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplate;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.SecurityConstraint;
import oracle.dbtools.rt.web.WebException;

final class JDBCResourceTemplates
implements HasResourceTemplates {
    private final QueryProvider query;
    private static final String GET_HANDLER_DATA = "select handler_id, handler_source_type, handler_format, handler_method, handler_mimes_allowed, module_origins_allowed, items_per_page, handler_require_https , handler_source, module_uri_prefix, template_uri_template, template_priority, template_etag_type, template_etag_query, module_id, module_parsing_schema from wwv_flow_rt$services where security_group_id  = :tenant_id and template_id = :id and handler_method  = :method";
    private static final Statement GET_HANDLER_DATA_STMT = StatementBuilder.query().append((CharSequence)"select handler_id, handler_source_type, handler_format, handler_method, handler_mimes_allowed, module_origins_allowed, items_per_page, handler_require_https , handler_source, module_uri_prefix, template_uri_template, template_priority, template_etag_type, template_etag_query, module_id, module_parsing_schema from wwv_flow_rt$services where security_group_id  = :tenant_id and template_id = :id and handler_method  = :method").parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("id", Long.class, ParameterAccess.IN).parameter("method", String.class, ParameterAccess.IN).build();
    private static final String GET_PARAM_DATA = "select p.name,p.bind_variable_name,p.source_type,p.access_method,p.param_type from wwv_flow_rt$parameters p where p.security_group_id = :tenant_id and p.handler_id = :id";
    private static final Statement GET_PARAM_DATA_STMT = StatementBuilder.query().append((CharSequence)"select p.name,p.bind_variable_name,p.source_type,p.access_method,p.param_type from wwv_flow_rt$parameters p where p.security_group_id = :tenant_id and p.handler_id = :id").parameter("tenant_id", Long.class, ParameterAccess.IN).parameter("id", Long.class, ParameterAccess.IN).build();

    JDBCResourceTemplates(QueryProvider query) {
        this.query = query;
    }

    @Override
    public ResourceHandler etag(CompoundPrincipal principal, ResourceTemplate template) {
        return ((JDBCResourceTemplate)template).etag;
    }

    @Override
    public ResourceModule module(CompoundPrincipal principal, ResourceTemplate template) {
        return ((JDBCResourceTemplate)template).module;
    }

    @Override
    public ResourceHandler resourceHandler(CompoundPrincipal principal, MultiTenantEntityPK templateId, String method) {
        Iterator rows;
        long handlerId;
        long tenantId;
        JDBCResourceHandler.Builder b;
        JDBCPrincipal apexListener;
        block8: {
            apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
            b = JDBCResourceHandler.jdbcBuilder();
            tenantId = templateId.tenantId();
            handlerId = -1L;
            rows = null;
            try {
                ResourceHandler etag;
                String[] originsAllowed;
                String[] mimesAllowed;
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("tenant_id", templateId.tenantId());
                parameters.put("id", templateId.entityId());
                parameters.put("method", method.toUpperCase());
                rows = this.query.query((Principal)apexListener, GET_HANDLER_DATA_STMT, parameters);
                if (!rows.hasNext()) {
                    this.allowableMethods(templateId);
                    break block8;
                }
                ResultRow row = (ResultRow)rows.next();
                ColumnIterator columns = new ColumnIterator(row);
                handlerId = (Long)columns.next(Long.class);
                b.id(MultiTenantEntityPK.key(tenantId, handlerId));
                b.contentType(this.type((String)columns.next(String.class), (String)columns.next(String.class)));
                b.method((String)columns.next(String.class));
                for (String mime : mimesAllowed = Text.commaDelimited((String)((String)columns.next(String.class)))) {
                    b.acceptable(mime);
                }
                for (String origin : originsAllowed = Text.commaDelimited((String)((String)columns.next(String.class)))) {
                    b.originAllowed(origin);
                }
                Integer itemsPerPage = (Integer)columns.next(Integer.class);
                if (itemsPerPage != null) {
                    b.itemsPerPage(itemsPerPage);
                }
                SecurityConstraint securityConstraint = SecurityConstraint.fromString((String)columns.next(String.class));
                b.securityConstraint(securityConstraint);
                String content = StreamCopy.string((Reader)((Reader)columns.next(Reader.class)));
                b.content(content);
                JDBCResourceTemplate template = new JDBCResourceTemplate();
                template.id(templateId);
                template.pattern(this.pattern((String)columns.next(String.class), (String)columns.next(String.class)));
                template.priority((Integer)columns.next(Integer.class));
                template.etag = etag = this.etag((String)columns.next(String.class), (String)columns.next(String.class));
                b.template(template);
                ResourceModule module = new ResourceModule();
                long entityId = (Long)columns.next(Long.class);
                MultiTenantEntityPK moduleId = MultiTenantEntityPK.key(templateId.tenantId(), entityId);
                template.parentId(moduleId);
                module.id(moduleId);
                module.parsingSchema((String)columns.next(String.class));
                b.module(module);
            }
            catch (IOException e) {
                try {
                    throw WebException.internalError(e, new Reason[0]);
                }
                catch (Throwable throwable) {
                    Closeables.close(rows);
                    throw throwable;
                }
            }
        }
        Closeables.close((Object)rows);
        this.parameters(apexListener, tenantId, handlerId, b);
        return b.build();
    }

    @Override
    public ResourceTemplate resourceTemplate(CompoundPrincipal principal, ResourceHandler handler) {
        return ((JDBCResourceHandler)handler).template;
    }

    @Override
    public ResourceTemplate resourceTemplate(CompoundPrincipal principal, String path) {
        throw new UnsupportedOperationException("not expecting this to be called");
    }

    private void allowableMethods(MultiTenantEntityPK templateId) {
    }

    private ResourceHandler etag(String type, String query) {
        String content = "";
        if ("NONE".equals(type)) {
            return null;
        }
        content = "HASH".equals(type) ? "" : query;
        ResourceHandler h = new ResourceHandler();
        h.etag();
        h.content(content);
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parameters(JDBCPrincipal principal, long tenantId, long handlerId, JDBCResourceHandler.Builder b) {
        Iterator rows = null;
        try {
            HashMap<String, Long> parameters = new HashMap<String, Long>();
            parameters.put("tenant_id", tenantId);
            parameters.put("id", handlerId);
            rows = this.query.query((Principal)principal, GET_PARAM_DATA_STMT, parameters);
            while (rows.hasNext()) {
                ResultRow row = (ResultRow)rows.next();
                ColumnIterator columns = new ColumnIterator(row);
                String name = (String)columns.next(String.class);
                String alias = (String)columns.next(String.class);
                ResourceParameter.Kind kind = ResourceParameter.Kind.HEADER;
                String source = (String)columns.next(String.class);
                if ("URI".equals(source) || "RESPONSE".equals(source)) {
                    kind = ResourceParameter.Kind.URI;
                }
                ParameterAccess access = ParameterAccess.value((String)((String)columns.next(String.class)));
                Class<?> type = this.type((String)columns.next(String.class));
                b.parameter(kind, name, alias, type, access);
            }
        }
        catch (Throwable throwable) {
            Closeables.close(rows);
            throw throwable;
        }
        Closeables.close((Object)rows);
    }

    private String pattern(String uriPrefix, String pattern) {
        if (uriPrefix != null) {
            return uriPrefix.trim() + pattern;
        }
        return pattern;
    }

    private Class<?> type(String paramType) {
        if ("STRING".equals(paramType)) {
            return String.class;
        }
        if ("INT".equals(paramType)) {
            return Integer.class;
        }
        if ("DOUBLE".equals(paramType)) {
            return Double.class;
        }
        if ("BOOLEAN".equals(paramType)) {
            return Boolean.class;
        }
        if ("LONG".equals(paramType)) {
            return Long.class;
        }
        if ("TIMESTAMP".equals(paramType)) {
            return Timestamp.class;
        }
        return String.class;
    }

    private String type(String type, String format) {
        String contentType = "oracle.dbtools.rt.web.ResourceGenerator";
        if ("QUERY".equals(type)) {
            contentType = "CSV".equals(format) ? "csv/query" : "json/query";
        } else if ("QUERY_1_ROW".equals(type)) {
            contentType = "json/query;type=single";
        } else if ("PLSQL".equals(type)) {
            contentType = "plsql/block";
        } else if ("FEED".equals(type)) {
            contentType = "json/query;type=feed";
        }
        return contentType;
    }
}

