/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Collections;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.resource.templates.ResourceHandler;
import oracle.dbtools.rt.resource.templates.ResourceMetaData;
import oracle.dbtools.rt.resource.templates.ResourceParameter;
import oracle.dbtools.rt.uri.HasURITemplate;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.ValidURITemplate;
import oracle.dbtools.rt.validation.NotNull;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Deprecated
@Entity
class ResourceTemplate
implements HasURITemplate {
    @NotNull
    private String content;
    private ResourceMetaData metaData;
    @SecondaryKey(relate=Relationship.ONE_TO_ONE)
    @ValidURITemplate
    @NotNull
    private String pattern;
    private int priority;
    @PrimaryKey(sequence="ResourceTemplate")
    private long templateId;

    ResourceTemplate(long created) {
        this.metaData = new ResourceMetaData(created);
    }

    private ResourceTemplate() {
    }

    public Map<String, Object> inboundValues(ResourceHandler handler, String uri, EntityHeaders headers) {
        URITemplate template = this.uriTemplate();
        Map<String, String> params = template.decode(uri);
        LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
        Set<String> implicit = this.implicitParameterNames(handler);
        for (String name : implicit) {
            bindings.put(name, params.get(name));
        }
        for (ResourceParameter binding : handler.inbound()) {
            String value = null;
            if (ResourceParameter.Kind.HEADER.equals((Object)binding.kind())) {
                EntityHeader header = headers.header(binding.aliasing());
                if (header == null) continue;
                value = header.value();
                Object primitive = PrimitiveTypes.valueOf((String)value, binding.primitiveType());
                bindings.put(binding.name(), primitive);
                continue;
            }
            value = params.get(binding.aliasing());
            Object primitive = PrimitiveTypes.valueOf((String)value, binding.primitiveType());
            bindings.put(binding.name(), primitive);
        }
        return bindings;
    }

    @Override
    public URITemplate uriTemplate() {
        if (this.pattern == null) {
            return null;
        }
        return new URITemplate(this.pattern, this.priority);
    }

    InputStream content() {
        InputStream content = null;
        try {
            content = StreamCopy.toInputStream((String)this.content);
        }
        catch (IOException e) {
            WebException.internalError(e, new Reason[0]);
            Closeables.close((Object)content);
        }
        return content;
    }

    void content(InputStream content) {
        try {
            this.content = StreamCopy.string((InputStream)content);
        }
        catch (IOException e) {
            WebException.internalError(e, new Reason[0]);
        }
    }

    Set<String> implicitParameterNames(ResourceHandler handler) {
        URITemplate template = this.uriTemplate();
        LinkedHashSet<String> implicit = new LinkedHashSet<String>();
        implicit.addAll(template.parameters());
        Iterator<String> explicit = this.explicitParameters(handler);
        Collections.removeAll(implicit, explicit);
        return implicit;
    }

    void modified(long when) {
        this.metaData.modified(when);
    }

    void pattern(String pattern) {
        this.pattern = pattern;
    }

    void priority(int priority) {
        this.priority = priority;
    }

    long templateId() {
        return this.templateId;
    }

    void templateId(long existing) {
        this.templateId = existing;
    }

    private Iterator<String> explicitParameters(ResourceHandler handler) {
        return Iterators.transform((Iterator)Iterators.iterator((Object[])handler.parameters()), (Transform)new Transform<ResourceParameter, String>(){

            public String apply(ResourceParameter x) {
                return x.aliasing();
            }
        });
    }
}

