/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.x3p.X3PFactory;
import oracle.dbtools.common.x3p.X3PFilter;
import oracle.dbtools.common.x3p.X3PFilterChain;
import oracle.dbtools.common.x3p.X3PPath;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.X3PWriterOptions;
import oracle.dbtools.rt.resource.templates.InsertTemplates;
import oracle.dbtools.rt.resource.templates.ResourceTemplate;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

abstract class DefaultModule {
    DefaultModule() {
    }

    static InputStream toInputStream(Iterable<ResourceTemplate> templates) {
        Iterable<X3PReader> xml = null;
        try {
            xml = DefaultModule.xml(templates);
            X3PFilterChain chain = X3PFactory.chain((X3PFilter[])new X3PFilter[]{new InsertTemplates(xml)});
            X3PReader r = chain.filter(X3PFactory.compose((X3PReader[])new X3PReader[]{X3PFactory.newReader((InputStream)DefaultModule.defaultModule())}));
            return X3PFactory.newStream((X3PReader)r, (X3PWriterOptions)new X3PWriterOptions(false, false, new X3PPath[0]));
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    private static InputStream defaultModule() throws IOException {
        return StreamCopy.toInputStream((String)"<module xmlns=\"http://xmlns.oracle.com/apex/resource-template\"/>");
    }

    private static Iterable<X3PReader> xml(Iterable<ResourceTemplate> templates) {
        return Iterables.transform(templates, (Transform)new Transform<ResourceTemplate, X3PReader>(){

            public X3PReader apply(ResourceTemplate x) {
                X3PReader r;
                try {
                    r = X3PFactory.newReader((InputStream)x.content());
                }
                catch (IOException e) {
                    throw WebException.internalError(e, new Reason[0]);
                }
                return r;
            }
        });
    }
}

